package io.qt.sensors;

import io.qt.*;


/**
 * <p>The pure virtual interface to sensor gesture plugins</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qsensorgestureplugininterface.html">QSensorGesturePluginInterface</a></p>
 */
public interface QSensorGesturePluginInterface extends QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.sensors.QSensorGesturePluginInterface}</p>
     */
    public static abstract class Impl extends QtObject
        implements io.qt.sensors.QSensorGesturePluginInterface
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @NativeAccess
        private static final class ConcreteWrapper extends QSensorGesturePluginInterface.Impl {
            
            @NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @QtUninvokable
            public java.util.@NonNull List<io.qt.sensors.@Nullable QSensorGestureRecognizer> createRecognizers(){
                return createRecognizers_native(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.util.List<io.qt.sensors.QSensorGestureRecognizer> createRecognizers_native(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public java.lang.@NonNull String name(){
                return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.lang.String name_native_constfct(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public java.util.@NonNull List<java.lang.@NonNull String> supportedIds(){
                return supportedIds_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.util.List<java.lang.String> supportedIds_native_constfct(long __this__nativeId);
            
        }
        
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsensorgestureplugininterface.html#QSensorGesturePluginInterface">QSensorGesturePluginInterface::QSensorGesturePluginInterface()</a></p>
         */
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QSensorGesturePluginInterface instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsensorgestureplugininterface.html#createRecognizers">QSensorGesturePluginInterface::createRecognizers()</a></p>
         */
        @QtUninvokable
        public abstract java.util.@NonNull List<io.qt.sensors.@Nullable QSensorGestureRecognizer> createRecognizers();
        
        private native static java.util.List<io.qt.sensors.QSensorGestureRecognizer> createRecognizers_native(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsensorgestureplugininterface.html#name">QSensorGesturePluginInterface::name()const</a></p>
         */
        @QtUninvokable
        public abstract java.lang.@NonNull String name();
        
        private native static java.lang.String name_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsensorgestureplugininterface.html#supportedIds">QSensorGesturePluginInterface::supportedIds()const</a></p>
         */
        @QtUninvokable
        public abstract java.util.@NonNull List<java.lang.@NonNull String> supportedIds();
        
        private native static java.util.List<java.lang.String> supportedIds_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorgestureplugininterface.html#createRecognizers">QSensorGesturePluginInterface::createRecognizers()</a></p>
     */
    @QtUninvokable
    public java.util.@NonNull List<io.qt.sensors.@Nullable QSensorGestureRecognizer> createRecognizers();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorgestureplugininterface.html#name">QSensorGesturePluginInterface::name()const</a></p>
     */
    @QtUninvokable
    public java.lang.@NonNull String name();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorgestureplugininterface.html#supportedIds">QSensorGesturePluginInterface::supportedIds()const</a></p>
     */
    @QtUninvokable
    public java.util.@NonNull List<java.lang.@NonNull String> supportedIds();
    
}
