package io.qt.sensors;

import io.qt.*;


/**
 * <p>Manages sensor gestures, registers and creates sensor gesture plugins</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qsensorgesturemanager.html">QSensorGestureManager</a></p>
 */
public class QSensorGestureManager extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSensorGestureManager.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorgesturemanager.html#newSensorGestureAvailable">QSensorGestureManager::newSensorGestureAvailable()</a></p>
     */
    public final @NonNull Signal0 newSensorGestureAvailable = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSensorGestureManager() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorgesturemanager.html#QSensorGestureManager">QSensorGestureManager::QSensorGestureManager(QObject*)</a></p>
     */
    public QSensorGestureManager(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSensorGestureManager instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorgesturemanager.html#gestureIds">QSensorGestureManager::gestureIds()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList gestureIds(){
        return gestureIds_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList gestureIds_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorgesturemanager.html#recognizerSignals">QSensorGestureManager::recognizerSignals(QString)const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList recognizerSignals(java.lang.@NonNull String recognizerId){
        return recognizerSignals_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), recognizerId);
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList recognizerSignals_native_cref_QString_constfct(long __this__nativeId, java.lang.String recognizerId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorgesturemanager.html#registerSensorGestureRecognizer">QSensorGestureManager::registerSensorGestureRecognizer(QSensorGestureRecognizer*)</a></p>
     */
    @QtUninvokable
    public final boolean registerSensorGestureRecognizer(io.qt.sensors.@Nullable QSensorGestureRecognizer recognizer){
        return registerSensorGestureRecognizer_native_QSensorGestureRecognizer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(recognizer));
    }
    
    @QtUninvokable
    private native boolean registerSensorGestureRecognizer_native_QSensorGestureRecognizer_ptr(long __this__nativeId, long recognizer);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorgesturemanager.html#sensorGestureRecognizer">QSensorGestureManager::sensorGestureRecognizer(QString)</a></p>
     */
    public native static io.qt.sensors.@Nullable QSensorGestureRecognizer sensorGestureRecognizer(java.lang.@NonNull String id);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSensorGestureManager(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSensorGestureManager(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSensorGestureManager instance, QDeclarativeConstructor constructor);
    
}
