package io.qt.sensors;

import io.qt.*;


/**
 * <p>Efficient callback facility for asynchronous notifications of sensor changes</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qsensorfilter.html">QSensorFilter</a></p>
 * <p>Following functions are protected in the Qt interface, all implementations of this interface may implement these function:</p>
 * <br>
 * <code>
 * &commat;QtUninvokable<br>
 * protected void setSensor(io.qt.sensors.&commat;Nullable QSensor sensor){<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;QSensorFilter.MemberAccess.of(this).setSensor(sensor);<br>
 * }<br>
 * <br>
 * &commat;QtUninvokable<br>
 * protected final io.qt.sensors.&commat;Nullable QSensor getSensor() {<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;return sensor();<br>
 * }<br>
 * <br>
 * &commat;QtUninvokable<br>
 * protected final io.qt.sensors.&commat;Nullable QSensor sensor(){<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;return QSensorFilter.MemberAccess.of(this).sensor();<br>
 * }<br>
 * <br>
 * </code>
 */
public interface QSensorFilter extends QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.sensors.QSensorFilter}</p>
     */
    public static abstract class Impl extends QtObject
        implements io.qt.sensors.QSensorFilter
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @QtPropertyMember(enabled=false)
        private Object __rcSensor = null;
        
        @NativeAccess
        private static final class ConcreteWrapper extends QSensorFilter.Impl {
            
            @NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @QtUninvokable
            public boolean filter(io.qt.sensors.@Nullable QSensorReading reading){
                return filter_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(reading));
            }
            private native static boolean filter_native_QSensorReading_ptr(long __this__nativeId, long reading);
            
        }
        
        
        protected Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QSensorFilter instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsensorfilter.html#filter">QSensorFilter::filter(QSensorReading*)</a></p>
         */
        @QtUninvokable
        public abstract boolean filter(io.qt.sensors.@Nullable QSensorReading reading);
        
        private native static boolean filter_native_QSensorReading_ptr(long __this__nativeId, long reading);
        
        @QtUninvokable
        protected void setSensor(io.qt.sensors.@Nullable QSensor sensor){
            setSensor_native_QSensor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sensor));
            __rcSensor = sensor;
        }
        
        private native static void setSensor_native_QSensor_ptr(long __this__nativeId, long sensor);
        
        /**
         * <p>Kotlin property getter. In Java use {@link #sensor()} instead.</p>
         */
        @QtUninvokable
        protected final io.qt.sensors.@Nullable QSensor getSensor() {
            return sensor();
        }
        
        @QtUninvokable
        protected final io.qt.sensors.@Nullable QSensor sensor(){
            return sensor_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native io.qt.sensors.QSensor sensor_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorfilter.html#filter">QSensorFilter::filter(QSensorReading*)</a></p>
     */
    @QtUninvokable
    public boolean filter(io.qt.sensors.@Nullable QSensorReading reading);
    
    public static class MemberAccess extends io.qt.MemberAccess<QSensorFilter> {
        private MemberAccess(QSensorFilter instance){
            super(instance);
        }
        
        @QtUninvokable
        public void setSensor(io.qt.sensors.@Nullable QSensor sensor){
            QSensorFilter instance = instance();
            QSensorFilter.Impl.setSensor_native_QSensor_ptr(QtJambi_LibraryUtilities.internal.nativeId(instance), QtJambi_LibraryUtilities.internal.checkedNativeId(sensor));
            QtJambi_LibraryUtilities.internal.setReferenceCount(instance, io.qt.sensors.QSensorFilter.class, "__rcSensor", false, false, sensor);
        }
        
        public static MemberAccess of(QSensorFilter instance){
            Class<?> callerClass = QtJambi_LibraryUtilities.internal.callerClassProvider().get();
            if(!QSensorFilter.class.isAssignableFrom(callerClass) || !callerClass.isInstance(instance))
                throw new RuntimeException("Access to restricted functions of class QSensorFilter is only granted from inside a user-implemented subclass.");
            return QtJambi_LibraryUtilities.internal.findMemberAccess(instance, QSensorFilter.class, MemberAccess.class);
        }
    }
}
