package io.qt.sensors;

import io.qt.*;


/**
 * <p>The pure virtual interface to sensor plugins</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qsensorchangesinterface.html">QSensorChangesInterface</a></p>
 */
public interface QSensorChangesInterface extends QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.sensors.QSensorChangesInterface}</p>
     */
    public static abstract class Impl extends QtObject
        implements io.qt.sensors.QSensorChangesInterface
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @NativeAccess
        private static final class ConcreteWrapper extends QSensorChangesInterface.Impl {
            
            @NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @QtUninvokable
            public void sensorsChanged(){
                sensorsChanged_native(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static void sensorsChanged_native(long __this__nativeId);
            
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QSensorChangesInterface instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsensorchangesinterface.html#sensorsChanged">QSensorChangesInterface::sensorsChanged()</a></p>
         */
        @QtUninvokable
        public abstract void sensorsChanged();
        
        private native static void sensorsChanged_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorchangesinterface.html#sensorsChanged">QSensorChangesInterface::sensorsChanged()</a></p>
     */
    @QtUninvokable
    public void sensorsChanged();
    
}
