package io.qt.sensors;

import io.qt.*;


/**
 * <p>Sensor implementation</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qsensorbackend.html">QSensorBackend</a></p>
 */
public abstract class QSensorBackend extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSensorBackend.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QSensorBackend {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public void start(){
            start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void start_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void stop(){
            stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void stop_native(long __this__nativeId);
        
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.sensors.QSensor, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSensorBackend(io.qt.sensors.@Nullable QSensor sensor) {
        this(sensor, (io.qt.core.QObject)null);
    }
    
    public QSensorBackend(io.qt.sensors.@Nullable QSensor sensor, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, sensor, parent);
    }
    
    private native static void initialize_native(QSensorBackend instance, io.qt.sensors.QSensor sensor, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#addDataRate">QSensorBackend::addDataRate(qreal,qreal)</a></p>
     */
    @QtUninvokable
    public final void addDataRate(double min, double max){
        addDataRate_native_qreal_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), min, max);
    }
    
    @QtUninvokable
    private native void addDataRate_native_qreal_qreal(long __this__nativeId, double min, double max);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#addOutputRange">QSensorBackend::addOutputRange(qreal,qreal,qreal)</a></p>
     */
    @QtUninvokable
    public final void addOutputRange(double min, double max, double accuracy){
        addOutputRange_native_qreal_qreal_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), min, max, accuracy);
    }
    
    @QtUninvokable
    private native void addOutputRange_native_qreal_qreal_qreal(long __this__nativeId, double min, double max, double accuracy);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#newReadingAvailable">QSensorBackend::newReadingAvailable()</a></p>
     */
    @QtUninvokable
    public final void newReadingAvailable(){
        newReadingAvailable_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void newReadingAvailable_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#reading">QSensorBackend::reading()const</a></p>
     */
    @QtUninvokable
    public final io.qt.sensors.@Nullable QSensorReading reading(){
        return reading_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sensors.QSensorReading reading_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#sensor">QSensorBackend::sensor()const</a></p>
     */
    @QtUninvokable
    public final io.qt.sensors.@Nullable QSensor sensor(){
        return sensor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sensors.QSensor sensor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#sensorBusy">QSensorBackend::sensorBusy()</a></p>
     */
    @QtUninvokable
    public final void sensorBusy(){
        sensorBusy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void sensorBusy_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#sensorError">QSensorBackend::sensorError(int)</a></p>
     */
    @QtUninvokable
    public final void sensorError(int error){
        sensorError_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), error);
    }
    
    @QtUninvokable
    private native void sensorError_native_int(long __this__nativeId, int error);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#sensorStopped">QSensorBackend::sensorStopped()</a></p>
     */
    @QtUninvokable
    public final void sensorStopped(){
        sensorStopped_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void sensorStopped_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#setDataRates">QSensorBackend::setDataRates(const QSensor*)</a></p>
     */
    @QtUninvokable
    public final void setDataRates(io.qt.sensors.@Nullable QSensor otherSensor){
        setDataRates_native_const_QSensor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(otherSensor));
    }
    
    @QtUninvokable
    private native void setDataRates_native_const_QSensor_ptr(long __this__nativeId, long otherSensor);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#setDescription">QSensorBackend::setDescription(QString)</a></p>
     */
    @QtUninvokable
    public final void setDescription(java.lang.@NonNull String description){
        setDescription_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), description);
    }
    
    @QtUninvokable
    private native void setDescription_native_cref_QString(long __this__nativeId, java.lang.String description);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#setReading">QSensorBackend::setReading(T*)</a></p>
     */
    @QtUninvokable
    public final <T extends io.qt.sensors.QSensorReading> @StrictNonNull T setReading(java.lang.@StrictNonNull Class<T> readingClass){
        java.util.Objects.requireNonNull(readingClass, "Argument 'readingClass': null not expected.");
        return setReading_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), readingClass);
    }
    
    @QtUninvokable
    private native <T extends io.qt.sensors.QSensorReading> T setReading_native_QObject_ptr(long __this__nativeId, java.lang.Class<T> readingClass);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#setReading">QSensorBackend::setReading(T*)</a></p>
     */
    @QtUninvokable
    public final <T extends io.qt.sensors.QSensorReading> @StrictNonNull T setReading(@StrictNonNull T readingClass){
        java.util.Objects.requireNonNull(readingClass, "Argument 'readingClass': null not expected.");
        return setReading_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), readingClass);
    }
    
    @QtUninvokable
    private native <T extends io.qt.sensors.QSensorReading> T setReading_native_QSensorReading_ptr(long __this__nativeId, T readingClass);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#isFeatureSupported">QSensorBackend::isFeatureSupported(QSensor::Feature)const</a></p>
     */
    @QtUninvokable
    public boolean isFeatureSupported(io.qt.sensors.QSensor.@NonNull Feature feature){
        return isFeatureSupported_native_QSensor_Feature_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), feature.value());
    }
    
    @QtUninvokable
    private native boolean isFeatureSupported_native_QSensor_Feature_constfct(long __this__nativeId, int feature);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#start">QSensorBackend::start()</a></p>
     */
    @QtUninvokable
    public abstract void start();
    
    @QtUninvokable
    private native void start_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorbackend.html#stop">QSensorBackend::stop()</a></p>
     */
    @QtUninvokable
    public abstract void stop();
    
    @QtUninvokable
    private native void stop_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSensorBackend(QPrivateConstructor p) { super(p); } 
    
}
