package io.qt.sensors;

import io.qt.*;


/**
 * <p>Represents one reading from the rotation sensor</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qrotationreading.html">QRotationReading</a></p>
 */
public class QRotationReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRotationReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QRotationReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QRotationReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRotationReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>Sets the rotation from three euler angles</p>
     * <p>See <a href="http://doc.qt.io/qt-5/qrotationreading.html#setFromEuler">QRotationReading::setFromEuler(qreal,qreal,qreal)</a></p>
     */
    @QtUninvokable
    public final void setFromEuler(double x, double y, double z){
        setFromEuler_native_qreal_qreal_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void setFromEuler_native_qreal_qreal_qreal(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #x()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getX() {
        return x();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qrotationreading.html#x-prop">QRotationReading::x()const</a></p>
     */
    @QtPropertyReader(name="x")
    @QtUninvokable
    public final double x(){
        return x_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double x_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #y()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getY() {
        return y();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qrotationreading.html#y-prop">QRotationReading::y()const</a></p>
     */
    @QtPropertyReader(name="y")
    @QtUninvokable
    public final double y(){
        return y_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double y_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #z()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getZ() {
        return z();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qrotationreading.html#z-prop">QRotationReading::z()const</a></p>
     */
    @QtPropertyReader(name="z")
    @QtUninvokable
    public final double z(){
        return z_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double z_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QRotationReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRotationReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRotationReading instance, QDeclarativeConstructor constructor);
    
}
