package io.qt.sensors;

import io.qt.*;


/**
 * <p>Holds readings from the pressure sensor</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qpressurereading.html">QPressureReading</a></p>
 */
public class QPressureReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPressureReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QPressureReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QPressureReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPressureReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #pressure()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getPressure() {
        return pressure();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpressurereading.html#pressure-prop">QPressureReading::pressure()const</a></p>
     */
    @QtPropertyReader(name="pressure")
    @QtUninvokable
    public final double pressure(){
        return pressure_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double pressure_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpressurereading.html#setPressure">QPressureReading::setPressure(qreal)</a></p>
     */
    @QtUninvokable
    public final void setPressure(double pressure){
        setPressure_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), pressure);
    }
    
    @QtUninvokable
    private native void setPressure_native_qreal(long __this__nativeId, double pressure);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpressurereading.html#setTemperature">QPressureReading::setTemperature(qreal)</a></p>
     */
    @QtUninvokable
    public final void setTemperature(double temperature){
        setTemperature_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), temperature);
    }
    
    @QtUninvokable
    private native void setTemperature_native_qreal(long __this__nativeId, double temperature);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #temperature()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getTemperature() {
        return temperature();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpressurereading.html#temperature-prop">QPressureReading::temperature()const</a></p>
     */
    @QtPropertyReader(name="temperature")
    @QtUninvokable
    public final double temperature(){
        return temperature_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double temperature_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QPressureReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QPressureReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPressureReading instance, QDeclarativeConstructor constructor);
    
}
