package io.qt.sensors;

import io.qt.*;


/**
 * <p>Represents one reading from the orientation sensor</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qorientationreading.html">QOrientationReading</a></p>
 */
public class QOrientationReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOrientationReading.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qorientationreading.html#Orientation-enum">QOrientationReading::Orientation</a></p>
     */
    @QtUnlistedEnum
    public enum Orientation implements QtEnumerator {
        Undefined(0),
        TopUp(1),
        TopDown(2),
        LeftUp(3),
        RightUp(4),
        FaceUp(5),
        FaceDown(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Orientation(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Orientation resolve(int value) {
            switch (value) {
            case 0: return Undefined;
            case 1: return TopUp;
            case 2: return TopDown;
            case 3: return LeftUp;
            case 4: return RightUp;
            case 5: return FaceUp;
            case 6: return FaceDown;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QOrientationReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QOrientationReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QOrientationReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #orientation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.sensors.QOrientationReading.@NonNull Orientation getOrientation() {
        return orientation();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qorientationreading.html#orientation-prop">QOrientationReading::orientation()const</a></p>
     */
    @QtPropertyReader(name="orientation")
    @QtUninvokable
    public final io.qt.sensors.QOrientationReading.@NonNull Orientation orientation(){
        return io.qt.sensors.QOrientationReading.Orientation.resolve(orientation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int orientation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qorientationreading.html#setOrientation">QOrientationReading::setOrientation(QOrientationReading::Orientation)</a></p>
     */
    @QtUninvokable
    public final void setOrientation(io.qt.sensors.QOrientationReading.@NonNull Orientation orientation){
        setOrientation_native_QOrientationReading_Orientation(QtJambi_LibraryUtilities.internal.nativeId(this), orientation.value());
    }
    
    @QtUninvokable
    private native void setOrientation_native_QOrientationReading_Orientation(long __this__nativeId, int orientation);
    
    @QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QOrientationReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QOrientationReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QOrientationReading instance, QDeclarativeConstructor constructor);
    
}
