package io.qt.sensors;

import io.qt.*;


/**
 * <p>Represents one reading from the magnetometer</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qmagnetometerreading.html">QMagnetometerReading</a></p>
 */
public class QMagnetometerReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMagnetometerReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QMagnetometerReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QMagnetometerReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMagnetometerReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #calibrationLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getCalibrationLevel() {
        return calibrationLevel();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmagnetometerreading.html#calibrationLevel-prop">QMagnetometerReading::calibrationLevel()const</a></p>
     */
    @QtPropertyReader(name="calibrationLevel")
    @QtUninvokable
    public final double calibrationLevel(){
        return calibrationLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double calibrationLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmagnetometerreading.html#setCalibrationLevel">QMagnetometerReading::setCalibrationLevel(qreal)</a></p>
     */
    @QtUninvokable
    public final void setCalibrationLevel(double calibrationLevel){
        setCalibrationLevel_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), calibrationLevel);
    }
    
    @QtUninvokable
    private native void setCalibrationLevel_native_qreal(long __this__nativeId, double calibrationLevel);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmagnetometerreading.html#setX">QMagnetometerReading::setX(qreal)</a></p>
     */
    @QtUninvokable
    public final void setX(double x){
        setX_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), x);
    }
    
    @QtUninvokable
    private native void setX_native_qreal(long __this__nativeId, double x);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmagnetometerreading.html#setY">QMagnetometerReading::setY(qreal)</a></p>
     */
    @QtUninvokable
    public final void setY(double y){
        setY_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), y);
    }
    
    @QtUninvokable
    private native void setY_native_qreal(long __this__nativeId, double y);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmagnetometerreading.html#setZ">QMagnetometerReading::setZ(qreal)</a></p>
     */
    @QtUninvokable
    public final void setZ(double z){
        setZ_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), z);
    }
    
    @QtUninvokable
    private native void setZ_native_qreal(long __this__nativeId, double z);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #x()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getX() {
        return x();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmagnetometerreading.html#x-prop">QMagnetometerReading::x()const</a></p>
     */
    @QtPropertyReader(name="x")
    @QtUninvokable
    public final double x(){
        return x_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double x_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #y()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getY() {
        return y();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmagnetometerreading.html#y-prop">QMagnetometerReading::y()const</a></p>
     */
    @QtPropertyReader(name="y")
    @QtUninvokable
    public final double y(){
        return y_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double y_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #z()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getZ() {
        return z();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmagnetometerreading.html#z-prop">QMagnetometerReading::z()const</a></p>
     */
    @QtPropertyReader(name="z")
    @QtUninvokable
    public final double z(){
        return z_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double z_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QMagnetometerReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QMagnetometerReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QMagnetometerReading instance, QDeclarativeConstructor constructor);
    
}
