package io.qt.sensors;

import io.qt.*;


/**
 * <p>Holds readings from the humidity sensor</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qhumidityreading.html">QHumidityReading</a></p>
 */
public class QHumidityReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHumidityReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHumidityReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QHumidityReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QHumidityReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #absoluteHumidity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getAbsoluteHumidity() {
        return absoluteHumidity();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhumidityreading.html#absoluteHumidity-prop">QHumidityReading::absoluteHumidity()const</a></p>
     */
    @QtPropertyReader(name="absoluteHumidity")
    @QtUninvokable
    public final double absoluteHumidity(){
        return absoluteHumidity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double absoluteHumidity_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #relativeHumidity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getRelativeHumidity() {
        return relativeHumidity();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhumidityreading.html#relativeHumidity-prop">QHumidityReading::relativeHumidity()const</a></p>
     */
    @QtPropertyReader(name="relativeHumidity")
    @QtUninvokable
    public final double relativeHumidity(){
        return relativeHumidity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double relativeHumidity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhumidityreading.html#setAbsoluteHumidity">QHumidityReading::setAbsoluteHumidity(qreal)</a></p>
     */
    @QtUninvokable
    public final void setAbsoluteHumidity(double value){
        setAbsoluteHumidity_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setAbsoluteHumidity_native_qreal(long __this__nativeId, double value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhumidityreading.html#setRelativeHumidity">QHumidityReading::setRelativeHumidity(qreal)</a></p>
     */
    @QtUninvokable
    public final void setRelativeHumidity(double percent){
        setRelativeHumidity_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), percent);
    }
    
    @QtUninvokable
    private native void setRelativeHumidity_native_qreal(long __this__nativeId, double percent);
    
    @QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QHumidityReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QHumidityReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QHumidityReading instance, QDeclarativeConstructor constructor);
    
}
