package io.qt.sensors;

import io.qt.*;


/**
 * <p>Represents one reading from a compass</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qcompassreading.html">QCompassReading</a></p>
 */
public class QCompassReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCompassReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCompassReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QCompassReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QCompassReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #azimuth()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getAzimuth() {
        return azimuth();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcompassreading.html#azimuth-prop">QCompassReading::azimuth()const</a></p>
     */
    @QtPropertyReader(name="azimuth")
    @QtUninvokable
    public final double azimuth(){
        return azimuth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double azimuth_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #calibrationLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getCalibrationLevel() {
        return calibrationLevel();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcompassreading.html#calibrationLevel-prop">QCompassReading::calibrationLevel()const</a></p>
     */
    @QtPropertyReader(name="calibrationLevel")
    @QtUninvokable
    public final double calibrationLevel(){
        return calibrationLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double calibrationLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcompassreading.html#setAzimuth">QCompassReading::setAzimuth(qreal)</a></p>
     */
    @QtUninvokable
    public final void setAzimuth(double azimuth){
        setAzimuth_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), azimuth);
    }
    
    @QtUninvokable
    private native void setAzimuth_native_qreal(long __this__nativeId, double azimuth);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcompassreading.html#setCalibrationLevel">QCompassReading::setCalibrationLevel(qreal)</a></p>
     */
    @QtUninvokable
    public final void setCalibrationLevel(double calibrationLevel){
        setCalibrationLevel_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), calibrationLevel);
    }
    
    @QtUninvokable
    private native void setCalibrationLevel_native_qreal(long __this__nativeId, double calibrationLevel);
    
    @QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QCompassReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QCompassReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QCompassReading instance, QDeclarativeConstructor constructor);
    
}
