package io.qt.sensors;

import io.qt.*;


/**
 * <p>Holds readings of the ambient temperature</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qambienttemperaturereading.html">QAmbientTemperatureReading</a></p>
 */
public class QAmbientTemperatureReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAmbientTemperatureReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAmbientTemperatureReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QAmbientTemperatureReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAmbientTemperatureReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qambienttemperaturereading.html#setTemperature">QAmbientTemperatureReading::setTemperature(qreal)</a></p>
     */
    @QtUninvokable
    public final void setTemperature(double temperature){
        setTemperature_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), temperature);
    }
    
    @QtUninvokable
    private native void setTemperature_native_qreal(long __this__nativeId, double temperature);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #temperature()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getTemperature() {
        return temperature();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qambienttemperaturereading.html#temperature-prop">QAmbientTemperatureReading::temperature()const</a></p>
     */
    @QtPropertyReader(name="temperature")
    @QtUninvokable
    public final double temperature(){
        return temperature_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double temperature_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAmbientTemperatureReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAmbientTemperatureReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAmbientTemperatureReading instance, QDeclarativeConstructor constructor);
    
}
