package io.qt.sensors;

import io.qt.*;


/**
 * <p>Reports on linear acceleration along the X, Y and Z axes</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qaccelerometerreading.html">QAccelerometerReading</a></p>
 */
public class QAccelerometerReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAccelerometerReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAccelerometerReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QAccelerometerReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAccelerometerReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qaccelerometerreading.html#setX">QAccelerometerReading::setX(qreal)</a></p>
     */
    @QtUninvokable
    public final void setX(double x){
        setX_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), x);
    }
    
    @QtUninvokable
    private native void setX_native_qreal(long __this__nativeId, double x);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qaccelerometerreading.html#setY">QAccelerometerReading::setY(qreal)</a></p>
     */
    @QtUninvokable
    public final void setY(double y){
        setY_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), y);
    }
    
    @QtUninvokable
    private native void setY_native_qreal(long __this__nativeId, double y);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qaccelerometerreading.html#setZ">QAccelerometerReading::setZ(qreal)</a></p>
     */
    @QtUninvokable
    public final void setZ(double z){
        setZ_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), z);
    }
    
    @QtUninvokable
    private native void setZ_native_qreal(long __this__nativeId, double z);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #x()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getX() {
        return x();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qaccelerometerreading.html#x-prop">QAccelerometerReading::x()const</a></p>
     */
    @QtPropertyReader(name="x")
    @QtUninvokable
    public final double x(){
        return x_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double x_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #y()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getY() {
        return y();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qaccelerometerreading.html#y-prop">QAccelerometerReading::y()const</a></p>
     */
    @QtPropertyReader(name="y")
    @QtUninvokable
    public final double y(){
        return y_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double y_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #z()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getZ() {
        return z();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qaccelerometerreading.html#z-prop">QAccelerometerReading::z()const</a></p>
     */
    @QtPropertyReader(name="z")
    @QtUninvokable
    public final double z(){
        return z_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double z_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAccelerometerReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAccelerometerReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAccelerometerReading instance, QDeclarativeConstructor constructor);
    
}
