package io.qt.sensors;

import io.qt.*;


/**
 * <p>Convenience wrapper around QSensor</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qaccelerometer.html">QAccelerometer</a></p>
 */
public class QAccelerometer extends io.qt.sensors.QSensor
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAccelerometer.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qaccelerometer.html#AccelerationMode-enum">QAccelerometer::AccelerationMode</a></p>
     */
    @QtUnlistedEnum
    public enum AccelerationMode implements QtEnumerator {
        Combined(0),
        Gravity(1),
        User(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AccelerationMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AccelerationMode resolve(int value) {
            switch (value) {
            case 0: return Combined;
            case 1: return Gravity;
            case 2: return User;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qaccelerometer.html#accelerationModeChanged">QAccelerometer::accelerationModeChanged(QAccelerometer::AccelerationMode)</a></p>
     */
    @QtPropertyNotify(name="accelerationMode")
    public final @NonNull Signal1<io.qt.sensors.QAccelerometer.@NonNull AccelerationMode> accelerationModeChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAccelerometer() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qaccelerometer.html#QAccelerometer">QAccelerometer::QAccelerometer(QObject*)</a></p>
     */
    public QAccelerometer(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAccelerometer instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #accelerationMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.sensors.QAccelerometer.@NonNull AccelerationMode getAccelerationMode() {
        return accelerationMode();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qaccelerometer.html#accelerationMode-prop">QAccelerometer::accelerationMode()const</a></p>
     */
    @QtPropertyReader(name="accelerationMode")
    @QtUninvokable
    public final io.qt.sensors.QAccelerometer.@NonNull AccelerationMode accelerationMode(){
        return io.qt.sensors.QAccelerometer.AccelerationMode.resolve(accelerationMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int accelerationMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensor.html#reading-prop">QSensor::reading()const</a></p>
     */
    @QtUninvokable
    public final io.qt.sensors.@Nullable QAccelerometerReading reading(){
        return reading_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sensors.QAccelerometerReading reading_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qaccelerometer.html#setAccelerationMode">QAccelerometer::setAccelerationMode(QAccelerometer::AccelerationMode)</a></p>
     */
    @QtPropertyWriter(name="accelerationMode")
    @QtUninvokable
    public final void setAccelerationMode(io.qt.sensors.QAccelerometer.@NonNull AccelerationMode accelerationMode){
        setAccelerationMode_native_QAccelerometer_AccelerationMode(QtJambi_LibraryUtilities.internal.nativeId(this), accelerationMode.value());
    }
    
    @QtUninvokable
    private native void setAccelerationMode_native_QAccelerometer_AccelerationMode(long __this__nativeId, int accelerationMode);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAccelerometer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAccelerometer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAccelerometer instance, QDeclarativeConstructor constructor);
    
}
