#include <QtCore/QtGlobal>
#include <QtSensors/qsensormanager.h>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtSensors/qsensor.h>
#include <QtSensors/qsensorbackend.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QSensorManager(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QSensorManager")
    QSensorManager *_ptr = reinterpret_cast<QSensorManager *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new 
void __qt_construct_QSensorManager_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct ")
    Q_UNUSED(__java_arguments)
    QSensorManager *__qt_this = new(__qtjambi_ptr) QSensorManager();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// destruct QSensorManager
void __qt_destruct_QSensorManager(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QSensorManager")
    reinterpret_cast<QSensorManager*>(ptr)->~QSensorManager();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QSensorManager::
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sensors_QSensorManager_initialize_1native__Lio_qt_sensors_QSensorManager_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSensorManager::")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSensorManager_0, sizeof(QSensorManager), typeid(QSensorManager), false, &deleter_QSensorManager, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSensorManager::createBackend(QSensor*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sensors_QSensorManager_createBackend_1native_1QSensor_1ptr__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID sensor0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSensorManager::createBackend(QSensor*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QSensor* __qt_sensor0 = QtJambiAPI::objectFromNativeId<QSensor>(sensor0);
        QSensorBackend* __qt_return_value = QSensorManager::createBackend(__qt_sensor0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSensorManager::isBackendRegistered(QByteArray,QByteArray)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sensors_QSensorManager_isBackendRegistered_1native_1cref_1QByteArray_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID type0,
 QtJambiNativeID identifier1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSensorManager::isBackendRegistered(QByteArray,QByteArray)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray& __qt_type0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(type0);
        const QByteArray& __qt_identifier1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(identifier1);
        __java_return_value = QSensorManager::isBackendRegistered(__qt_type0, __qt_identifier1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSensorManager::registerBackend(QByteArray,QByteArray,QSensorBackendFactory*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sensors_QSensorManager_registerBackend_1native_1cref_1QByteArray_1cref_1QByteArray_1QSensorBackendFactory_1ptr__JJJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID type0,
 QtJambiNativeID identifier1,
 QtJambiNativeID factory2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSensorManager::registerBackend(QByteArray,QByteArray,QSensorBackendFactory*)")
    QTJAMBI_TRY {
        const QByteArray& __qt_type0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(type0);
        const QByteArray& __qt_identifier1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(identifier1);
        QSensorBackendFactory* __qt_factory2 = QtJambiAPI::interfaceFromNativeId<QSensorBackendFactory>(factory2);
        QSensorManager::registerBackend(__qt_type0, __qt_identifier1, __qt_factory2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSensorManager::setDefaultBackend(QByteArray,QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sensors_QSensorManager_setDefaultBackend_1native_1cref_1QByteArray_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID type0,
 QtJambiNativeID identifier1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSensorManager::setDefaultBackend(QByteArray,QByteArray)")
    QTJAMBI_TRY {
        const QByteArray& __qt_type0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(type0);
        const QByteArray& __qt_identifier1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(identifier1);
        QSensorManager::setDefaultBackend(__qt_type0, __qt_identifier1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSensorManager::unregisterBackend(QByteArray,QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sensors_QSensorManager_unregisterBackend_1native_1cref_1QByteArray_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID type0,
 QtJambiNativeID identifier1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSensorManager::unregisterBackend(QByteArray,QByteArray)")
    QTJAMBI_TRY {
        const QByteArray& __qt_type0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(type0);
        const QByteArray& __qt_identifier1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(identifier1);
        QSensorManager::unregisterBackend(__qt_type0, __qt_identifier1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QSensorManager(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QSensorManager>("QSensorManager", "io/qt/sensors/QSensorManager");
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QSensorManager, {
        ConstructorInfo(&__qt_construct_QSensorManager_0, nullptr)
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QSensorManager);
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
