package io.qt.scxml;

import io.qt.*;


/**
 * <p>Compiler for SCXML files</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qscxmlcompiler.html">QScxmlCompiler</a></code></p>
 */
public class QScxmlCompiler extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcLoader = null;
    
    /**
     * <p>URI resolver and resource loader for an SCXML compiler</p>
     * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qscxmlcompiler-loader.html">QScxmlCompiler::Loader</a></code></p>
     */
    public static interface Loader extends QtObjectInterface
    {
        /**
         * @hidden
         * <p>Implementor class for interface {@link io.qt.scxml.QScxmlCompiler.Loader}</p>
         */
        public static abstract class Impl extends QtObject
            implements io.qt.scxml.QScxmlCompiler.Loader
        {
            static {
                QtJambi_LibraryUtilities.initialize();
            }
            
            @NativeAccess
            private static final class ConcreteWrapper extends QScxmlCompiler.Loader.Impl {
                
                @NativeAccess
                private ConcreteWrapper(QPrivateConstructor p) { super(p); }
                
                @Override
                @QtUninvokable
                public io.qt.core.@NonNull QByteArray load(java.lang.@NonNull String name, java.lang.@NonNull String baseDir, java.util.@Nullable Collection<java.lang.@NonNull String> errors){
                    return load_native_cref_QString_cref_QString_QStringList_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), name, baseDir, errors);
                }
                private native static io.qt.core.QByteArray load_native_cref_QString_cref_QString_QStringList_ptr(long __this__nativeId, java.lang.String name, java.lang.String baseDir, java.util.Collection<java.lang.String> errors);
                
            }
            
            
            /**
             * <p>See <code><a href="https://doc.qt.io/qt/qscxmlcompiler-loader.html#Loader">QScxmlCompiler::Loader::<wbr/>Loader()</a></code></p>
             */
            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }
            
            private native static void initialize_native(Loader instance);
            
            /**
             * <p>See <code><a href="https://doc.qt.io/qt/qscxmlcompiler-loader.html#load">QScxmlCompiler::Loader::<wbr/>load(QString,<wbr/>QString,<wbr/>QStringList*)</a></code></p>
             */
            @QtUninvokable
            public abstract io.qt.core.@NonNull QByteArray load(java.lang.@NonNull String name, java.lang.@NonNull String baseDir, java.util.@Nullable Collection<java.lang.@NonNull String> errors);
            
            private native static io.qt.core.QByteArray load_native_cref_QString_cref_QString_QStringList_ptr(long __this__nativeId, java.lang.String name, java.lang.String baseDir, java.util.Collection<java.lang.String> errors);
            
            /**
             * Constructor for internal use only.
             * @param p expected to be <code>null</code>.
             * @hidden
             */
            @NativeAccess
            protected Impl(QPrivateConstructor p) { super(p); } 
            
        }

        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlcompiler-loader.html#load">QScxmlCompiler::Loader::<wbr/>load(QString,<wbr/>QString,<wbr/>QStringList*)</a></code></p>
         */
        @QtUninvokable
        public io.qt.core.@NonNull QByteArray load(java.lang.@NonNull String name, java.lang.@NonNull String baseDir, java.util.@Nullable Collection<java.lang.@NonNull String> errors);
        
    }

    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlcompiler.html#QScxmlCompiler">QScxmlCompiler::<wbr/>QScxmlCompiler(QScxmlCompiler)</a></code></p>
     */
    public QScxmlCompiler(io.qt.scxml.@StrictNonNull QScxmlCompiler other){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QScxmlCompiler instance, io.qt.scxml.QScxmlCompiler other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlcompiler.html#QScxmlCompiler">QScxmlCompiler::<wbr/>QScxmlCompiler(QXmlStreamReader*)</a></code></p>
     */
    public QScxmlCompiler(io.qt.core.@Nullable QXmlStreamReader xmlReader){
        super((QPrivateConstructor)null);
        initialize_native(this, xmlReader);
    }
    
    private native static void initialize_native(QScxmlCompiler instance, io.qt.core.QXmlStreamReader xmlReader);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlcompiler.html#compile">QScxmlCompiler::<wbr/>compile()</a></code></p>
     */
    @QtUninvokable
    public final io.qt.scxml.@Nullable QScxmlStateMachine compile(){
        return compile_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.scxml.QScxmlStateMachine compile_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlcompiler.html#errors">QScxmlCompiler::<wbr/>errors()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.scxml.@NonNull QScxmlError> errors(){
        return errors_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.scxml.QScxmlError> errors_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlcompiler.html#fileName">QScxmlCompiler::<wbr/>fileName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String fileName(){
        return fileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String fileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlcompiler.html#loader">QScxmlCompiler::<wbr/>loader()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.scxml.QScxmlCompiler.@Nullable Loader loader(){
        return loader_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.scxml.QScxmlCompiler.Loader loader_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlcompiler.html#setFileName">QScxmlCompiler::<wbr/>setFileName(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setFileName(java.lang.@NonNull String fileName){
        setFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @QtUninvokable
    private native void setFileName_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlcompiler.html#setLoader">QScxmlCompiler::<wbr/>setLoader(QScxmlCompiler::Loader*)</a></code></p>
     */
    @QtUninvokable
    public final void setLoader(io.qt.scxml.QScxmlCompiler.@Nullable Loader newLoader){
        setLoader_native_QScxmlCompiler_Loader_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newLoader));
        __rcLoader = newLoader;
    }
    
    @QtUninvokable
    private native void setLoader_native_QScxmlCompiler_Loader_ptr(long __this__nativeId, long newLoader);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScxmlCompiler(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qscxmlcompiler.html#QScxmlCompiler">QScxmlCompiler::<wbr/>QScxmlCompiler(QScxmlCompiler)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QScxmlCompiler clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QScxmlCompiler clone_native(long __this_nativeId);
}
