package io.qt.scxml;

import io.qt.*;


/**
 * <p>Event for a Qt SCXML state machine</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qscxmlevent.html">QScxmlEvent</a></code></p>
 */
public class QScxmlEvent extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScxmlEvent.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qscxmlevent.html#EventType-enum">QScxmlEvent::EventType</a></code></p>
     */
    public enum EventType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qscxmlevent.html#EventType-enum">QScxmlEvent::<wbr/>PlatformEvent</a></code></p>
         */
        PlatformEvent(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qscxmlevent.html#EventType-enum">QScxmlEvent::<wbr/>InternalEvent</a></code></p>
         */
        InternalEvent(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qscxmlevent.html#EventType-enum">QScxmlEvent::<wbr/>ExternalEvent</a></code></p>
         */
        ExternalEvent(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private EventType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull EventType resolve(int value) {
            switch (value) {
            case 0: return PlatformEvent;
            case 1: return InternalEvent;
            case 2: return ExternalEvent;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#QScxmlEvent">QScxmlEvent::<wbr/>QScxmlEvent()</a></code></p>
     */
    public QScxmlEvent(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QScxmlEvent instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#QScxmlEvent-1">QScxmlEvent::<wbr/>QScxmlEvent(QScxmlEvent)</a></code></p>
     */
    public QScxmlEvent(io.qt.scxml.@NonNull QScxmlEvent other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QScxmlEvent instance, io.qt.scxml.QScxmlEvent other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#clear">QScxmlEvent::<wbr/>clear()</a></code></p>
     */
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#data">QScxmlEvent::<wbr/>data()const</a></code></p>
     */
    @QtPropertyReader(name="data")
    @QtUninvokable
    public final java.lang.Object data(){
        return data_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Object data_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#delay">QScxmlEvent::<wbr/>delay()const</a></code></p>
     */
    @QtPropertyReader(name="delay")
    @QtUninvokable
    public final int delay(){
        return delay_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int delay_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#errorMessage">QScxmlEvent::<wbr/>errorMessage()const</a></code></p>
     */
    @QtPropertyReader(name="errorMessage")
    @QtUninvokable
    public final java.lang.@NonNull String errorMessage(){
        return errorMessage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorMessage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#eventType">QScxmlEvent::<wbr/>eventType()const</a></code></p>
     */
    @QtPropertyReader(name="eventType")
    @QtUninvokable
    public final io.qt.scxml.QScxmlEvent.@NonNull EventType eventType(){
        return io.qt.scxml.QScxmlEvent.EventType.resolve(eventType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int eventType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#invokeId">QScxmlEvent::<wbr/>invokeId()const</a></code></p>
     */
    @QtPropertyReader(name="invokeId")
    @QtUninvokable
    public final java.lang.@NonNull String invokeId(){
        return invokeId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String invokeId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#isErrorEvent">QScxmlEvent::<wbr/>isErrorEvent()const</a></code></p>
     */
    @QtPropertyReader(name="errorEvent")
    @QtUninvokable
    public final boolean isErrorEvent(){
        return isErrorEvent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isErrorEvent_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#name">QScxmlEvent::<wbr/>name()const</a></code></p>
     */
    @QtPropertyReader(name="name")
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#operator-eq">QScxmlEvent::<wbr/>operator=(QScxmlEvent)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.scxml.@NonNull QScxmlEvent other){
        assign_native_cref_QScxmlEvent(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QScxmlEvent(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#origin">QScxmlEvent::<wbr/>origin()const</a></code></p>
     */
    @QtPropertyReader(name="origin")
    @QtUninvokable
    public final java.lang.@NonNull String origin(){
        return origin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String origin_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#originType">QScxmlEvent::<wbr/>originType()const</a></code></p>
     */
    @QtPropertyReader(name="originType")
    @QtUninvokable
    public final java.lang.@NonNull String originType(){
        return originType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String originType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#scxmlType">QScxmlEvent::<wbr/>scxmlType()const</a></code></p>
     */
    @QtPropertyReader(name="scxmlType")
    @QtUninvokable
    public final java.lang.@NonNull String scxmlType(){
        return scxmlType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String scxmlType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#sendId">QScxmlEvent::<wbr/>sendId()const</a></code></p>
     */
    @QtPropertyReader(name="sendId")
    @QtUninvokable
    public final java.lang.@NonNull String sendId(){
        return sendId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String sendId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#setData">QScxmlEvent::<wbr/>setData(QVariant)</a></code></p>
     */
    @QtPropertyWriter(name="data")
    @QtUninvokable
    public final void setData(java.lang.Object data){
        setData_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native void setData_native_cref_QVariant(long __this__nativeId, java.lang.Object data);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#setDelay">QScxmlEvent::<wbr/>setDelay(int)</a></code></p>
     */
    @QtPropertyWriter(name="delay")
    @QtUninvokable
    public final void setDelay(int delayInMiliSecs){
        setDelay_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), delayInMiliSecs);
    }
    
    @QtUninvokable
    private native void setDelay_native_int(long __this__nativeId, int delayInMiliSecs);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#setErrorMessage">QScxmlEvent::<wbr/>setErrorMessage(QString)</a></code></p>
     */
    @QtPropertyWriter(name="errorMessage")
    @QtUninvokable
    public final void setErrorMessage(java.lang.@NonNull String message){
        setErrorMessage_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), message);
    }
    
    @QtUninvokable
    private native void setErrorMessage_native_cref_QString(long __this__nativeId, java.lang.String message);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#setEventType">QScxmlEvent::<wbr/>setEventType(QScxmlEvent::EventType)</a></code></p>
     */
    @QtPropertyWriter(name="eventType")
    @QtUninvokable
    public final void setEventType(io.qt.scxml.QScxmlEvent.@NonNull EventType type){
        setEventType_native_cref_QScxmlEvent_EventType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native void setEventType_native_cref_QScxmlEvent_EventType(long __this__nativeId, int type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#setInvokeId">QScxmlEvent::<wbr/>setInvokeId(QString)</a></code></p>
     */
    @QtPropertyWriter(name="invokeId")
    @QtUninvokable
    public final void setInvokeId(java.lang.@NonNull String invokeId){
        setInvokeId_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), invokeId);
    }
    
    @QtUninvokable
    private native void setInvokeId_native_cref_QString(long __this__nativeId, java.lang.String invokeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#setName">QScxmlEvent::<wbr/>setName(QString)</a></code></p>
     */
    @QtPropertyWriter(name="name")
    @QtUninvokable
    public final void setName(java.lang.@NonNull String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#setOrigin">QScxmlEvent::<wbr/>setOrigin(QString)</a></code></p>
     */
    @QtPropertyWriter(name="origin")
    @QtUninvokable
    public final void setOrigin(java.lang.@NonNull String origin){
        setOrigin_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), origin);
    }
    
    @QtUninvokable
    private native void setOrigin_native_cref_QString(long __this__nativeId, java.lang.String origin);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#setOriginType">QScxmlEvent::<wbr/>setOriginType(QString)</a></code></p>
     */
    @QtPropertyWriter(name="originType")
    @QtUninvokable
    public final void setOriginType(java.lang.@NonNull String originType){
        setOriginType_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), originType);
    }
    
    @QtUninvokable
    private native void setOriginType_native_cref_QString(long __this__nativeId, java.lang.String originType);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#setSendId">QScxmlEvent::<wbr/>setSendId(QString)</a></code></p>
     */
    @QtPropertyWriter(name="sendId")
    @QtUninvokable
    public final void setSendId(java.lang.@NonNull String sendId){
        setSendId_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), sendId);
    }
    
    @QtUninvokable
    private native void setSendId_native_cref_QString(long __this__nativeId, java.lang.String sendId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScxmlEvent(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qscxmlevent.html#QScxmlEvent-1">QScxmlEvent::<wbr/>QScxmlEvent(QScxmlEvent)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QScxmlEvent clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QScxmlEvent clone_native(long __this_nativeId);
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #data()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.Object getData() {
        return data();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #delay()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getDelay() {
        return delay();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #errorMessage()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getErrorMessage() {
        return errorMessage();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #eventType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.scxml.QScxmlEvent.@NonNull EventType getEventType() {
        return eventType();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #invokeId()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getInvokeId() {
        return invokeId();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isErrorEvent()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getErrorEvent() {
        return isErrorEvent();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #name()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getName() {
        return name();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #origin()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getOrigin() {
        return origin();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #originType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getOriginType() {
        return originType();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #scxmlType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getScxmlType() {
        return scxmlType();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #sendId()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getSendId() {
        return sendId();
    }
}
