package io.qt.scxml;

import io.qt.*;


/**
 * <p>Interface to the state machines created from SCXML files</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html">QScxmlStateMachine</a></code></p>
 */
public class QScxmlStateMachine extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcDataModel = null;
    @QtPropertyMember(enabled=false)
    private Object __rcLoader = null;
    @QtPropertyMember(enabled=false)
    private Object __rcTableData = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScxmlStateMachine.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#dataModel-prop">QScxmlStateMachine::<wbr/>dataModelChanged(QScxmlDataModel*)</a></code></p>
     */
    @QtPropertyNotify(name="dataModel")
    public final @NonNull Signal1<io.qt.scxml.@Nullable QScxmlDataModel> dataModelChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#finished">QScxmlStateMachine::<wbr/>finished()</a></code></p>
     */
    public final @NonNull Signal0 finished = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#initialValues-prop">QScxmlStateMachine::<wbr/>initialValuesChanged(QVariantMap)</a></code></p>
     */
    @QtPropertyNotify(name="initialValues")
    public final @NonNull Signal1<java.util.@NonNull NavigableMap<java.lang.@NonNull String, java.lang.Object>> initialValuesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#initialized-prop">QScxmlStateMachine::<wbr/>initializedChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="initialized")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> initializedChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#invokedServices-prop">QScxmlStateMachine::<wbr/>invokedServicesChanged(QList&lt;QScxmlInvokableService*&gt;)</a></code></p>
     */
    @QtPropertyNotify(name="invokedServices")
    public final @NonNull Signal1<java.util.@NonNull List<io.qt.scxml.@Nullable QScxmlInvokableService>> invokedServicesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#loader-prop">QScxmlStateMachine::<wbr/>loaderChanged(QScxmlCompiler::Loader*)</a></code></p>
     */
    @QtPropertyNotify(name="loader")
    public final @NonNull Signal1<io.qt.scxml.QScxmlCompiler.@Nullable Loader> loaderChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#log">QScxmlStateMachine::<wbr/>log(QString,<wbr/>QString)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@NonNull String, java.lang.@NonNull String> log = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#reachedStableState">QScxmlStateMachine::<wbr/>reachedStableState()</a></code></p>
     */
    public final @NonNull Signal0 reachedStableState = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#runningChanged">QScxmlStateMachine::<wbr/>runningChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="running")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> runningChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#tableData-prop">QScxmlStateMachine::<wbr/>tableDataChanged(QScxmlTableData*)</a></code></p>
     */
    @QtPropertyNotify(name="tableData")
    public final @NonNull Signal1<io.qt.scxml.@Nullable QScxmlTableData> tableDataChanged = new Signal1<>();
    
    /**
     * <p>See <code>QScxmlStateMachine::<wbr/>QScxmlStateMachine(const QMetaObject*,<wbr/>QObject*)</code></p>
     */
    protected QScxmlStateMachine(io.qt.core.@Nullable QMetaObject metaObject, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, metaObject, parent);
    }
    
    private native static void initialize_native(QScxmlStateMachine instance, io.qt.core.QMetaObject metaObject, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#activeStateNames">QScxmlStateMachine::<wbr/>activeStateNames(bool)const</a></code></p>
     */
    public final io.qt.core.@NonNull QStringList activeStateNames(boolean compress){
        return activeStateNames_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), compress);
    }
    
    private native io.qt.core.QStringList activeStateNames_native_bool_constfct(long __this__nativeId, boolean compress);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#dataModel-prop">QScxmlStateMachine::<wbr/>bindableDataModel()</a></code></p>
     */
    @QtPropertyBindable(name="dataModel")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.scxml.@Nullable QScxmlDataModel> bindableDataModel(){
        return bindableDataModel_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.scxml.QScxmlDataModel> bindableDataModel_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#initialValues-prop">QScxmlStateMachine::<wbr/>bindableInitialValues()</a></code></p>
     */
    @QtPropertyBindable(name="initialValues")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<java.util.@NonNull NavigableMap<java.lang.@NonNull String, java.lang.Object>> bindableInitialValues(){
        return bindableInitialValues_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<java.util.NavigableMap<java.lang.String, java.lang.Object>> bindableInitialValues_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#initialized-prop">QScxmlStateMachine::<wbr/>bindableInitialized()const</a></code></p>
     */
    @QtPropertyBindable(name="initialized")
    @QtUninvokable
    public final io.qt.core.@NonNull QBooleanBindable bindableInitialized(){
        return bindableInitialized_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBooleanBindable bindableInitialized_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#invokedServices-prop">QScxmlStateMachine::<wbr/>bindableInvokedServices()</a></code></p>
     */
    @QtPropertyBindable(name="invokedServices")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<java.util.@NonNull List<io.qt.scxml.@Nullable QScxmlInvokableService>> bindableInvokedServices(){
        return bindableInvokedServices_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<java.util.List<io.qt.scxml.QScxmlInvokableService>> bindableInvokedServices_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#loader-prop">QScxmlStateMachine::<wbr/>bindableLoader()</a></code></p>
     */
    @QtPropertyBindable(name="loader")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.scxml.QScxmlCompiler.@Nullable Loader> bindableLoader(){
        return bindableLoader_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.scxml.QScxmlCompiler.Loader> bindableLoader_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#tableData-prop">QScxmlStateMachine::<wbr/>bindableTableData()</a></code></p>
     */
    @QtPropertyBindable(name="tableData")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.scxml.@Nullable QScxmlTableData> bindableTableData(){
        return bindableTableData_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.scxml.QScxmlTableData> bindableTableData_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#cancelDelayedEvent">QScxmlStateMachine::<wbr/>cancelDelayedEvent(QString)</a></code></p>
     */
    public final void cancelDelayedEvent(java.lang.@NonNull String sendId){
        cancelDelayedEvent_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), sendId);
    }
    
    private native void cancelDelayedEvent_native_cref_QString(long __this__nativeId, java.lang.String sendId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToEvent">QScxmlStateMachine::<wbr/>connectToEvent(QString,<wbr/>const QObject*,<wbr/>const char*,<wbr/>Qt::ConnectionType)</a></code></p>
     */
    @SafeVarargs
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToEvent(java.lang.@NonNull String scxmlEventSpec, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String method, io.qt.core.Qt.@NonNull ConnectionType @NonNull... type){
        if(method!=null && !method.startsWith("1") && !method.startsWith("2")) {
            io.qt.core.QMetaMethod _method = receiver.metaObject().method(method);
            if(_method!=null && _method.isValid()) {
                if(_method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    method = "2" + _method.cppMethodSignature();
                else
                    method = "1" + _method.cppMethodSignature();
            }
        }
        return connectToEvent_native_cref_QString_const_QObject_ptr_const_char_ptr_Qt_ConnectionType(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlEventSpec, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), method, type);
    }
    
    @QtUninvokable
    private native io.qt.core.QMetaObject.Connection connectToEvent_native_cref_QString_const_QObject_ptr_const_char_ptr_Qt_ConnectionType(long __this__nativeId, java.lang.String scxmlEventSpec, long receiver, java.lang.String method, io.qt.core.Qt.ConnectionType[] type);
    
    /**
     * <p>See <code>QScxmlStateMachine::<wbr/>connectToEvent(QString,<wbr/>const QtPrivate::ContextTypeForFunctor::ContextType&lt;Functor&gt;*,<wbr/>Functor&amp;&amp;,<wbr/>Qt::ConnectionType)</code></p>
     */
    @SafeVarargs
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToEvent(java.lang.@NonNull String scxmlEventSpec, io.qt.core.@Nullable QObject context, io.qt.core.QMetaObject.@StrictNonNull Slot0 functor, io.qt.core.Qt.@NonNull ConnectionType @NonNull... type){
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromMethod(java.util.Objects.requireNonNull(functor, "Argument 'functor': null not expected."));
        if(metaMethod!=null && metaMethod.isValid()) {
            io.qt.core.QObject object = QtJambi_LibraryUtilities.internal.lambdaContext(functor);
            if(context!=null && context==object) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToEvent(scxmlEventSpec, context, "2"+metaMethod.cppMethodSignature(), type);
                case Method:
                case Slot:
                    return connectToEvent(scxmlEventSpec, context, "1"+metaMethod.cppMethodSignature(), type);
                default:
                    break;
                }
            }
        }
        if(context==null)
            context = this;
        java.util.Objects.requireNonNull(functor, "Argument 'functor': null not expected.");
        return connectToEvent_native_cref_QString_const_QtPrivate_ContextTypeForFunctor_ContextType_Functor__ptr_rval_QScxmlStateMachine_Slot0_Qt_ConnectionType(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlEventSpec, QtJambi_LibraryUtilities.internal.checkedNativeId(context), functor, type);
    }
    
    @QtUninvokable
    private native io.qt.core.QMetaObject.@NonNull Connection connectToEvent_native_cref_QString_const_QtPrivate_ContextTypeForFunctor_ContextType_Functor__ptr_rval_QScxmlStateMachine_Slot0_Qt_ConnectionType(long __this__nativeId, java.lang.String scxmlEventSpec, long context, io.qt.core.QMetaObject.Slot0 functor, io.qt.core.Qt.ConnectionType[] type);
    
    /**
     * <p>See <code>QScxmlStateMachine::<wbr/>connectToEvent(QString,<wbr/>const QtPrivate::ContextTypeForFunctor::ContextType&lt;Functor&gt;*,<wbr/>Functor&amp;&amp;,<wbr/>Qt::ConnectionType)</code></p>
     */
    @SafeVarargs
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToEvent(java.lang.@NonNull String scxmlEventSpec, io.qt.core.@Nullable QObject context, io.qt.core.QMetaObject.@StrictNonNull Slot1<@NonNull QScxmlEvent> functor, io.qt.core.Qt.@NonNull ConnectionType @NonNull... type){
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromMethod(java.util.Objects.requireNonNull(functor, "Argument 'functor': null not expected."));
        if(metaMethod!=null && metaMethod.isValid()) {
            if(metaMethod.parameterCount()!=1 && metaMethod.parameterType(0)!=io.qt.core.QMetaType.fromType(QScxmlEvent.class).id()) {
                throw new IllegalArgumentException("Method does not take a single QScxmlEvent argument: "+metaMethod.cppMethodSignature());
            }
            io.qt.core.QObject object = QtJambi_LibraryUtilities.internal.lambdaContext(functor);
            if(context!=null && context==object) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToEvent(scxmlEventSpec, context, "2"+metaMethod.cppMethodSignature(), type);
                case Method:
                case Slot:
                    return connectToEvent(scxmlEventSpec, context, "1"+metaMethod.cppMethodSignature(), type);
                default:
                    break;
                }
            }
        }
        if(context==null)
            context = this;
        java.util.Objects.requireNonNull(functor, "Argument 'functor': null not expected.");
        return connectToEvent_native_cref_QString_const_QtPrivate_ContextTypeForFunctor_ContextType_Functor__ptr_rval_QScxmlStateMachine_Slot1_Qt_ConnectionType(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlEventSpec, QtJambi_LibraryUtilities.internal.checkedNativeId(context), functor, type);
    }
    
    @QtUninvokable
    private native io.qt.core.QMetaObject.@NonNull Connection connectToEvent_native_cref_QString_const_QtPrivate_ContextTypeForFunctor_ContextType_Functor__ptr_rval_QScxmlStateMachine_Slot1_Qt_ConnectionType(long __this__nativeId, java.lang.String scxmlEventSpec, long context, io.qt.core.QMetaObject.Slot1<QScxmlEvent> functor, io.qt.core.Qt.ConnectionType[] type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToState">QScxmlStateMachine::<wbr/>connectToState(QString,<wbr/>const QObject*,<wbr/>const char*,<wbr/>Qt::ConnectionType)</a></code></p>
     */
    @SafeVarargs
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToState(java.lang.@NonNull String scxmlStateName, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String method, io.qt.core.Qt.@NonNull ConnectionType @NonNull... type){
        if(method!=null && !method.startsWith("1") && !method.startsWith("2")) {
            io.qt.core.QMetaMethod _method = receiver.metaObject().method(method);
            if(_method!=null && _method.isValid()) {
                if(_method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    method = "2" + _method.cppMethodSignature();
                else
                    method = "1" + _method.cppMethodSignature();
            }
        }
        return connectToState_native_cref_QString_const_QObject_ptr_const_char_ptr_Qt_ConnectionType(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlStateName, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), method, type);
    }
    
    @QtUninvokable
    private native io.qt.core.QMetaObject.Connection connectToState_native_cref_QString_const_QObject_ptr_const_char_ptr_Qt_ConnectionType(long __this__nativeId, java.lang.String scxmlStateName, long receiver, java.lang.String method, io.qt.core.Qt.ConnectionType[] type);
    
    /**
     * <p>See <code>QScxmlStateMachine::<wbr/>connectToState(QString,<wbr/>const QtPrivate::ContextTypeForFunctor::ContextType&lt;Functor&gt;*,<wbr/>Functor&amp;&amp;,<wbr/>Qt::ConnectionType)</code></p>
     */
    @SafeVarargs
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToState(java.lang.@NonNull String scxmlStateName, io.qt.core.@Nullable QObject context, io.qt.core.QMetaObject.@StrictNonNull Slot0 functor, io.qt.core.Qt.@NonNull ConnectionType @NonNull... type){
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromMethod(java.util.Objects.requireNonNull(functor, "Argument 'functor': null not expected."));
        if(metaMethod!=null && metaMethod.isValid()) {
            io.qt.core.QObject object = QtJambi_LibraryUtilities.internal.lambdaContext(functor);
            if(context!=null && context==object) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToState(scxmlStateName, context, "2"+metaMethod.cppMethodSignature(), type);
                case Method:
                case Slot:
                    return connectToState(scxmlStateName, context, "1"+metaMethod.cppMethodSignature(), type);
                default:
                    break;
                }
            }
        }
        if(context==null)
            context = this;
        java.util.Objects.requireNonNull(functor, "Argument 'functor': null not expected.");
        return connectToState_native_cref_QString_const_QtPrivate_ContextTypeForFunctor_ContextType_Functor__ptr_rval_QScxmlStateMachine_Slot0_Qt_ConnectionType(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlStateName, QtJambi_LibraryUtilities.internal.checkedNativeId(context), functor, type);
    }
    
    @QtUninvokable
    private native io.qt.core.QMetaObject.@NonNull Connection connectToState_native_cref_QString_const_QtPrivate_ContextTypeForFunctor_ContextType_Functor__ptr_rval_QScxmlStateMachine_Slot0_Qt_ConnectionType(long __this__nativeId, java.lang.String scxmlStateName, long context, io.qt.core.QMetaObject.Slot0 functor, io.qt.core.Qt.ConnectionType[] type);
    
    /**
     * <p>See <code>QScxmlStateMachine::<wbr/>connectToState(QString,<wbr/>const QtPrivate::ContextTypeForFunctor::ContextType&lt;Functor&gt;*,<wbr/>Functor&amp;&amp;,<wbr/>Qt::ConnectionType)</code></p>
     */
    @SafeVarargs
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToState(java.lang.@NonNull String scxmlStateName, io.qt.core.@Nullable QObject context, io.qt.core.QMetaObject.@StrictNonNull Slot1<@QtPrimitiveType@NonNull Boolean> functor, io.qt.core.Qt.@NonNull ConnectionType @NonNull... type){
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromMethod(java.util.Objects.requireNonNull(functor, "Argument 'functor': null not expected."));
        if(metaMethod!=null && metaMethod.isValid()) {
            if(metaMethod.parameterCount()!=1 && metaMethod.parameterType(0)!=io.qt.core.QMetaType.fromType(boolean.class).id()) {
                throw new IllegalArgumentException("Method does not take a single QScxmlEvent argument: "+metaMethod.cppMethodSignature());
            }
            io.qt.core.QObject object = QtJambi_LibraryUtilities.internal.lambdaContext(functor);
            if(context!=null && context==object) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToState(scxmlStateName, context, "2"+metaMethod.cppMethodSignature(), type);
                case Method:
                case Slot:
                    return connectToState(scxmlStateName, context, "1"+metaMethod.cppMethodSignature(), type);
                default:
                    break;
                }
            }
        }
        if(context==null)
            context = this;
        java.util.Objects.requireNonNull(functor, "Argument 'functor': null not expected.");
        return connectToState_native_cref_QString_const_QtPrivate_ContextTypeForFunctor_ContextType_Functor__ptr_rval_QScxmlStateMachine_Slot1B_Qt_ConnectionType(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlStateName, QtJambi_LibraryUtilities.internal.checkedNativeId(context), functor, type);
    }
    
    @QtUninvokable
    private native io.qt.core.QMetaObject.@NonNull Connection connectToState_native_cref_QString_const_QtPrivate_ContextTypeForFunctor_ContextType_Functor__ptr_rval_QScxmlStateMachine_Slot1B_Qt_ConnectionType(long __this__nativeId, java.lang.String scxmlStateName, long context, io.qt.core.QMetaObject.Slot1<Boolean> functor, io.qt.core.Qt.ConnectionType[] type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#dataModel">QScxmlStateMachine::<wbr/>dataModel()const</a></code></p>
     */
    @QtPropertyReader(name="dataModel")
    @QtUninvokable
    public final io.qt.scxml.@Nullable QScxmlDataModel dataModel(){
        return dataModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.scxml.QScxmlDataModel dataModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#init">QScxmlStateMachine::<wbr/>init()</a></code></p>
     */
    public final boolean init(){
        return init_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean init_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#initialValues-prop">QScxmlStateMachine::<wbr/>initialValues()</a></code></p>
     */
    @QtPropertyReader(name="initialValues")
    @QtUninvokable
    public final io.qt.core.@NonNull QMap<java.lang.@NonNull String, java.lang.Object> initialValues(){
        return initialValues_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QMap<java.lang.String, java.lang.Object> initialValues_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#invokedServices-prop">QScxmlStateMachine::<wbr/>invokedServices()const</a></code></p>
     */
    @QtPropertyReader(name="invokedServices")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.scxml.@Nullable QScxmlInvokableService> invokedServices(){
        return invokedServices_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.scxml.QScxmlInvokableService> invokedServices_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#isActive">QScxmlStateMachine::<wbr/>isActive(QString)const</a></code></p>
     */
    public final boolean isActive(java.lang.@NonNull String scxmlStateName){
        return isActive_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlStateName);
    }
    
    private native boolean isActive_native_cref_QString_constfct(long __this__nativeId, java.lang.String scxmlStateName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#isActive-1">QScxmlStateMachine::<wbr/>isActive(int)const</a></code></p>
     */
    @QtUninvokable
    protected final boolean isActive(int stateIndex){
        return isActive_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), stateIndex);
    }
    
    @QtUninvokable
    private native boolean isActive_native_int_constfct(long __this__nativeId, int stateIndex);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#isDispatchableTarget">QScxmlStateMachine::<wbr/>isDispatchableTarget(QString)const</a></code></p>
     */
    public final boolean isDispatchableTarget(java.lang.@NonNull String target){
        return isDispatchableTarget_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    private native boolean isDispatchableTarget_native_cref_QString_constfct(long __this__nativeId, java.lang.String target);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#initialized-prop">QScxmlStateMachine::<wbr/>isInitialized()const</a></code></p>
     */
    @QtPropertyReader(name="initialized")
    @QtUninvokable
    public final boolean isInitialized(){
        return isInitialized_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isInitialized_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#invoked-prop">QScxmlStateMachine::<wbr/>isInvoked()const</a></code></p>
     */
    @QtPropertyReader(name="invoked")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isInvoked(){
        return isInvoked_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isInvoked_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#isRunning">QScxmlStateMachine::<wbr/>isRunning()const</a></code></p>
     */
    @QtPropertyReader(name="running")
    @QtUninvokable
    public final boolean isRunning(){
        return isRunning_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isRunning_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#loader-prop">QScxmlStateMachine::<wbr/>loader()const</a></code></p>
     */
    @QtPropertyReader(name="loader")
    @QtUninvokable
    public final io.qt.scxml.QScxmlCompiler.@Nullable Loader loader(){
        return loader_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.scxml.QScxmlCompiler.Loader loader_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#name-prop">QScxmlStateMachine::<wbr/>name()const</a></code></p>
     */
    @QtPropertyReader(name="name")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#parseErrors-prop">QScxmlStateMachine::<wbr/>parseErrors()const</a></code></p>
     */
    @QtPropertyReader(name="parseErrors")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.scxml.@NonNull QScxmlError> parseErrors(){
        return parseErrors_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.scxml.QScxmlError> parseErrors_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#sessionId-prop">QScxmlStateMachine::<wbr/>sessionId()const</a></code></p>
     */
    @QtPropertyReader(name="sessionId")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String sessionId(){
        return sessionId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String sessionId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#setDataModel">QScxmlStateMachine::<wbr/>setDataModel(QScxmlDataModel*)</a></code></p>
     */
    @QtPropertyWriter(name="dataModel")
    @QtUninvokable
    public final void setDataModel(io.qt.scxml.@Nullable QScxmlDataModel model){
        setDataModel_native_QScxmlDataModel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(model));
        __rcDataModel = model;
    }
    
    @QtUninvokable
    private native void setDataModel_native_QScxmlDataModel_ptr(long __this__nativeId, long model);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#initialValues-prop">QScxmlStateMachine::<wbr/>setInitialValues(QVariantMap)</a></code></p>
     */
    @QtPropertyWriter(name="initialValues")
    @QtUninvokable
    public final void setInitialValues(java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> initialValues){
        setInitialValues_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), initialValues);
    }
    
    @QtUninvokable
    private native void setInitialValues_native_cref_QMap(long __this__nativeId, java.util.Map<java.lang.String, ? extends java.lang.Object> initialValues);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#loader-prop">QScxmlStateMachine::<wbr/>setLoader(QScxmlCompiler::Loader*)</a></code></p>
     */
    @QtPropertyWriter(name="loader")
    @QtUninvokable
    public final void setLoader(io.qt.scxml.QScxmlCompiler.@Nullable Loader loader){
        setLoader_native_QScxmlCompiler_Loader_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(loader));
        __rcLoader = loader;
    }
    
    @QtUninvokable
    private native void setLoader_native_QScxmlCompiler_Loader_ptr(long __this__nativeId, long loader);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#setRunning">QScxmlStateMachine::<wbr/>setRunning(bool)</a></code></p>
     */
    @QtPropertyWriter(name="running")
    @QtUninvokable
    public final void setRunning(boolean running){
        setRunning_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), running);
    }
    
    @QtUninvokable
    private native void setRunning_native_bool(long __this__nativeId, boolean running);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#tableData-prop">QScxmlStateMachine::<wbr/>setTableData(QScxmlTableData*)</a></code></p>
     */
    @QtPropertyWriter(name="tableData")
    @QtUninvokable
    public final void setTableData(io.qt.scxml.@Nullable QScxmlTableData tableData){
        setTableData_native_QScxmlTableData_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(tableData));
        __rcTableData = tableData;
    }
    
    @QtUninvokable
    private native void setTableData_native_QScxmlTableData_ptr(long __this__nativeId, long tableData);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#start">QScxmlStateMachine::<wbr/>start()</a></code></p>
     */
    public final void start(){
        start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void start_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#stateNames">QScxmlStateMachine::<wbr/>stateNames(bool)const</a></code></p>
     */
    public final io.qt.core.@NonNull QStringList stateNames(boolean compress){
        return stateNames_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), compress);
    }
    
    private native io.qt.core.QStringList stateNames_native_bool_constfct(long __this__nativeId, boolean compress);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#stop">QScxmlStateMachine::<wbr/>stop()</a></code></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#submitEvent">QScxmlStateMachine::<wbr/>submitEvent(QScxmlEvent*)</a></code></p>
     */
    public final void submitEvent(io.qt.scxml.@Nullable QScxmlEvent event){
        submitEvent_native_QScxmlEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    private native void submitEvent_native_QScxmlEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#submitEvent-1">QScxmlStateMachine::<wbr/>submitEvent(QString)</a></code></p>
     */
    public final void submitEvent(java.lang.@NonNull String eventName){
        submitEvent_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), eventName);
    }
    
    private native void submitEvent_native_cref_QString(long __this__nativeId, java.lang.String eventName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#submitEvent-2">QScxmlStateMachine::<wbr/>submitEvent(QString,<wbr/>QVariant)</a></code></p>
     */
    public final void submitEvent(java.lang.@NonNull String eventName, java.lang.Object data){
        submitEvent_native_cref_QString_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), eventName, data);
    }
    
    private native void submitEvent_native_cref_QString_cref_QVariant(long __this__nativeId, java.lang.String eventName, java.lang.Object data);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#tableData-prop">QScxmlStateMachine::<wbr/>tableData()const</a></code></p>
     */
    @QtPropertyReader(name="tableData")
    @QtUninvokable
    public final io.qt.scxml.@Nullable QScxmlTableData tableData(){
        return tableData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.scxml.QScxmlTableData tableData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#fromData">QScxmlStateMachine::<wbr/>fromData(QIODevice*,<wbr/>QString)</a></code></p>
     */
    public static io.qt.scxml.@Nullable QScxmlStateMachine fromData(io.qt.core.@Nullable QIODevice data, java.lang.@NonNull String fileName){
        return fromData_native_QIODevice_ptr_cref_QString(QtJambi_LibraryUtilities.internal.checkedNativeId(data), fileName);
    }
    
    private native static io.qt.scxml.QScxmlStateMachine fromData_native_QIODevice_ptr_cref_QString(long data, java.lang.String fileName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlstatemachine.html#fromFile">QScxmlStateMachine::<wbr/>fromFile(QString)</a></code></p>
     */
    public native static io.qt.scxml.@Nullable QScxmlStateMachine fromFile(java.lang.@NonNull String fileName);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScxmlStateMachine(QPrivateConstructor p) { super(p); } 
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#onEntry"><code>QScxmlStateMachine::onEntry(QObject, const char*)</code></a></p>
     */
    public static io.qt.core.QMetaObject.Slot1<Boolean> onEntry(io.qt.core.QObject object, String slot){
        io.qt.core.QMetaMethod method = object.metaObject().method(slot);
        if(method==null || !method.isValid())
            throw new QNoSuchSlotException(object, slot);
        return (isEnteringState) -> {
            if (isEnteringState && !object.isDisposed())
                method.invoke(object);
        };
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#onExit"><code>QScxmlStateMachine::onExit(QObject, const char*)</code></a></p>
     */
    public static io.qt.core.QMetaObject.Slot1<Boolean> onExit(io.qt.core.QObject object, String slot){
        io.qt.core.QMetaMethod method = object.metaObject().method(slot);
        if(method==null || !method.isValid())
            throw new QNoSuchSlotException(object, slot);
        return (isEnteringState) -> {
            if (!isEnteringState && !object.isDisposed())
                method.invoke(object);
        };
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#onEntry"><code>QScxmlStateMachine::onEntry(Functor)</code></a></p>
     */
    public static io.qt.core.QMetaObject.Slot1<Boolean> onEntry(io.qt.core.QMetaObject.Slot0 slot){
        io.qt.core.QObject object = QtJambi_LibraryUtilities.internal.lambdaContext(slot);
        return (isEnteringState) -> {
            if (isEnteringState && (object==null || !object.isDisposed()))
                slot.invoke();
        };
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#onExit"><code>QScxmlStateMachine::onExit(Functor)</code></a></p>
     */
    public static io.qt.core.QMetaObject.Slot1<Boolean> onExit(io.qt.core.QMetaObject.Slot0 slot){
        io.qt.core.QObject object = QtJambi_LibraryUtilities.internal.lambdaContext(slot);
        return (isEnteringState) -> {
            if (!isEnteringState && (object==null || !object.isDisposed()))
                slot.invoke();
        };
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#onEntry"><code>QScxmlStateMachine::onEntry(Functor)</code></a></p>
     */
    public static io.qt.core.QMetaObject.Slot1<Boolean> onEntry(io.qt.core.QMetaObject.Emitable0 signal){
        return (isEnteringState) -> {
            if (isEnteringState && !(signal.containingObject() instanceof io.qt.core.QObject && ((io.qt.core.QObject)signal.containingObject()).isDisposed()))
                signal.emit();
        };
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#onExit"><code>QScxmlStateMachine::onExit(Functor)</code></a></p>
     */
    public static io.qt.core.QMetaObject.Slot1<Boolean> onExit(io.qt.core.QMetaObject.Emitable0 signal){
        return (isEnteringState) -> {
            if (!isEnteringState && !(signal.containingObject() instanceof io.qt.core.QObject && ((io.qt.core.QObject)signal.containingObject()).isDisposed()))
                signal.emit();
        };
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToState"><code>QScxmlStateMachine::connectToState(QString, Functor, Qt::ConnectionType)</code></a></p>
     */
    public io.qt.core.QMetaObject.@NonNull Connection connectToState(@NonNull String scxmlStateName,
            io.qt.core.QMetaObject.@StrictNonNull Connectable0 signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... type){
        io.qt.core.QObject object = null;
        if(signal.containingObject() instanceof io.qt.core.QObject){
            object = (io.qt.core.QObject)signal.containingObject();
        }
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromSignal(java.util.Objects.requireNonNull(signal));
        if(metaMethod!=null && metaMethod.isValid() && metaMethod.parameterCount()==0) {
            if(object!=null) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToState(scxmlStateName, object, "2"+metaMethod.cppMethodSignature(), type);
                case Method:
                case Slot:
                    return connectToState(scxmlStateName, object, "1"+metaMethod.cppMethodSignature(), type);
                default:
                    break;
                }
            }
        }
        if(signal instanceof io.qt.core.QMetaObject.Emitable0)
            return connectToState(scxmlStateName, object, (io.qt.core.QMetaObject.Slot0)((io.qt.core.QMetaObject.Emitable0)signal)::emit, type);
        else return connectToState(scxmlStateName, object, (String)null, type);
    }
        
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToState"><code>QScxmlStateMachine::connectToState(QString, Functor, Qt::ConnectionType)</code></a></p>
     */
    @SuppressWarnings("unchecked")
    public io.qt.core.QMetaObject.@NonNull Connection connectToState(@NonNull String scxmlStateName,
            io.qt.core.QMetaObject.@StrictNonNull Connectable1<Boolean> signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... type){
        io.qt.core.QObject object = null;
        if(signal.containingObject() instanceof io.qt.core.QObject){
            object = (io.qt.core.QObject)signal.containingObject();
        }
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromSignal(java.util.Objects.requireNonNull(signal));
        if(metaMethod!=null && metaMethod.isValid()) {
            if(metaMethod.parameterCount()!=1 || metaMethod.parameterType(0)!=io.qt.core.QMetaType.Type.Bool.value()) {
                throw new IllegalArgumentException("Method does not take a single boolean argument: "+metaMethod.cppMethodSignature());
            }
            if(object!=null) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToState(scxmlStateName, object, "2"+metaMethod.cppMethodSignature(), type);
                case Method:
                case Slot:
                    return connectToState(scxmlStateName, object, "1"+metaMethod.cppMethodSignature(), type);
                default:
                    break;
                }
            }
        }
        if(signal instanceof io.qt.core.QMetaObject.Emitable1)
            return connectToState(scxmlStateName, object, (io.qt.core.QMetaObject.Slot1<Boolean>)((io.qt.core.QMetaObject.Emitable1<Boolean>)signal)::emit, type);
        else return connectToState(scxmlStateName, object, (String)null, type);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToEvent"><code>QScxmlStateMachine::connectToEvent(QString, Functor, Qt::ConnectionType)</code></a></p>
     */
    public io.qt.core.QMetaObject.@NonNull Connection connectToEvent(@NonNull String scxmlStateName,
            io.qt.core.QMetaObject.@StrictNonNull Connectable0 signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... type){
        io.qt.core.QObject object = null;
        if(signal.containingObject() instanceof io.qt.core.QObject){
            object = (io.qt.core.QObject)signal.containingObject();
        }
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromSignal(java.util.Objects.requireNonNull(signal));
        if(metaMethod!=null && metaMethod.isValid() && metaMethod.parameterCount()==0) {
            if(object!=null) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToEvent(scxmlStateName, object, "2"+metaMethod.cppMethodSignature(), type);
                case Method:
                case Slot:
                    return connectToEvent(scxmlStateName, object, "1"+metaMethod.cppMethodSignature(), type);
                default:
                    break;
                }
            }
        }
        if(signal instanceof io.qt.core.QMetaObject.Emitable0)
            return connectToEvent(scxmlStateName, object, (io.qt.core.QMetaObject.Slot0)((io.qt.core.QMetaObject.Emitable0)signal)::emit, type);
        else
            return connectToEvent(scxmlStateName, object, (String)null, type);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToEvent"><code>QScxmlStateMachine::connectToEvent(QString, Functor, Qt::ConnectionType)</code></a></p>
     */
    @SuppressWarnings("unchecked")
    public io.qt.core.QMetaObject.@NonNull Connection connectToEvent(@NonNull String scxmlStateName,
            io.qt.core.QMetaObject.@StrictNonNull Connectable1<QScxmlEvent> signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... type){
        io.qt.core.QObject object = null;
        if(signal.containingObject() instanceof io.qt.core.QObject){
            object = (io.qt.core.QObject)signal.containingObject();
        }
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromSignal(java.util.Objects.requireNonNull(signal));
        if(metaMethod!=null && metaMethod.isValid()) {
            if(metaMethod.parameterCount()!=1 || metaMethod.parameterType(0)!=io.qt.core.QMetaType.fromType(QScxmlEvent.class).id()) {
                throw new IllegalArgumentException("Method does not take a single QScxmlEvent argument: "+metaMethod.cppMethodSignature());
            }
            if(object!=null) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToEvent(scxmlStateName, object, "2"+metaMethod.cppMethodSignature(), type);
                case Method:
                case Slot:
                    return connectToEvent(scxmlStateName, object, "1"+metaMethod.cppMethodSignature(), type);
                default:
                    break;
                }
            }
        }
        if(signal instanceof io.qt.core.QMetaObject.Emitable1)
            return connectToEvent(scxmlStateName, object, (io.qt.core.QMetaObject.Slot1<QScxmlEvent>)((io.qt.core.QMetaObject.Emitable1<QScxmlEvent>)signal)::emit, type);
        else return connectToEvent(scxmlStateName, object, (String)null, type);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QScxmlStateMachine(io.qt.core.QMetaObject, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    protected QScxmlStateMachine(io.qt.core.@Nullable QMetaObject metaObject) {
        this(metaObject, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #activeStateNames(boolean)}
     *  with <code>compress = true</code>.</p>
     */
    public final io.qt.core.@NonNull QStringList activeStateNames() {
        return activeStateNames((boolean)true);
    }
    
    /**
     * <p>Overloaded function for {@link #connectToEvent(java.lang.String, io.qt.core.QObject, java.lang.String, io.qt.core.Qt.ConnectionType[])}
     *  with <code>type = io.qt.core.Qt.ConnectionType.AutoConnection</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToEvent(java.lang.@NonNull String scxmlEventSpec, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String method) {
        return connectToEvent(scxmlEventSpec, receiver, method, io.qt.core.Qt.ConnectionType.AutoConnection);
    }
    
    /**
     * <p>Overloaded function for {@link #connectToEvent(java.lang.String, io.qt.core.QObject, io.qt.core.QMetaObject.Slot0, io.qt.core.Qt.ConnectionType[])}
     *  with <code>type = io.qt.core.Qt.ConnectionType.AutoConnection</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToEvent(java.lang.@NonNull String scxmlEventSpec, io.qt.core.@Nullable QObject context, io.qt.core.QMetaObject.@StrictNonNull Slot0 functor) {
        return connectToEvent(scxmlEventSpec, context, functor, io.qt.core.Qt.ConnectionType.AutoConnection);
    }
    
    /**
     * <p>Overloaded function for {@link #connectToEvent(java.lang.String, io.qt.core.QMetaObject.Slot0, io.qt.core.Qt.ConnectionType[])}
     *  with <code>type = io.qt.core.Qt.ConnectionType.AutoConnection</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToEvent(java.lang.@NonNull String scxmlEventSpec, io.qt.core.QMetaObject.@StrictNonNull Slot0 functor) {
        return connectToEvent(scxmlEventSpec, QtJambi_LibraryUtilities.internal.lambdaContext(functor), functor, io.qt.core.Qt.ConnectionType.AutoConnection);
    }
    
    /**
     * <p>Overloaded function for {@link #connectToEvent(java.lang.String, io.qt.core.QObject, io.qt.core.QMetaObject.Slot0, io.qt.core.Qt.ConnectionType[])}.</p>
     */
    @SafeVarargs
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToEvent(java.lang.@NonNull String scxmlEventSpec, io.qt.core.QMetaObject.@StrictNonNull Slot0 functor, io.qt.core.Qt.@NonNull ConnectionType @NonNull... type) {
        return connectToEvent(scxmlEventSpec, QtJambi_LibraryUtilities.internal.lambdaContext(functor), functor, type);
    }
    
    /**
     * <p>Overloaded function for {@link #connectToEvent(java.lang.String, io.qt.core.QObject, io.qt.core.QMetaObject.Slot1, io.qt.core.Qt.ConnectionType[])}
     *  with <code>type = io.qt.core.Qt.ConnectionType.AutoConnection</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToEvent(java.lang.@NonNull String scxmlEventSpec, io.qt.core.@Nullable QObject context, io.qt.core.QMetaObject.@StrictNonNull Slot1<@NonNull QScxmlEvent> functor) {
        return connectToEvent(scxmlEventSpec, context, functor, io.qt.core.Qt.ConnectionType.AutoConnection);
    }
    
    /**
     * <p>Overloaded function for {@link #connectToEvent(java.lang.String, io.qt.core.QMetaObject.Slot1, io.qt.core.Qt.ConnectionType[])}
     *  with <code>type = io.qt.core.Qt.ConnectionType.AutoConnection</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToEvent(java.lang.@NonNull String scxmlEventSpec, io.qt.core.QMetaObject.@StrictNonNull Slot1<@NonNull QScxmlEvent> functor) {
        return connectToEvent(scxmlEventSpec, QtJambi_LibraryUtilities.internal.lambdaContext(functor), functor, io.qt.core.Qt.ConnectionType.AutoConnection);
    }
    
    /**
     * <p>Overloaded function for {@link #connectToEvent(java.lang.String, io.qt.core.QObject, io.qt.core.QMetaObject.Slot1, io.qt.core.Qt.ConnectionType[])}.</p>
     */
    @SafeVarargs
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToEvent(java.lang.@NonNull String scxmlEventSpec, io.qt.core.QMetaObject.@StrictNonNull Slot1<@NonNull QScxmlEvent> functor, io.qt.core.Qt.@NonNull ConnectionType @NonNull... type) {
        return connectToEvent(scxmlEventSpec, QtJambi_LibraryUtilities.internal.lambdaContext(functor), functor, type);
    }
    
    /**
     * <p>Overloaded function for {@link #connectToState(java.lang.String, io.qt.core.QObject, java.lang.String, io.qt.core.Qt.ConnectionType[])}
     *  with <code>type = io.qt.core.Qt.ConnectionType.AutoConnection</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToState(java.lang.@NonNull String scxmlStateName, io.qt.core.@Nullable QObject receiver, java.lang.@Nullable String method) {
        return connectToState(scxmlStateName, receiver, method, io.qt.core.Qt.ConnectionType.AutoConnection);
    }
    
    /**
     * <p>Overloaded function for {@link #connectToState(java.lang.String, io.qt.core.QObject, io.qt.core.QMetaObject.Slot0, io.qt.core.Qt.ConnectionType[])}
     *  with <code>type = io.qt.core.Qt.ConnectionType.AutoConnection</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToState(java.lang.@NonNull String scxmlStateName, io.qt.core.@Nullable QObject context, io.qt.core.QMetaObject.@StrictNonNull Slot0 functor) {
        return connectToState(scxmlStateName, context, functor, io.qt.core.Qt.ConnectionType.AutoConnection);
    }
    
    /**
     * <p>Overloaded function for {@link #connectToState(java.lang.String, io.qt.core.QMetaObject.Slot0, io.qt.core.Qt.ConnectionType[])}
     *  with <code>type = io.qt.core.Qt.ConnectionType.AutoConnection</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToState(java.lang.@NonNull String scxmlStateName, io.qt.core.QMetaObject.@StrictNonNull Slot0 functor) {
        return connectToState(scxmlStateName, QtJambi_LibraryUtilities.internal.lambdaContext(functor), functor, io.qt.core.Qt.ConnectionType.AutoConnection);
    }
    
    /**
     * <p>Overloaded function for {@link #connectToState(java.lang.String, io.qt.core.QObject, io.qt.core.QMetaObject.Slot0, io.qt.core.Qt.ConnectionType[])}.</p>
     */
    @SafeVarargs
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToState(java.lang.@NonNull String scxmlStateName, io.qt.core.QMetaObject.@StrictNonNull Slot0 functor, io.qt.core.Qt.@NonNull ConnectionType @NonNull... type) {
        return connectToState(scxmlStateName, QtJambi_LibraryUtilities.internal.lambdaContext(functor), functor, type);
    }
    
    /**
     * <p>Overloaded function for {@link #connectToState(java.lang.String, io.qt.core.QObject, io.qt.core.QMetaObject.Slot1, io.qt.core.Qt.ConnectionType[])}
     *  with <code>type = io.qt.core.Qt.ConnectionType.AutoConnection</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToState(java.lang.@NonNull String scxmlStateName, io.qt.core.@Nullable QObject context, io.qt.core.QMetaObject.@StrictNonNull Slot1<@QtPrimitiveType@NonNull Boolean> functor) {
        return connectToState(scxmlStateName, context, functor, io.qt.core.Qt.ConnectionType.AutoConnection);
    }
    
    /**
     * <p>Overloaded function for {@link #connectToState(java.lang.String, io.qt.core.QMetaObject.Slot1, io.qt.core.Qt.ConnectionType[])}
     *  with <code>type = io.qt.core.Qt.ConnectionType.AutoConnection</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToState(java.lang.@NonNull String scxmlStateName, io.qt.core.QMetaObject.@StrictNonNull Slot1<@QtPrimitiveType@NonNull Boolean> functor) {
        return connectToState(scxmlStateName, QtJambi_LibraryUtilities.internal.lambdaContext(functor), functor, io.qt.core.Qt.ConnectionType.AutoConnection);
    }
    
    /**
     * <p>Overloaded function for {@link #connectToState(java.lang.String, io.qt.core.QObject, io.qt.core.QMetaObject.Slot1, io.qt.core.Qt.ConnectionType[])}.</p>
     */
    @SafeVarargs
    @QtUninvokable
    public final io.qt.core.QMetaObject.@NonNull Connection connectToState(java.lang.@NonNull String scxmlStateName, io.qt.core.QMetaObject.@StrictNonNull Slot1<@QtPrimitiveType@NonNull Boolean> functor, io.qt.core.Qt.@NonNull ConnectionType @NonNull... type) {
        return connectToState(scxmlStateName, QtJambi_LibraryUtilities.internal.lambdaContext(functor), functor, type);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #dataModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.scxml.@Nullable QScxmlDataModel getDataModel() {
        return dataModel();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #initialValues()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QMap<java.lang.@NonNull String, java.lang.Object> getInitialValues() {
        return initialValues();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #invokedServices()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.scxml.@Nullable QScxmlInvokableService> getInvokedServices() {
        return invokedServices();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isInitialized()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getInitialized() {
        return isInitialized();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isInvoked()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getInvoked() {
        return isInvoked();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isRunning()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getRunning() {
        return isRunning();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #loader()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.scxml.QScxmlCompiler.@Nullable Loader getLoader() {
        return loader();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #name()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getName() {
        return name();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #parseErrors()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.scxml.@NonNull QScxmlError> getParseErrors() {
        return parseErrors();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #sessionId()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getSessionId() {
        return sessionId();
    }
    
    /**
     * <p>Overloaded function for {@link #stateNames(boolean)}
     *  with <code>compress = true</code>.</p>
     */
    public final io.qt.core.@NonNull QStringList stateNames() {
        return stateNames((boolean)true);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #tableData()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.scxml.@Nullable QScxmlTableData getTableData() {
        return tableData();
    }
    
    /**
     * <p>Overloaded function for {@link #fromData(io.qt.core.QIODevice, java.lang.String)}
     *  with <code>fileName = (String)null</code>.</p>
     */
    public static io.qt.scxml.@Nullable QScxmlStateMachine fromData(io.qt.core.@Nullable QIODevice data) {
        return fromData(data, (String)null);
    }
}
