package io.qt.scxml;

import io.qt.*;


/**
 * <p>Contains various types used to interpret executable content in state machines</p>
 * <p>Java wrapper for Qt header file <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent.html">QScxmlExecutableContent</a></code></p>
 */
public final class QScxmlExecutableContent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QScxmlExecutableContent() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QScxmlExecutableContent."); }
    
    /**
     * <p>Represents a unit of executable content</p>
     * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-evaluatorinfo.html">QScxmlExecutableContent::EvaluatorInfo</a></code></p>
     */
    public static class EvaluatorInfo extends QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <code>QScxmlExecutableContent::EvaluatorInfo::<wbr/>EvaluatorInfo()</code></p>
         */
        public EvaluatorInfo(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(EvaluatorInfo instance);
        
        /**
         * <p>See <code>QScxmlExecutableContent::EvaluatorInfo::<wbr/>EvaluatorInfo(QScxmlExecutableContent::EvaluatorInfo)</code></p>
         */
        public EvaluatorInfo(io.qt.scxml.QScxmlExecutableContent.@NonNull EvaluatorInfo other){
            super((QPrivateConstructor)null);
            initialize_native(this, other);
        }
        
        private native static void initialize_native(EvaluatorInfo instance, io.qt.scxml.QScxmlExecutableContent.EvaluatorInfo other);
        
        /**
         * <p>See <code>QScxmlExecutableContent::EvaluatorInfo::<wbr/>EvaluatorInfo{qint32,<wbr/>qint32}</code></p>
         */
        public EvaluatorInfo(int expr, int context){
            super((QPrivateConstructor)null);
            initialize_native(this, expr, context);
        }
        
        private native static void initialize_native(EvaluatorInfo instance, int expr, int context);
        
        /**
         * <p>For evaluating the expression</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-evaluatorinfo.html#context-var">QScxmlExecutableContent::EvaluatorInfo::<wbr/>context</a></code></p>
         */
        @QtUninvokable
        public final void setContext(int context){
            setContext_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), context);
        }
        
        @QtUninvokable
        private native void setContext_native_qint32(long __this__nativeId, int context);
        
        /**
         * <p>For evaluating the expression</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-evaluatorinfo.html#context-var">QScxmlExecutableContent::EvaluatorInfo::<wbr/>context</a></code></p>
         */
        @QtUninvokable
        public final int context(){
            return context_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int context_native(long __this__nativeId);
        
        /**
         * <p>Expression to be evaluated</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-evaluatorinfo.html#expr-var">QScxmlExecutableContent::EvaluatorInfo::<wbr/>expr</a></code></p>
         */
        @QtUninvokable
        public final void setExpr(int expr){
            setExpr_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), expr);
        }
        
        @QtUninvokable
        private native void setExpr_native_qint32(long __this__nativeId, int expr);
        
        /**
         * <p>Expression to be evaluated</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-evaluatorinfo.html#expr-var">QScxmlExecutableContent::EvaluatorInfo::<wbr/>expr</a></code></p>
         */
        @QtUninvokable
        public final int expr(){
            return expr_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int expr_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected EvaluatorInfo(QPrivateConstructor p) { super(p); } 
        
        
        /**
         * <p>Creates and returns a copy of this object.</p>
        <p>See <code>QScxmlExecutableContent::EvaluatorInfo::<wbr/>EvaluatorInfo(QScxmlExecutableContent::EvaluatorInfo)</code></p>
         */
        @QtUninvokable
        @Override
        public EvaluatorInfo clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native EvaluatorInfo clone_native(long __this_nativeId);
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #context()} instead.</p>
         */
        @QtUninvokable
        public final int getContext() {
            return context();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #expr()} instead.</p>
         */
        @QtUninvokable
        public final int getExpr() {
            return expr();
        }
    }
    /**
     * <p>AssingmentInfo class represents a data assignment</p>
     * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-assignmentinfo.html">QScxmlExecutableContent::AssignmentInfo</a></code></p>
     */
    public static class AssignmentInfo extends QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <code>QScxmlExecutableContent::AssignmentInfo::<wbr/>AssignmentInfo()</code></p>
         */
        public AssignmentInfo(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(AssignmentInfo instance);
        
        /**
         * <p>See <code>QScxmlExecutableContent::AssignmentInfo::<wbr/>AssignmentInfo(QScxmlExecutableContent::AssignmentInfo)</code></p>
         */
        public AssignmentInfo(io.qt.scxml.QScxmlExecutableContent.@NonNull AssignmentInfo other){
            super((QPrivateConstructor)null);
            initialize_native(this, other);
        }
        
        private native static void initialize_native(AssignmentInfo instance, io.qt.scxml.QScxmlExecutableContent.AssignmentInfo other);
        
        /**
         * <p>See <code>QScxmlExecutableContent::AssignmentInfo::<wbr/>AssignmentInfo{qint32,<wbr/>qint32,<wbr/>qint32}</code></p>
         */
        public AssignmentInfo(int dest, int expr, int context){
            super((QPrivateConstructor)null);
            initialize_native(this, dest, expr, context);
        }
        
        private native static void initialize_native(AssignmentInfo instance, int dest, int expr, int context);
        
        /**
         * <p>For evaluating the expression</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-assignmentinfo.html#context-var">QScxmlExecutableContent::AssignmentInfo::<wbr/>context</a></code></p>
         */
        @QtUninvokable
        public final void setContext(int context){
            setContext_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), context);
        }
        
        @QtUninvokable
        private native void setContext_native_qint32(long __this__nativeId, int context);
        
        /**
         * <p>For evaluating the expression</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-assignmentinfo.html#context-var">QScxmlExecutableContent::AssignmentInfo::<wbr/>context</a></code></p>
         */
        @QtUninvokable
        public final int context(){
            return context_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int context_native(long __this__nativeId);
        
        /**
         * <p>Name of the data item to assign to</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-assignmentinfo.html#dest-var">QScxmlExecutableContent::AssignmentInfo::<wbr/>dest</a></code></p>
         */
        @QtUninvokable
        public final void setDest(int dest){
            setDest_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), dest);
        }
        
        @QtUninvokable
        private native void setDest_native_qint32(long __this__nativeId, int dest);
        
        /**
         * <p>Name of the data item to assign to</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-assignmentinfo.html#dest-var">QScxmlExecutableContent::AssignmentInfo::<wbr/>dest</a></code></p>
         */
        @QtUninvokable
        public final int dest(){
            return dest_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int dest_native(long __this__nativeId);
        
        /**
         * <p>Expression to be evaluated</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-assignmentinfo.html#expr-var">QScxmlExecutableContent::AssignmentInfo::<wbr/>expr</a></code></p>
         */
        @QtUninvokable
        public final void setExpr(int expr){
            setExpr_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), expr);
        }
        
        @QtUninvokable
        private native void setExpr_native_qint32(long __this__nativeId, int expr);
        
        /**
         * <p>Expression to be evaluated</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-assignmentinfo.html#expr-var">QScxmlExecutableContent::AssignmentInfo::<wbr/>expr</a></code></p>
         */
        @QtUninvokable
        public final int expr(){
            return expr_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int expr_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected AssignmentInfo(QPrivateConstructor p) { super(p); } 
        
        
        /**
         * <p>Creates and returns a copy of this object.</p>
        <p>See <code>QScxmlExecutableContent::AssignmentInfo::<wbr/>AssignmentInfo(QScxmlExecutableContent::AssignmentInfo)</code></p>
         */
        @QtUninvokable
        @Override
        public AssignmentInfo clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native AssignmentInfo clone_native(long __this_nativeId);
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #context()} instead.</p>
         */
        @QtUninvokable
        public final int getContext() {
            return context();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #dest()} instead.</p>
         */
        @QtUninvokable
        public final int getDest() {
            return dest();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #expr()} instead.</p>
         */
        @QtUninvokable
        public final int getExpr() {
            return expr();
        }
    }
    /**
     * <p>Represents a foreach construct</p>
     * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html">QScxmlExecutableContent::ForeachInfo</a></code></p>
     */
    public static class ForeachInfo extends QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <code>QScxmlExecutableContent::ForeachInfo::<wbr/>ForeachInfo()</code></p>
         */
        public ForeachInfo(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(ForeachInfo instance);
        
        /**
         * <p>See <code>QScxmlExecutableContent::ForeachInfo::<wbr/>ForeachInfo(QScxmlExecutableContent::ForeachInfo)</code></p>
         */
        public ForeachInfo(io.qt.scxml.QScxmlExecutableContent.@NonNull ForeachInfo other){
            super((QPrivateConstructor)null);
            initialize_native(this, other);
        }
        
        private native static void initialize_native(ForeachInfo instance, io.qt.scxml.QScxmlExecutableContent.ForeachInfo other);
        
        /**
         * <p>See <code>QScxmlExecutableContent::ForeachInfo::<wbr/>ForeachInfo{qint32,<wbr/>qint32,<wbr/>qint32,<wbr/>qint32}</code></p>
         */
        public ForeachInfo(int array, int item, int index, int context){
            super((QPrivateConstructor)null);
            initialize_native(this, array, item, index, context);
        }
        
        private native static void initialize_native(ForeachInfo instance, int array, int item, int index, int context);
        
        /**
         * <p>Name of the array that is iterated over</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#array-var">QScxmlExecutableContent::ForeachInfo::<wbr/>array</a></code></p>
         */
        @QtUninvokable
        public final void setArray(int array){
            setArray_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), array);
        }
        
        @QtUninvokable
        private native void setArray_native_qint32(long __this__nativeId, int array);
        
        /**
         * <p>Name of the array that is iterated over</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#array-var">QScxmlExecutableContent::ForeachInfo::<wbr/>array</a></code></p>
         */
        @QtUninvokable
        public final int array(){
            return array_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int array_native(long __this__nativeId);
        
        /**
         * <p>For evaluating the expression</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#context-var">QScxmlExecutableContent::ForeachInfo::<wbr/>context</a></code></p>
         */
        @QtUninvokable
        public final void setContext(int context){
            setContext_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), context);
        }
        
        @QtUninvokable
        private native void setContext_native_qint32(long __this__nativeId, int context);
        
        /**
         * <p>For evaluating the expression</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#context-var">QScxmlExecutableContent::ForeachInfo::<wbr/>context</a></code></p>
         */
        @QtUninvokable
        public final int context(){
            return context_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int context_native(long __this__nativeId);
        
        /**
         * <p>Name of the index variable</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#index-var">QScxmlExecutableContent::ForeachInfo::<wbr/>index</a></code></p>
         */
        @QtUninvokable
        public final void setIndex(int index){
            setIndex_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), index);
        }
        
        @QtUninvokable
        private native void setIndex_native_qint32(long __this__nativeId, int index);
        
        /**
         * <p>Name of the index variable</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#index-var">QScxmlExecutableContent::ForeachInfo::<wbr/>index</a></code></p>
         */
        @QtUninvokable
        public final int index(){
            return index_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int index_native(long __this__nativeId);
        
        /**
         * <p>Name of the iteration variable</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#item-var">QScxmlExecutableContent::ForeachInfo::<wbr/>item</a></code></p>
         */
        @QtUninvokable
        public final void setItem(int item){
            setItem_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), item);
        }
        
        @QtUninvokable
        private native void setItem_native_qint32(long __this__nativeId, int item);
        
        /**
         * <p>Name of the iteration variable</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#item-var">QScxmlExecutableContent::ForeachInfo::<wbr/>item</a></code></p>
         */
        @QtUninvokable
        public final int item(){
            return item_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int item_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected ForeachInfo(QPrivateConstructor p) { super(p); } 
        
        
        /**
         * <p>Creates and returns a copy of this object.</p>
        <p>See <code>QScxmlExecutableContent::ForeachInfo::<wbr/>ForeachInfo(QScxmlExecutableContent::ForeachInfo)</code></p>
         */
        @QtUninvokable
        @Override
        public ForeachInfo clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native ForeachInfo clone_native(long __this_nativeId);
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #array()} instead.</p>
         */
        @QtUninvokable
        public final int getArray() {
            return array();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #context()} instead.</p>
         */
        @QtUninvokable
        public final int getContext() {
            return context();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #index()} instead.</p>
         */
        @QtUninvokable
        public final int getIndex() {
            return index();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #item()} instead.</p>
         */
        @QtUninvokable
        public final int getItem() {
            return item();
        }
    }
    /**
     * <p>Represents a parameter to a service invocation</p>
     * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-parameterinfo.html">QScxmlExecutableContent::ParameterInfo</a></code></p>
     */
    public static class ParameterInfo extends QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <code>QScxmlExecutableContent::ParameterInfo::<wbr/>ParameterInfo()</code></p>
         */
        public ParameterInfo(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(ParameterInfo instance);
        
        /**
         * <p>See <code>QScxmlExecutableContent::ParameterInfo::<wbr/>ParameterInfo(QScxmlExecutableContent::ParameterInfo)</code></p>
         */
        public ParameterInfo(io.qt.scxml.QScxmlExecutableContent.@NonNull ParameterInfo other){
            super((QPrivateConstructor)null);
            initialize_native(this, other);
        }
        
        private native static void initialize_native(ParameterInfo instance, io.qt.scxml.QScxmlExecutableContent.ParameterInfo other);
        
        /**
         * <p>See <code>QScxmlExecutableContent::ParameterInfo::<wbr/>ParameterInfo{qint32,<wbr/>qint32,<wbr/>qint32}</code></p>
         */
        public ParameterInfo(int name, int expr, int location){
            super((QPrivateConstructor)null);
            initialize_native(this, name, expr, location);
        }
        
        private native static void initialize_native(ParameterInfo instance, int name, int expr, int location);
        
        /**
         * <p>Expression to be evaluated</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-parameterinfo.html#expr-var">QScxmlExecutableContent::ParameterInfo::<wbr/>expr</a></code></p>
         */
        @QtUninvokable
        public final void setExpr(int expr){
            setExpr_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), expr);
        }
        
        @QtUninvokable
        private native void setExpr_native_qint32(long __this__nativeId, int expr);
        
        /**
         * <p>Expression to be evaluated</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-parameterinfo.html#expr-var">QScxmlExecutableContent::ParameterInfo::<wbr/>expr</a></code></p>
         */
        @QtUninvokable
        public final int expr(){
            return expr_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int expr_native(long __this__nativeId);
        
        /**
         * <p>Data model name of the item to be passed as a parameter</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-parameterinfo.html#location-var">QScxmlExecutableContent::ParameterInfo::<wbr/>location</a></code></p>
         */
        @QtUninvokable
        public final void setLocation(int location){
            setLocation_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), location);
        }
        
        @QtUninvokable
        private native void setLocation_native_qint32(long __this__nativeId, int location);
        
        /**
         * <p>Data model name of the item to be passed as a parameter</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-parameterinfo.html#location-var">QScxmlExecutableContent::ParameterInfo::<wbr/>location</a></code></p>
         */
        @QtUninvokable
        public final int location(){
            return location_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int location_native(long __this__nativeId);
        
        /**
         * <p>Of the parameter</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-parameterinfo.html#name-var">QScxmlExecutableContent::ParameterInfo::<wbr/>name</a></code></p>
         */
        @QtUninvokable
        public final void setName(int name){
            setName_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), name);
        }
        
        @QtUninvokable
        private native void setName_native_qint32(long __this__nativeId, int name);
        
        /**
         * <p>Of the parameter</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-parameterinfo.html#name-var">QScxmlExecutableContent::ParameterInfo::<wbr/>name</a></code></p>
         */
        @QtUninvokable
        public final int name(){
            return name_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int name_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected ParameterInfo(QPrivateConstructor p) { super(p); } 
        
        
        /**
         * <p>Creates and returns a copy of this object.</p>
        <p>See <code>QScxmlExecutableContent::ParameterInfo::<wbr/>ParameterInfo(QScxmlExecutableContent::ParameterInfo)</code></p>
         */
        @QtUninvokable
        @Override
        public ParameterInfo clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native ParameterInfo clone_native(long __this_nativeId);
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #expr()} instead.</p>
         */
        @QtUninvokable
        public final int getExpr() {
            return expr();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #location()} instead.</p>
         */
        @QtUninvokable
        public final int getLocation() {
            return location();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #name()} instead.</p>
         */
        @QtUninvokable
        public final int getName() {
            return name();
        }
    }
    /**
     * <p>Represents a service invocation</p>
     * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html">QScxmlExecutableContent::InvokeInfo</a></code></p>
     */
    public static class InvokeInfo extends QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <code>QScxmlExecutableContent::InvokeInfo::<wbr/>InvokeInfo()</code></p>
         */
        public InvokeInfo(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(InvokeInfo instance);
        
        /**
         * <p>See <code>QScxmlExecutableContent::InvokeInfo::<wbr/>InvokeInfo(QScxmlExecutableContent::InvokeInfo)</code></p>
         */
        public InvokeInfo(io.qt.scxml.QScxmlExecutableContent.@NonNull InvokeInfo other){
            super((QPrivateConstructor)null);
            initialize_native(this, other);
        }
        
        private native static void initialize_native(InvokeInfo instance, io.qt.scxml.QScxmlExecutableContent.InvokeInfo other);
        
        /**
         * <p>See <code>QScxmlExecutableContent::InvokeInfo::<wbr/>InvokeInfo{qint32,<wbr/>qint32,<wbr/>qint32,<wbr/>qint32,<wbr/>qint32,<wbr/>qint32,<wbr/>bool}</code></p>
         */
        public InvokeInfo(int id, int prefix, int location, int context, int expr, int finalize, boolean autoforward){
            super((QPrivateConstructor)null);
            initialize_native(this, id, prefix, location, context, expr, finalize, autoforward);
        }
        
        private native static void initialize_native(InvokeInfo instance, int id, int prefix, int location, int context, int expr, int finalize, boolean autoforward);
        
        /**
         * <p>Whether events should automatically be forwarded to the invoked service</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#autoforward-var">QScxmlExecutableContent::InvokeInfo::<wbr/>autoforward</a></code></p>
         */
        @QtUninvokable
        public final void setAutoforward(boolean autoforward){
            setAutoforward_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), autoforward);
        }
        
        @QtUninvokable
        private native void setAutoforward_native_bool(long __this__nativeId, boolean autoforward);
        
        /**
         * <p>Whether events should automatically be forwarded to the invoked service</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#autoforward-var">QScxmlExecutableContent::InvokeInfo::<wbr/>autoforward</a></code></p>
         */
        @QtUninvokable
        public final boolean autoforward(){
            return autoforward_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native boolean autoforward_native(long __this__nativeId);
        
        /**
         * <p>To interpret the location in</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#context-var">QScxmlExecutableContent::InvokeInfo::<wbr/>context</a></code></p>
         */
        @QtUninvokable
        public final void setContext(int context){
            setContext_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), context);
        }
        
        @QtUninvokable
        private native void setContext_native_qint32(long __this__nativeId, int context);
        
        /**
         * <p>To interpret the location in</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#context-var">QScxmlExecutableContent::InvokeInfo::<wbr/>context</a></code></p>
         */
        @QtUninvokable
        public final int context(){
            return context_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int context_native(long __this__nativeId);
        
        /**
         * <p>Expression representing the srcexpr of the invoke element</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#expr-var">QScxmlExecutableContent::InvokeInfo::<wbr/>expr</a></code></p>
         */
        @QtUninvokable
        public final void setExpr(int expr){
            setExpr_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), expr);
        }
        
        @QtUninvokable
        private native void setExpr_native_qint32(long __this__nativeId, int expr);
        
        /**
         * <p>Expression representing the srcexpr of the invoke element</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#expr-var">QScxmlExecutableContent::InvokeInfo::<wbr/>expr</a></code></p>
         */
        @QtUninvokable
        public final int expr(){
            return expr_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int expr_native(long __this__nativeId);
        
        /**
         * <p>ID of the container of executable content to be run on finalizing the invocation</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#finalize-var">QScxmlExecutableContent::InvokeInfo::<wbr/>finalize</a></code></p>
         */
        @QtUninvokable
        public final void setFinalizeId(int finalizeId){
            setFinalizeId_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), finalizeId);
        }
        
        @QtUninvokable
        private native void setFinalizeId_native_qint32(long __this__nativeId, int finalizeId);
        
        /**
         * <p>ID of the container of executable content to be run on finalizing the invocation</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#finalize-var">QScxmlExecutableContent::InvokeInfo::<wbr/>finalize</a></code></p>
         */
        @QtUninvokable
        public final int finalizeId(){
            return finalizeId_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int finalizeId_native(long __this__nativeId);
        
        /**
         * <p>ID specified by the id attribute in the &lt;invoke&gt; element</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#id-var">QScxmlExecutableContent::InvokeInfo::<wbr/>id</a></code></p>
         */
        @QtUninvokable
        public final void setId(int id){
            setId_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), id);
        }
        
        @QtUninvokable
        private native void setId_native_qint32(long __this__nativeId, int id);
        
        /**
         * <p>ID specified by the id attribute in the &lt;invoke&gt; element</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#id-var">QScxmlExecutableContent::InvokeInfo::<wbr/>id</a></code></p>
         */
        @QtUninvokable
        public final int id(){
            return id_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int id_native(long __this__nativeId);
        
        /**
         * <p>Data model location to write the invocation ID to</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#location-var">QScxmlExecutableContent::InvokeInfo::<wbr/>location</a></code></p>
         */
        @QtUninvokable
        public final void setLocation(int location){
            setLocation_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), location);
        }
        
        @QtUninvokable
        private native void setLocation_native_qint32(long __this__nativeId, int location);
        
        /**
         * <p>Data model location to write the invocation ID to</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#location-var">QScxmlExecutableContent::InvokeInfo::<wbr/>location</a></code></p>
         */
        @QtUninvokable
        public final int location(){
            return location_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int location_native(long __this__nativeId);
        
        /**
         * <p>Unique prefix for this invocation in the context of the state from which it is called</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#prefix-var">QScxmlExecutableContent::InvokeInfo::<wbr/>prefix</a></code></p>
         */
        @QtUninvokable
        public final void setPrefix(int prefix){
            setPrefix_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), prefix);
        }
        
        @QtUninvokable
        private native void setPrefix_native_qint32(long __this__nativeId, int prefix);
        
        /**
         * <p>Unique prefix for this invocation in the context of the state from which it is called</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#prefix-var">QScxmlExecutableContent::InvokeInfo::<wbr/>prefix</a></code></p>
         */
        @QtUninvokable
        public final int prefix(){
            return prefix_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int prefix_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected InvokeInfo(QPrivateConstructor p) { super(p); } 
        
        
        /**
         * <p>Creates and returns a copy of this object.</p>
        <p>See <code>QScxmlExecutableContent::InvokeInfo::<wbr/>InvokeInfo(QScxmlExecutableContent::InvokeInfo)</code></p>
         */
        @QtUninvokable
        @Override
        public InvokeInfo clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native InvokeInfo clone_native(long __this_nativeId);
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #autoforward()} instead.</p>
         */
        @QtUninvokable
        public final boolean getAutoforward() {
            return autoforward();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #context()} instead.</p>
         */
        @QtUninvokable
        public final int getContext() {
            return context();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #expr()} instead.</p>
         */
        @QtUninvokable
        public final int getExpr() {
            return expr();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #finalizeId()} instead.</p>
         */
        @QtUninvokable
        public final int getFinalizeId() {
            return finalizeId();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #id()} instead.</p>
         */
        @QtUninvokable
        public final int getId() {
            return id();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #location()} instead.</p>
         */
        @QtUninvokable
        public final int getLocation() {
            return location();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #prefix()} instead.</p>
         */
        @QtUninvokable
        public final int getPrefix() {
            return prefix();
        }
    }
    
    public final static int NoContainer = -1;
    public final static int NoString = -1;
    public final static int NoInstruction = -1;
    public final static int NoEvaluator = -1;
}
