package io.qt.scxml;

import io.qt.*;


/**
 * <p>Used by compiled state machines</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qscxmltabledata.html">QScxmlTableData</a></code></p>
 */
public interface QScxmlTableData extends QtObjectInterface
{
    /**
     * @hidden
     * <p>Implementor class for interface {@link io.qt.scxml.QScxmlTableData}</p>
     */
    public static abstract class Impl extends QtObject
        implements io.qt.scxml.QScxmlTableData
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @NativeAccess
        private static final class ConcreteWrapper extends QScxmlTableData.Impl {
            
            @NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @QtUninvokable
            public io.qt.scxml.QScxmlExecutableContent.@NonNull AssignmentInfo assignmentInfo(int assignmentId){
                return assignmentInfo_native_qint32_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), assignmentId);
            }
            private native static io.qt.scxml.QScxmlExecutableContent.AssignmentInfo assignmentInfo_native_qint32_constfct(long __this__nativeId, int assignmentId);
            
            
            @Override
            @QtUninvokable
            public java.nio.@StrictNonNull IntBuffer dataNames(){
                return dataNames_native_int_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.nio.IntBuffer dataNames_native_int_ptr_constfct(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public io.qt.scxml.QScxmlExecutableContent.@NonNull EvaluatorInfo evaluatorInfo(int evaluatorId){
                return evaluatorInfo_native_qint32_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), evaluatorId);
            }
            private native static io.qt.scxml.QScxmlExecutableContent.EvaluatorInfo evaluatorInfo_native_qint32_constfct(long __this__nativeId, int evaluatorId);
            
            
            @Override
            @QtUninvokable
            public io.qt.scxml.QScxmlExecutableContent.@NonNull ForeachInfo foreachInfo(int foreachId){
                return foreachInfo_native_qint32_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), foreachId);
            }
            private native static io.qt.scxml.QScxmlExecutableContent.ForeachInfo foreachInfo_native_qint32_constfct(long __this__nativeId, int foreachId);
            
            
            @Override
            @QtUninvokable
            public int initialSetup(){
                return initialSetup_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static int initialSetup_native_constfct(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public java.nio.@StrictNonNull IntBuffer instructions(){
                return instructions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.nio.IntBuffer instructions_native_constfct(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public java.lang.@NonNull String name(){
                return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.lang.String name_native_constfct(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public io.qt.scxml.@Nullable QScxmlInvokableServiceFactory serviceFactory(int id){
                return serviceFactory_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id);
            }
            private native static io.qt.scxml.QScxmlInvokableServiceFactory serviceFactory_native_int_constfct(long __this__nativeId, int id);
            
            
            @Override
            @QtUninvokable
            public java.nio.@StrictNonNull IntBuffer stateMachineTable(){
                return stateMachineTable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.nio.IntBuffer stateMachineTable_native_constfct(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public java.lang.@NonNull String string(int id){
                return string_native_qint32_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id);
            }
            private native static java.lang.String string_native_qint32_constfct(long __this__nativeId, int id);
            
        }
        
        
        /**
         * <p>See <code>QScxmlTableData::<wbr>QScxmlTableData()</code></p>
         */
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QScxmlTableData instance);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#assignmentInfo">QScxmlTableData::<wbr>assignmentInfo(qint32)const</a></code></p>
         */
        @QtUninvokable
        public abstract io.qt.scxml.QScxmlExecutableContent.@NonNull AssignmentInfo assignmentInfo(int assignmentId);
        
        private native static io.qt.scxml.QScxmlExecutableContent.AssignmentInfo assignmentInfo_native_qint32_constfct(long __this__nativeId, int assignmentId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#dataNames">QScxmlTableData::<wbr>dataNames(int*)const</a></code></p>
         */
        @QtUninvokable
        public abstract java.nio.@StrictNonNull IntBuffer dataNames();
        
        private native static java.nio.IntBuffer dataNames_native_int_ptr_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#evaluatorInfo">QScxmlTableData::<wbr>evaluatorInfo(qint32)const</a></code></p>
         */
        @QtUninvokable
        public abstract io.qt.scxml.QScxmlExecutableContent.@NonNull EvaluatorInfo evaluatorInfo(int evaluatorId);
        
        private native static io.qt.scxml.QScxmlExecutableContent.EvaluatorInfo evaluatorInfo_native_qint32_constfct(long __this__nativeId, int evaluatorId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#foreachInfo">QScxmlTableData::<wbr>foreachInfo(qint32)const</a></code></p>
         */
        @QtUninvokable
        public abstract io.qt.scxml.QScxmlExecutableContent.@NonNull ForeachInfo foreachInfo(int foreachId);
        
        private native static io.qt.scxml.QScxmlExecutableContent.ForeachInfo foreachInfo_native_qint32_constfct(long __this__nativeId, int foreachId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#initialSetup">QScxmlTableData::<wbr>initialSetup()const</a></code></p>
         */
        @QtUninvokable
        public abstract int initialSetup();
        
        private native static int initialSetup_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#instructions">QScxmlTableData::<wbr>instructions()const</a></code></p>
         */
        @QtUninvokable
        public abstract java.nio.@StrictNonNull IntBuffer instructions();
        
        private native static java.nio.IntBuffer instructions_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#name">QScxmlTableData::<wbr>name()const</a></code></p>
         */
        @QtUninvokable
        public abstract java.lang.@NonNull String name();
        
        private native static java.lang.String name_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#serviceFactory">QScxmlTableData::<wbr>serviceFactory(int)const</a></code></p>
         */
        @QtUninvokable
        public abstract io.qt.scxml.@Nullable QScxmlInvokableServiceFactory serviceFactory(int id);
        
        private native static io.qt.scxml.QScxmlInvokableServiceFactory serviceFactory_native_int_constfct(long __this__nativeId, int id);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#stateMachineTable">QScxmlTableData::<wbr>stateMachineTable()const</a></code></p>
         */
        @QtUninvokable
        public abstract java.nio.@StrictNonNull IntBuffer stateMachineTable();
        
        private native static java.nio.IntBuffer stateMachineTable_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#string">QScxmlTableData::<wbr>string(qint32)const</a></code></p>
         */
        @QtUninvokable
        public abstract java.lang.@NonNull String string(int id);
        
        private native static java.lang.String string_native_qint32_constfct(long __this__nativeId, int id);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#assignmentInfo">QScxmlTableData::<wbr>assignmentInfo(QScxmlExecutableContent::EvaluatorId)const</a></code></p>
     */
    @QtUninvokable
    public io.qt.scxml.QScxmlExecutableContent.@NonNull AssignmentInfo assignmentInfo(int assignmentId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#dataNames">QScxmlTableData::<wbr>dataNames(int*)const</a></code></p>
     */
    @QtUninvokable
    public java.nio.@StrictNonNull IntBuffer dataNames();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#evaluatorInfo">QScxmlTableData::<wbr>evaluatorInfo(QScxmlExecutableContent::EvaluatorId)const</a></code></p>
     */
    @QtUninvokable
    public io.qt.scxml.QScxmlExecutableContent.@NonNull EvaluatorInfo evaluatorInfo(int evaluatorId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#foreachInfo">QScxmlTableData::<wbr>foreachInfo(QScxmlExecutableContent::EvaluatorId)const</a></code></p>
     */
    @QtUninvokable
    public io.qt.scxml.QScxmlExecutableContent.@NonNull ForeachInfo foreachInfo(int foreachId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#initialSetup">QScxmlTableData::<wbr>initialSetup()const</a></code></p>
     */
    @QtUninvokable
    public int initialSetup();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#instructions">QScxmlTableData::<wbr>instructions()const</a></code></p>
     */
    @QtUninvokable
    public java.nio.@StrictNonNull IntBuffer instructions();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#name">QScxmlTableData::<wbr>name()const</a></code></p>
     */
    @QtUninvokable
    public java.lang.@NonNull String name();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#serviceFactory">QScxmlTableData::<wbr>serviceFactory(int)const</a></code></p>
     */
    @QtUninvokable
    public io.qt.scxml.@Nullable QScxmlInvokableServiceFactory serviceFactory(int id);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#stateMachineTable">QScxmlTableData::<wbr>stateMachineTable()const</a></code></p>
     */
    @QtUninvokable
    public java.nio.@StrictNonNull IntBuffer stateMachineTable();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmltabledata.html#string">QScxmlTableData::<wbr>string(QScxmlExecutableContent::StringId)const</a></code></p>
     */
    @QtUninvokable
    public java.lang.@NonNull String string(int id);
    
}
