package io.qt.scxml;

import io.qt.*;


/**
 * <p>The null data model for a Qt SCXML stateMachine</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qscxmlnulldatamodel.html">QScxmlNullDataModel</a></code></p>
 */
public class QScxmlNullDataModel extends io.qt.scxml.QScxmlDataModel
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScxmlNullDataModel.class);
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmlnulldatamodel.html#QScxmlNullDataModel">QScxmlNullDataModel::<wbr>QScxmlNullDataModel(QObject*)</a></code></p>
     */
    public QScxmlNullDataModel(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QScxmlNullDataModel instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateAssignment">QScxmlDataModel::<wbr>evaluateAssignment(QScxmlExecutableContent::EvaluatorId,<wbr>bool*)</a></code></p>
     */
    public final void evaluateAssignment(int id, boolean @Nullable[] ok){
        evaluateAssignment_native_qint32_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
    }
    
    private native void evaluateAssignment_native_qint32_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateForeach">QScxmlDataModel::<wbr>evaluateForeach(QScxmlExecutableContent::EvaluatorId,<wbr>bool*,<wbr>QScxmlDataModel::ForeachLoopBody*)</a></code></p>
     */
    public final void evaluateForeach(int id, boolean @Nullable[] ok, io.qt.scxml.QScxmlDataModel.@Nullable ForeachLoopBody body){
        evaluateForeach_native_qint32_bool_ptr_QScxmlDataModel_ForeachLoopBody_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok, QtJambi_LibraryUtilities.internal.checkedNativeId(body));
    }
    
    private native void evaluateForeach_native_qint32_bool_ptr_QScxmlDataModel_ForeachLoopBody_ptr(long __this__nativeId, int id, boolean[] ok, long body);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateInitialization">QScxmlDataModel::<wbr>evaluateInitialization(QScxmlExecutableContent::EvaluatorId,<wbr>bool*)</a></code></p>
     */
    public final void evaluateInitialization(int id, boolean @Nullable[] ok){
        evaluateInitialization_native_qint32_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
    }
    
    private native void evaluateInitialization_native_qint32_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateToBool">QScxmlDataModel::<wbr>evaluateToBool(QScxmlExecutableContent::EvaluatorId,<wbr>bool*)</a></code></p>
     */
    public final boolean evaluateToBool(int id, boolean @Nullable[] ok){
        return evaluateToBool_native_qint32_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
    }
    
    private native boolean evaluateToBool_native_qint32_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateToString">QScxmlDataModel::<wbr>evaluateToString(QScxmlExecutableContent::EvaluatorId,<wbr>bool*)</a></code></p>
     */
    public final java.lang.@NonNull String evaluateToString(int id, boolean @Nullable[] ok){
        return evaluateToString_native_qint32_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
    }
    
    private native java.lang.String evaluateToString_native_qint32_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateToVariant">QScxmlDataModel::<wbr>evaluateToVariant(QScxmlExecutableContent::EvaluatorId,<wbr>bool*)</a></code></p>
     */
    public final java.lang.Object evaluateToVariant(int id, boolean @Nullable[] ok){
        return evaluateToVariant_native_qint32_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
    }
    
    private native java.lang.Object evaluateToVariant_native_qint32_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateToVoid">QScxmlDataModel::<wbr>evaluateToVoid(QScxmlExecutableContent::EvaluatorId,<wbr>bool*)</a></code></p>
     */
    public final void evaluateToVoid(int id, boolean @Nullable[] ok){
        evaluateToVoid_native_qint32_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
    }
    
    private native void evaluateToVoid_native_qint32_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmldatamodel.html#hasScxmlProperty">QScxmlDataModel::<wbr>hasScxmlProperty(QString)const</a></code></p>
     */
    @QtUninvokable
    @Override
    public boolean hasScxmlProperty(java.lang.@NonNull String name){
        return hasScxmlProperty_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native boolean hasScxmlProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmldatamodel.html#scxmlProperty">QScxmlDataModel::<wbr>scxmlProperty(QString)const</a></code></p>
     */
    @QtUninvokable
    @Override
    public java.lang.Object scxmlProperty(java.lang.@NonNull String name){
        return scxmlProperty_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native java.lang.Object scxmlProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmldatamodel.html#setScxmlEvent">QScxmlDataModel::<wbr>setScxmlEvent(QScxmlEvent)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void setScxmlEvent(io.qt.scxml.@NonNull QScxmlEvent event){
        setScxmlEvent_native_cref_QScxmlEvent(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void setScxmlEvent_native_cref_QScxmlEvent(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmldatamodel.html#setScxmlProperty">QScxmlDataModel::<wbr>setScxmlProperty(QString,<wbr>QVariant,<wbr>QString)</a></code></p>
     */
    @QtUninvokable
    @Override
    public boolean setScxmlProperty(java.lang.@NonNull String name, java.lang.Object value, java.lang.@NonNull String context){
        return setScxmlProperty_native_cref_QString_cref_QVariant_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name, value, context);
    }
    
    @QtUninvokable
    private native boolean setScxmlProperty_native_cref_QString_cref_QVariant_cref_QString(long __this__nativeId, java.lang.String name, java.lang.Object value, java.lang.String context);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscxmldatamodel.html#setup">QScxmlDataModel::<wbr>setup(QVariantMap)</a></code></p>
     */
    @Override
    public boolean setup(java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> initialDataValues){
        return setup_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), initialDataValues);
    }
    
    private native boolean setup_native_cref_QMap(long __this__nativeId, java.util.Map<java.lang.String, ? extends java.lang.Object> initialDataValues);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScxmlNullDataModel(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QScxmlNullDataModel(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QScxmlNullDataModel instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QScxmlNullDataModel(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QScxmlNullDataModel() {
        this((io.qt.core.QObject)null);
    }
}
