package io.qt.scxml;

import io.qt.*;


/**
 * <p>Used by compiled state machines</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qscxmltabledata.html">QScxmlTableData</a></p>
 */
public interface QScxmlTableData extends QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.scxml.QScxmlTableData}</p>
     */
    public static abstract class Impl extends QtObject
        implements io.qt.scxml.QScxmlTableData
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @NativeAccess
        private static final class ConcreteWrapper extends QScxmlTableData.Impl {
            
            @NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @QtUninvokable
            public io.qt.scxml.QScxmlExecutableContent.@NonNull AssignmentInfo assignmentInfo(int assignmentId){
                return assignmentInfo_native_qint32_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), assignmentId);
            }
            private native static io.qt.scxml.QScxmlExecutableContent.AssignmentInfo assignmentInfo_native_qint32_constfct(long __this__nativeId, int assignmentId);
            
            
            @Override
            @QtUninvokable
            public java.nio.@StrictNonNull IntBuffer dataNames(){
                return dataNames_native_int_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.nio.IntBuffer dataNames_native_int_ptr_constfct(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public io.qt.scxml.QScxmlExecutableContent.@NonNull EvaluatorInfo evaluatorInfo(int evaluatorId){
                return evaluatorInfo_native_qint32_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), evaluatorId);
            }
            private native static io.qt.scxml.QScxmlExecutableContent.EvaluatorInfo evaluatorInfo_native_qint32_constfct(long __this__nativeId, int evaluatorId);
            
            
            @Override
            @QtUninvokable
            public io.qt.scxml.QScxmlExecutableContent.@NonNull ForeachInfo foreachInfo(int foreachId){
                return foreachInfo_native_qint32_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), foreachId);
            }
            private native static io.qt.scxml.QScxmlExecutableContent.ForeachInfo foreachInfo_native_qint32_constfct(long __this__nativeId, int foreachId);
            
            
            @Override
            @QtUninvokable
            public int initialSetup(){
                return initialSetup_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static int initialSetup_native_constfct(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public java.nio.@StrictNonNull IntBuffer instructions(){
                return instructions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.nio.IntBuffer instructions_native_constfct(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public java.lang.@NonNull String name(){
                return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.lang.String name_native_constfct(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public io.qt.scxml.@Nullable QScxmlInvokableServiceFactory serviceFactory(int id){
                return serviceFactory_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id);
            }
            private native static io.qt.scxml.QScxmlInvokableServiceFactory serviceFactory_native_int_constfct(long __this__nativeId, int id);
            
            
            @Override
            @QtUninvokable
            public java.nio.@StrictNonNull IntBuffer stateMachineTable(){
                return stateMachineTable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.nio.IntBuffer stateMachineTable_native_constfct(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public java.lang.@NonNull String string(int id){
                return string_native_qint32_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id);
            }
            private native static java.lang.String string_native_qint32_constfct(long __this__nativeId, int id);
            
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QScxmlTableData instance);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#assignmentInfo">QScxmlTableData::assignmentInfo(qint32)const</a></p>
         */
        @QtUninvokable
        public abstract io.qt.scxml.QScxmlExecutableContent.@NonNull AssignmentInfo assignmentInfo(int assignmentId);
        
        private native static io.qt.scxml.QScxmlExecutableContent.AssignmentInfo assignmentInfo_native_qint32_constfct(long __this__nativeId, int assignmentId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#dataNames">QScxmlTableData::dataNames(int*)const</a></p>
         */
        @QtUninvokable
        public abstract java.nio.@StrictNonNull IntBuffer dataNames();
        
        private native static java.nio.IntBuffer dataNames_native_int_ptr_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#evaluatorInfo">QScxmlTableData::evaluatorInfo(qint32)const</a></p>
         */
        @QtUninvokable
        public abstract io.qt.scxml.QScxmlExecutableContent.@NonNull EvaluatorInfo evaluatorInfo(int evaluatorId);
        
        private native static io.qt.scxml.QScxmlExecutableContent.EvaluatorInfo evaluatorInfo_native_qint32_constfct(long __this__nativeId, int evaluatorId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#foreachInfo">QScxmlTableData::foreachInfo(qint32)const</a></p>
         */
        @QtUninvokable
        public abstract io.qt.scxml.QScxmlExecutableContent.@NonNull ForeachInfo foreachInfo(int foreachId);
        
        private native static io.qt.scxml.QScxmlExecutableContent.ForeachInfo foreachInfo_native_qint32_constfct(long __this__nativeId, int foreachId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#initialSetup">QScxmlTableData::initialSetup()const</a></p>
         */
        @QtUninvokable
        public abstract int initialSetup();
        
        private native static int initialSetup_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#instructions">QScxmlTableData::instructions()const</a></p>
         */
        @QtUninvokable
        public abstract java.nio.@StrictNonNull IntBuffer instructions();
        
        private native static java.nio.IntBuffer instructions_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#name">QScxmlTableData::name()const</a></p>
         */
        @QtUninvokable
        public abstract java.lang.@NonNull String name();
        
        private native static java.lang.String name_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#serviceFactory">QScxmlTableData::serviceFactory(int)const</a></p>
         */
        @QtUninvokable
        public abstract io.qt.scxml.@Nullable QScxmlInvokableServiceFactory serviceFactory(int id);
        
        private native static io.qt.scxml.QScxmlInvokableServiceFactory serviceFactory_native_int_constfct(long __this__nativeId, int id);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#stateMachineTable">QScxmlTableData::stateMachineTable()const</a></p>
         */
        @QtUninvokable
        public abstract java.nio.@StrictNonNull IntBuffer stateMachineTable();
        
        private native static java.nio.IntBuffer stateMachineTable_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#string">QScxmlTableData::string(qint32)const</a></p>
         */
        @QtUninvokable
        public abstract java.lang.@NonNull String string(int id);
        
        private native static java.lang.String string_native_qint32_constfct(long __this__nativeId, int id);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#assignmentInfo">QScxmlTableData::assignmentInfo(QScxmlExecutableContent::EvaluatorId)const</a></p>
     */
    @QtUninvokable
    public io.qt.scxml.QScxmlExecutableContent.@NonNull AssignmentInfo assignmentInfo(int assignmentId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#dataNames">QScxmlTableData::dataNames(int*)const</a></p>
     */
    @QtUninvokable
    public java.nio.@StrictNonNull IntBuffer dataNames();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#evaluatorInfo">QScxmlTableData::evaluatorInfo(QScxmlExecutableContent::EvaluatorId)const</a></p>
     */
    @QtUninvokable
    public io.qt.scxml.QScxmlExecutableContent.@NonNull EvaluatorInfo evaluatorInfo(int evaluatorId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#foreachInfo">QScxmlTableData::foreachInfo(QScxmlExecutableContent::EvaluatorId)const</a></p>
     */
    @QtUninvokable
    public io.qt.scxml.QScxmlExecutableContent.@NonNull ForeachInfo foreachInfo(int foreachId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#initialSetup">QScxmlTableData::initialSetup()const</a></p>
     */
    @QtUninvokable
    public int initialSetup();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#instructions">QScxmlTableData::instructions()const</a></p>
     */
    @QtUninvokable
    public java.nio.@StrictNonNull IntBuffer instructions();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#name">QScxmlTableData::name()const</a></p>
     */
    @QtUninvokable
    public java.lang.@NonNull String name();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#serviceFactory">QScxmlTableData::serviceFactory(int)const</a></p>
     */
    @QtUninvokable
    public io.qt.scxml.@Nullable QScxmlInvokableServiceFactory serviceFactory(int id);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#stateMachineTable">QScxmlTableData::stateMachineTable()const</a></p>
     */
    @QtUninvokable
    public java.nio.@StrictNonNull IntBuffer stateMachineTable();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmltabledata.html#string">QScxmlTableData::string(QScxmlExecutableContent::StringId)const</a></p>
     */
    @QtUninvokable
    public java.lang.@NonNull String string(int id);
    
}
