package io.qt.scxml;

import io.qt.*;


/**
 * <p>Describes the errors returned by the Qt SCXML state machine when parsing an SCXML file</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qscxmlerror.html">QScxmlError</a></p>
 */
public class QScxmlError extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScxmlError.class);
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlerror.html#QScxmlError">QScxmlError::QScxmlError()</a></p>
     */
    public QScxmlError(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QScxmlError instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlerror.html#QScxmlError-2">QScxmlError::QScxmlError(QScxmlError)</a></p>
     */
    public QScxmlError(io.qt.scxml.@NonNull QScxmlError arg__1){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1);
    }
    
    private native static void initialize_native(QScxmlError instance, io.qt.scxml.QScxmlError arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlerror.html#QScxmlError-1">QScxmlError::QScxmlError(QString,int,int,QString)</a></p>
     */
    public QScxmlError(java.lang.@NonNull String fileName, int line, int column, java.lang.@NonNull String description){
        super((QPrivateConstructor)null);
        initialize_native(this, fileName, line, column, description);
    }
    
    private native static void initialize_native(QScxmlError instance, java.lang.String fileName, int line, int column, java.lang.String description);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #column()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getColumn() {
        return column();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlerror.html#column">QScxmlError::column()const</a></p>
     */
    @QtPropertyReader(name="column")
    @QtPropertyConstant
    @QtUninvokable
    public final int column(){
        return column_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int column_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #description()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getDescription() {
        return description();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlerror.html#description">QScxmlError::description()const</a></p>
     */
    @QtPropertyReader(name="description")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String description(){
        return description_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String description_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #fileName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getFileName() {
        return fileName();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlerror.html#fileName">QScxmlError::fileName()const</a></p>
     */
    @QtPropertyReader(name="fileName")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String fileName(){
        return fileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String fileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isValid()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getValid() {
        return isValid();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlerror.html#isValid">QScxmlError::isValid()const</a></p>
     */
    @QtPropertyReader(name="valid")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #line()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getLine() {
        return line();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlerror.html#line">QScxmlError::line()const</a></p>
     */
    @QtPropertyReader(name="line")
    @QtPropertyConstant
    @QtUninvokable
    public final int line(){
        return line_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int line_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlerror.html#operator-eq">QScxmlError::operator=(QScxmlError)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.scxml.@NonNull QScxmlError arg__1){
        assign_native_cref_QScxmlError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QScxmlError(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlerror.html#toString">QScxmlError::toString()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String toString(){
        return toString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String toString_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QScxmlError(QPrivateConstructor p) { super(p); } 
    
    
    @QtUninvokable
    @Override
    public QScxmlError clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QScxmlError clone_native(long __this_nativeId);
}
