package io.qt.scxml;


/**
 * <p>The data model base class for a Qt SCXML state machine</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qscxmldatamodel.html">QScxmlDataModel</a></p>
 */
public abstract class QScxmlDataModel extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcStateMachine = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScxmlDataModel.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QScxmlDataModel {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public void evaluateAssignment(int id, boolean[] ok){
            evaluateAssignment_native_int_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
        }
        @io.qt.QtUninvokable
        private native void evaluateAssignment_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
        
        
        @Override
        @io.qt.QtUninvokable
        public void evaluateForeach(int id, boolean[] ok, io.qt.scxml.QScxmlDataModel.ForeachLoopBody body){
            evaluateForeach_native_int_bool_ptr_QScxmlDataModel_ForeachLoopBody_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok, QtJambi_LibraryUtilities.internal.checkedNativeId(body));
        }
        @io.qt.QtUninvokable
        private native void evaluateForeach_native_int_bool_ptr_QScxmlDataModel_ForeachLoopBody_ptr(long __this__nativeId, int id, boolean[] ok, long body);
        
        
        @Override
        @io.qt.QtUninvokable
        public void evaluateInitialization(int id, boolean[] ok){
            evaluateInitialization_native_int_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
        }
        @io.qt.QtUninvokable
        private native void evaluateInitialization_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean evaluateToBool(int id, boolean[] ok){
            return evaluateToBool_native_int_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
        }
        @io.qt.QtUninvokable
        private native boolean evaluateToBool_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.String evaluateToString(int id, boolean[] ok){
            return evaluateToString_native_int_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
        }
        @io.qt.QtUninvokable
        private native java.lang.String evaluateToString_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.Object evaluateToVariant(int id, boolean[] ok){
            return evaluateToVariant_native_int_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
        }
        @io.qt.QtUninvokable
        private native java.lang.Object evaluateToVariant_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
        
        
        @Override
        @io.qt.QtUninvokable
        public void evaluateToVoid(int id, boolean[] ok){
            evaluateToVoid_native_int_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
        }
        @io.qt.QtUninvokable
        private native void evaluateToVoid_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean hasScxmlProperty(java.lang.String name){
            return hasScxmlProperty_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
        }
        @io.qt.QtUninvokable
        private native boolean hasScxmlProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.Object scxmlProperty(java.lang.String name){
            return scxmlProperty_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
        }
        @io.qt.QtUninvokable
        private native java.lang.Object scxmlProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setScxmlEvent(io.qt.scxml.QScxmlEvent event){
            setScxmlEvent_native_cref_QScxmlEvent(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
        }
        @io.qt.QtUninvokable
        private native void setScxmlEvent_native_cref_QScxmlEvent(long __this__nativeId, long event);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean setScxmlProperty(java.lang.String name, java.lang.Object value, java.lang.String context){
            return setScxmlProperty_native_cref_QString_cref_QVariant_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name, value, context);
        }
        @io.qt.QtUninvokable
        private native boolean setScxmlProperty_native_cref_QString_cref_QVariant_cref_QString(long __this__nativeId, java.lang.String name, java.lang.Object value, java.lang.String context);
        
        
        @Override
        public boolean setup(java.util.Map<java.lang.String, ? extends java.lang.Object> initialDataValues){
            return setup_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), initialDataValues);
        }
        private native boolean setup_native_cref_QMap(long __this__nativeId, java.util.Map<java.lang.String, ? extends java.lang.Object> initialDataValues);
        
    }
    
    /**
     * <p>Represents a function to be executed on each iteration of an SCXML foreach loop</p>
     * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qscxmldatamodel-foreachloopbody.html">QScxmlDataModel::ForeachLoopBody</a></p>
     */
    public interface ForeachLoopBody extends io.qt.QtObjectInterface
    {
        /**
         * <p>Implementor class for interface {@link io.qt.scxml.QScxmlDataModel.ForeachLoopBody}</p>
         */
        public static abstract class Impl extends io.qt.QtObject
            implements io.qt.scxml.QScxmlDataModel.ForeachLoopBody
        {
            static {
                QtJambi_LibraryUtilities.initialize();
            }
            
            @io.qt.NativeAccess
            private static final class ConcreteWrapper extends QScxmlDataModel.ForeachLoopBody.Impl {
                
                @io.qt.NativeAccess
                private ConcreteWrapper(QPrivateConstructor p) { super(p); }
                
                @Override
                @io.qt.QtUninvokable
                public boolean run(){
                    return run_native_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this));
                }
                private native static boolean run_native_bool_ptr(long __this__nativeId);
                
            }
            
            
            /**
             * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel-foreachloopbody.html#ForeachLoopBody-1">QScxmlDataModel::ForeachLoopBody::ForeachLoopBody()</a></p>
             */
            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }
            
            private native static void initialize_native(ForeachLoopBody instance);
            
            /**
             * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel-foreachloopbody.html#run">QScxmlDataModel::ForeachLoopBody::run(bool*)</a></p>
             */
            @io.qt.QtUninvokable
            public abstract boolean run();
            
            private native static boolean run_native_bool_ptr(long __this__nativeId);
            
            /**
             * Constructor for internal use only.
             * @param p expected to be <code>null</code>.
             */
            @io.qt.NativeAccess
            protected Impl(QPrivateConstructor p) { super(p); } 
            
        }

        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel-foreachloopbody.html#run">QScxmlDataModel::ForeachLoopBody::run(bool*)</a></p>
         */
        @io.qt.QtUninvokable
        public boolean run();
        
    }


    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#stateMachine-prop">QScxmlDataModel::stateMachineChanged(QScxmlStateMachine*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="stateMachine")
    public final Signal1<io.qt.scxml.QScxmlStateMachine> stateMachineChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QScxmlDataModel(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QScxmlDataModel() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#QScxmlDataModel">QScxmlDataModel::QScxmlDataModel(QObject*)</a></p>
     */
    public QScxmlDataModel(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QScxmlDataModel instance, io.qt.core.QObject parent);
    
    /**
     * <p>State machine this data model belongs to</p>
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#stateMachine-prop">QScxmlDataModel::bindableStateMachine()</a></p>
     */
    @io.qt.QtPropertyBindable(name="stateMachine")
    @io.qt.QtUninvokable
    public final io.qt.core.QBindable<io.qt.scxml.QScxmlStateMachine> bindableStateMachine(){
        return bindableStateMachine_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QBindable<io.qt.scxml.QScxmlStateMachine> bindableStateMachine_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#setStateMachine">QScxmlDataModel::setStateMachine(QScxmlStateMachine*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="stateMachine")
    @io.qt.QtUninvokable
    public final void setStateMachine(io.qt.scxml.QScxmlStateMachine stateMachine){
        setStateMachine_native_QScxmlStateMachine_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(stateMachine));
        __rcStateMachine = stateMachine;
    }
    
    @io.qt.QtUninvokable
    private native void setStateMachine_native_QScxmlStateMachine_ptr(long __this__nativeId, long stateMachine);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#stateMachine">QScxmlDataModel::stateMachine()const</a></p>
     */
    @io.qt.QtPropertyReader(name="stateMachine")
    @io.qt.QtUninvokable
    public final io.qt.scxml.QScxmlStateMachine stateMachine(){
        return stateMachine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.scxml.QScxmlStateMachine stateMachine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateAssignment">QScxmlDataModel::evaluateAssignment(QScxmlExecutableContent::EvaluatorId,bool*)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void evaluateAssignment(int id, boolean[] ok);
    
    @io.qt.QtUninvokable
    private native void evaluateAssignment_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateForeach">QScxmlDataModel::evaluateForeach(QScxmlExecutableContent::EvaluatorId,bool*,QScxmlDataModel::ForeachLoopBody*)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void evaluateForeach(int id, boolean[] ok, io.qt.scxml.QScxmlDataModel.ForeachLoopBody body);
    
    @io.qt.QtUninvokable
    private native void evaluateForeach_native_int_bool_ptr_QScxmlDataModel_ForeachLoopBody_ptr(long __this__nativeId, int id, boolean[] ok, long body);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateInitialization">QScxmlDataModel::evaluateInitialization(QScxmlExecutableContent::EvaluatorId,bool*)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void evaluateInitialization(int id, boolean[] ok);
    
    @io.qt.QtUninvokable
    private native void evaluateInitialization_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateToBool">QScxmlDataModel::evaluateToBool(QScxmlExecutableContent::EvaluatorId,bool*)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean evaluateToBool(int id, boolean[] ok);
    
    @io.qt.QtUninvokable
    private native boolean evaluateToBool_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateToString">QScxmlDataModel::evaluateToString(QScxmlExecutableContent::EvaluatorId,bool*)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.String evaluateToString(int id, boolean[] ok);
    
    @io.qt.QtUninvokable
    private native java.lang.String evaluateToString_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateToVariant">QScxmlDataModel::evaluateToVariant(QScxmlExecutableContent::EvaluatorId,bool*)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.Object evaluateToVariant(int id, boolean[] ok);
    
    @io.qt.QtUninvokable
    private native java.lang.Object evaluateToVariant_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateToVoid">QScxmlDataModel::evaluateToVoid(QScxmlExecutableContent::EvaluatorId,bool*)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void evaluateToVoid(int id, boolean[] ok);
    
    @io.qt.QtUninvokable
    private native void evaluateToVoid_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#hasScxmlProperty">QScxmlDataModel::hasScxmlProperty(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean hasScxmlProperty(java.lang.String name);
    
    @io.qt.QtUninvokable
    private native boolean hasScxmlProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#scxmlProperty">QScxmlDataModel::scxmlProperty(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.Object scxmlProperty(java.lang.String name);
    
    @io.qt.QtUninvokable
    private native java.lang.Object scxmlProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#setScxmlEvent">QScxmlDataModel::setScxmlEvent(QScxmlEvent)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setScxmlEvent(io.qt.scxml.QScxmlEvent event);
    
    @io.qt.QtUninvokable
    private native void setScxmlEvent_native_cref_QScxmlEvent(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#setScxmlProperty">QScxmlDataModel::setScxmlProperty(QString,QVariant,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean setScxmlProperty(java.lang.String name, java.lang.Object value, java.lang.String context);
    
    @io.qt.QtUninvokable
    private native boolean setScxmlProperty_native_cref_QString_cref_QVariant_cref_QString(long __this__nativeId, java.lang.String name, java.lang.Object value, java.lang.String context);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#setup">QScxmlDataModel::setup(QVariantMap)</a></p>
     */
    public abstract boolean setup(java.util.Map<java.lang.String, ? extends java.lang.Object> initialDataValues);
    
    private native boolean setup_native_cref_QMap(long __this__nativeId, java.util.Map<java.lang.String, ? extends java.lang.Object> initialDataValues);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#createScxmlDataModel">QScxmlDataModel::createScxmlDataModel(QString)</a></p>
     */
    public native static io.qt.scxml.QScxmlDataModel createScxmlDataModel(java.lang.String pluginKey);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QScxmlDataModel(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QScxmlDataModel(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QScxmlDataModel instance, QDeclarativeConstructor constructor);
    
}
