package io.qt.scxml;


/**
 * <p>Interface to the state machines created from SCXML files</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qscxmlstatemachine.html">QScxmlStateMachine</a></p>
 */
public class QScxmlStateMachine extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcLoader = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcDataModel = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcTableData = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScxmlStateMachine.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#dataModel-prop">QScxmlStateMachine::dataModelChanged(QScxmlDataModel*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="dataModel")
    public final Signal1<io.qt.scxml.QScxmlDataModel> dataModelChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#finished">QScxmlStateMachine::finished()</a></p>
     */
    public final Signal0 finished = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#initialValues-prop">QScxmlStateMachine::initialValuesChanged(QVariantMap)</a></p>
     */
    @io.qt.QtPropertyNotify(name="initialValues")
    public final Signal1<java.util.NavigableMap<java.lang.String, java.lang.Object>> initialValuesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#initialized-prop">QScxmlStateMachine::initializedChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="initialized")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> initializedChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#invokedServices-prop">QScxmlStateMachine::invokedServicesChanged(QList&lt;QScxmlInvokableService*&gt;)</a></p>
     */
    @io.qt.QtPropertyNotify(name="invokedServices")
    public final Signal1<java.util.List<io.qt.scxml.QScxmlInvokableService>> invokedServicesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#loader-prop">QScxmlStateMachine::loaderChanged(QScxmlCompiler::Loader*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="loader")
    public final Signal1<io.qt.scxml.QScxmlCompiler.Loader> loaderChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#log">QScxmlStateMachine::log(QString,QString)</a></p>
     */
    public final Signal2<java.lang.String, java.lang.String> log = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#reachedStableState">QScxmlStateMachine::reachedStableState()</a></p>
     */
    public final Signal0 reachedStableState = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#runningChanged">QScxmlStateMachine::runningChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="running")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> runningChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#tableData-prop">QScxmlStateMachine::tableDataChanged(QScxmlTableData*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="tableData")
    public final Signal1<io.qt.scxml.QScxmlTableData> tableDataChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QScxmlStateMachine(io.qt.core.QMetaObject, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    protected QScxmlStateMachine(io.qt.core.QMetaObject metaObject) {
        this(metaObject, (io.qt.core.QObject)null);
    }
    
    protected QScxmlStateMachine(io.qt.core.QMetaObject metaObject, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, metaObject, parent);
    }
    
    private native static void initialize_native(QScxmlStateMachine instance, io.qt.core.QMetaObject metaObject, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded function for {@link #activeStateNames(boolean)}
     *  with <code>compress = true</code>.</p>
     */
    public final io.qt.core.QStringList activeStateNames() {
        return activeStateNames((boolean)true);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#activeStateNames">QScxmlStateMachine::activeStateNames(bool)const</a></p>
     */
    public final io.qt.core.QStringList activeStateNames(boolean compress){
        return activeStateNames_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), compress);
    }
    
    private native io.qt.core.QStringList activeStateNames_native_bool_constfct(long __this__nativeId, boolean compress);
    
    /**
     * <p>Data model to be used for this state machine</p>
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#dataModel-prop">QScxmlStateMachine::bindableDataModel()</a></p>
     */
    @io.qt.QtPropertyBindable(name="dataModel")
    @io.qt.QtUninvokable
    public final io.qt.core.QBindable<io.qt.scxml.QScxmlDataModel> bindableDataModel(){
        return bindableDataModel_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QBindable<io.qt.scxml.QScxmlDataModel> bindableDataModel_native(long __this__nativeId);
    
    /**
     * <p>Initial values to be used for setting up the data model</p>
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#initialValues-prop">QScxmlStateMachine::bindableInitialValues()</a></p>
     */
    @io.qt.QtPropertyBindable(name="initialValues")
    @io.qt.QtUninvokable
    public final io.qt.core.QBindable<java.util.NavigableMap<java.lang.String, java.lang.Object>> bindableInitialValues(){
        return bindableInitialValues_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QBindable<java.util.NavigableMap<java.lang.String, java.lang.Object>> bindableInitialValues_native(long __this__nativeId);
    
    /**
     * <p>Whether the state machine has been initialized</p>
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#initialized-prop">QScxmlStateMachine::bindableInitialized()const</a></p>
     */
    @io.qt.QtPropertyBindable(name="initialized")
    @io.qt.QtUninvokable
    public final io.qt.core.QBooleanBindable bindableInitialized(){
        return bindableInitialized_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QBooleanBindable bindableInitialized_native_constfct(long __this__nativeId);
    
    /**
     * <p>A list of SCXML services that were invoked from the main state machine (possibly recursively)</p>
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#invokedServices-prop">QScxmlStateMachine::bindableInvokedServices()</a></p>
     */
    @io.qt.QtPropertyBindable(name="invokedServices")
    @io.qt.QtUninvokable
    public final io.qt.core.QBindable<java.util.List<io.qt.scxml.QScxmlInvokableService>> bindableInvokedServices(){
        return bindableInvokedServices_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QBindable<java.util.List<io.qt.scxml.QScxmlInvokableService>> bindableInvokedServices_native(long __this__nativeId);
    
    /**
     * <p>That is currently used to resolve and load URIs for the state machine</p>
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#loader-prop">QScxmlStateMachine::bindableLoader()</a></p>
     */
    @io.qt.QtPropertyBindable(name="loader")
    @io.qt.QtUninvokable
    public final io.qt.core.QBindable<io.qt.scxml.QScxmlCompiler.Loader> bindableLoader(){
        return bindableLoader_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QBindable<io.qt.scxml.QScxmlCompiler.Loader> bindableLoader_native(long __this__nativeId);
    
    /**
     * <p>Table data that is used when generating C++ from an SCXML file</p>
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#tableData-prop">QScxmlStateMachine::bindableTableData()</a></p>
     */
    @io.qt.QtPropertyBindable(name="tableData")
    @io.qt.QtUninvokable
    public final io.qt.core.QBindable<io.qt.scxml.QScxmlTableData> bindableTableData(){
        return bindableTableData_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QBindable<io.qt.scxml.QScxmlTableData> bindableTableData_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#cancelDelayedEvent">QScxmlStateMachine::cancelDelayedEvent(QString)</a></p>
     */
    public final void cancelDelayedEvent(java.lang.String sendId){
        cancelDelayedEvent_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), sendId);
    }
    
    private native void cancelDelayedEvent_native_cref_QString(long __this__nativeId, java.lang.String sendId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToEvent-3">QScxmlStateMachine::connectToEvent(QString,const QObject*,const char*,Qt::ConnectionType)</a></p>
     */
    @io.qt.QtUninvokable
    private final io.qt.core.QMetaObject.Connection connectToEvent(java.lang.String scxmlEventSpec, io.qt.core.QObject receiver, java.lang.String method, int type){
        return connectToEvent_native_cref_QString_const_QObject_ptr_const_char_ptr_Qt_ConnectionType(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlEventSpec, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), method, type);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QMetaObject.Connection connectToEvent_native_cref_QString_const_QObject_ptr_const_char_ptr_Qt_ConnectionType(long __this__nativeId, java.lang.String scxmlEventSpec, long receiver, java.lang.String method, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToState">QScxmlStateMachine::connectToState(QString,const QObject*,const char*,Qt::ConnectionType)</a></p>
     */
    @io.qt.QtUninvokable
    private final io.qt.core.QMetaObject.Connection connectToState(java.lang.String scxmlStateName, io.qt.core.QObject receiver, java.lang.String method, int type){
        return connectToState_native_cref_QString_const_QObject_ptr_const_char_ptr_Qt_ConnectionType(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlStateName, QtJambi_LibraryUtilities.internal.checkedNativeId(receiver), method, type);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QMetaObject.Connection connectToState_native_cref_QString_const_QObject_ptr_const_char_ptr_Qt_ConnectionType(long __this__nativeId, java.lang.String scxmlStateName, long receiver, java.lang.String method, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#dataModel">QScxmlStateMachine::dataModel()const</a></p>
     */
    @io.qt.QtPropertyReader(name="dataModel")
    @io.qt.QtUninvokable
    public final io.qt.scxml.QScxmlDataModel dataModel(){
        return dataModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.scxml.QScxmlDataModel dataModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#init">QScxmlStateMachine::init()</a></p>
     */
    public final boolean init(){
        return init_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean init_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#initialValues-prop">QScxmlStateMachine::initialValues()</a></p>
     */
    @io.qt.QtPropertyReader(name="initialValues")
    @io.qt.QtUninvokable
    public final io.qt.core.QMap<java.lang.String, java.lang.Object> initialValues(){
        return initialValues_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QMap<java.lang.String, java.lang.Object> initialValues_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#invokedServices-prop">QScxmlStateMachine::invokedServices()const</a></p>
     */
    @io.qt.QtPropertyReader(name="invokedServices")
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.scxml.QScxmlInvokableService> invokedServices(){
        return invokedServices_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.scxml.QScxmlInvokableService> invokedServices_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#isActive">QScxmlStateMachine::isActive(QString)const</a></p>
     */
    public final boolean isActive(java.lang.String scxmlStateName){
        return isActive_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlStateName);
    }
    
    private native boolean isActive_native_cref_QString_constfct(long __this__nativeId, java.lang.String scxmlStateName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#isActive-1">QScxmlStateMachine::isActive(int)const</a></p>
     */
    @io.qt.QtUninvokable
    protected final boolean isActive(int stateIndex){
        return isActive_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), stateIndex);
    }
    
    @io.qt.QtUninvokable
    private native boolean isActive_native_int_constfct(long __this__nativeId, int stateIndex);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#isDispatchableTarget">QScxmlStateMachine::isDispatchableTarget(QString)const</a></p>
     */
    public final boolean isDispatchableTarget(java.lang.String target){
        return isDispatchableTarget_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    private native boolean isDispatchableTarget_native_cref_QString_constfct(long __this__nativeId, java.lang.String target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#initialized-prop">QScxmlStateMachine::isInitialized()const</a></p>
     */
    @io.qt.QtPropertyReader(name="initialized")
    @io.qt.QtUninvokable
    public final boolean isInitialized(){
        return isInitialized_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isInitialized_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#invoked-prop">QScxmlStateMachine::isInvoked()const</a></p>
     */
    @io.qt.QtPropertyReader(name="invoked")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final boolean isInvoked(){
        return isInvoked_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isInvoked_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#isRunning">QScxmlStateMachine::isRunning()const</a></p>
     */
    @io.qt.QtPropertyReader(name="running")
    @io.qt.QtUninvokable
    public final boolean isRunning(){
        return isRunning_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isRunning_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#loader-prop">QScxmlStateMachine::loader()const</a></p>
     */
    @io.qt.QtPropertyReader(name="loader")
    @io.qt.QtUninvokable
    public final io.qt.scxml.QScxmlCompiler.Loader loader(){
        return loader_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.scxml.QScxmlCompiler.Loader loader_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#name-prop">QScxmlStateMachine::name()const</a></p>
     */
    @io.qt.QtPropertyReader(name="name")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final java.lang.String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#parseErrors-prop">QScxmlStateMachine::parseErrors()const</a></p>
     */
    @io.qt.QtPropertyReader(name="parseErrors")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.scxml.QScxmlError> parseErrors(){
        return parseErrors_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.scxml.QScxmlError> parseErrors_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#sessionId-prop">QScxmlStateMachine::sessionId()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sessionId")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final java.lang.String sessionId(){
        return sessionId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String sessionId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#setDataModel">QScxmlStateMachine::setDataModel(QScxmlDataModel*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="dataModel")
    @io.qt.QtUninvokable
    public final void setDataModel(io.qt.scxml.QScxmlDataModel model){
        setDataModel_native_QScxmlDataModel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(model));
        __rcDataModel = model;
    }
    
    @io.qt.QtUninvokable
    private native void setDataModel_native_QScxmlDataModel_ptr(long __this__nativeId, long model);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#initialValues-prop">QScxmlStateMachine::setInitialValues(QVariantMap)</a></p>
     */
    @io.qt.QtPropertyWriter(name="initialValues")
    @io.qt.QtUninvokable
    public final void setInitialValues(java.util.Map<java.lang.String, ? extends java.lang.Object> initialValues){
        setInitialValues_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), initialValues);
    }
    
    @io.qt.QtUninvokable
    private native void setInitialValues_native_cref_QMap(long __this__nativeId, java.util.Map<java.lang.String, ? extends java.lang.Object> initialValues);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#loader-prop">QScxmlStateMachine::setLoader(QScxmlCompiler::Loader*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="loader")
    @io.qt.QtUninvokable
    public final void setLoader(io.qt.scxml.QScxmlCompiler.Loader loader){
        setLoader_native_QScxmlCompiler_Loader_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(loader));
        __rcLoader = loader;
    }
    
    @io.qt.QtUninvokable
    private native void setLoader_native_QScxmlCompiler_Loader_ptr(long __this__nativeId, long loader);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#setRunning">QScxmlStateMachine::setRunning(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="running")
    @io.qt.QtUninvokable
    public final void setRunning(boolean running){
        setRunning_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), running);
    }
    
    @io.qt.QtUninvokable
    private native void setRunning_native_bool(long __this__nativeId, boolean running);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#tableData-prop">QScxmlStateMachine::setTableData(QScxmlTableData*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="tableData")
    @io.qt.QtUninvokable
    public final void setTableData(io.qt.scxml.QScxmlTableData tableData){
        setTableData_native_QScxmlTableData_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(tableData));
        __rcTableData = tableData;
    }
    
    @io.qt.QtUninvokable
    private native void setTableData_native_QScxmlTableData_ptr(long __this__nativeId, long tableData);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#start">QScxmlStateMachine::start()</a></p>
     */
    public final void start(){
        start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void start_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #stateNames(boolean)}
     *  with <code>compress = true</code>.</p>
     */
    public final io.qt.core.QStringList stateNames() {
        return stateNames((boolean)true);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#stateNames">QScxmlStateMachine::stateNames(bool)const</a></p>
     */
    public final io.qt.core.QStringList stateNames(boolean compress){
        return stateNames_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), compress);
    }
    
    private native io.qt.core.QStringList stateNames_native_bool_constfct(long __this__nativeId, boolean compress);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#stop">QScxmlStateMachine::stop()</a></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#submitEvent">QScxmlStateMachine::submitEvent(QScxmlEvent*)</a></p>
     */
    public final void submitEvent(io.qt.scxml.QScxmlEvent event){
        submitEvent_native_QScxmlEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), event);
    }
    
    private native void submitEvent_native_QScxmlEvent_ptr(long __this__nativeId, io.qt.scxml.QScxmlEvent event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#submitEvent-1">QScxmlStateMachine::submitEvent(QString)</a></p>
     */
    public final void submitEvent(java.lang.String eventName){
        submitEvent_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), eventName);
    }
    
    private native void submitEvent_native_cref_QString(long __this__nativeId, java.lang.String eventName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#submitEvent-2">QScxmlStateMachine::submitEvent(QString,QVariant)</a></p>
     */
    public final void submitEvent(java.lang.String eventName, java.lang.Object data){
        submitEvent_native_cref_QString_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), eventName, data);
    }
    
    private native void submitEvent_native_cref_QString_cref_QVariant(long __this__nativeId, java.lang.String eventName, java.lang.Object data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#tableData-prop">QScxmlStateMachine::tableData()const</a></p>
     */
    @io.qt.QtPropertyReader(name="tableData")
    @io.qt.QtUninvokable
    public final io.qt.scxml.QScxmlTableData tableData(){
        return tableData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.scxml.QScxmlTableData tableData_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #fromData(io.qt.core.QIODevice, java.lang.String)}
     *  with <code>fileName = (String)null</code>.</p>
     */
    public static io.qt.scxml.QScxmlStateMachine fromData(io.qt.core.QIODevice data) {
        return fromData(data, (String)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#fromData">QScxmlStateMachine::fromData(QIODevice*,QString)</a></p>
     */
    public static io.qt.scxml.QScxmlStateMachine fromData(io.qt.core.QIODevice data, java.lang.String fileName){
        return fromData_native_QIODevice_ptr_cref_QString(QtJambi_LibraryUtilities.internal.checkedNativeId(data), fileName);
    }
    
    private native static io.qt.scxml.QScxmlStateMachine fromData_native_QIODevice_ptr_cref_QString(long data, java.lang.String fileName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#fromFile">QScxmlStateMachine::fromFile(QString)</a></p>
     */
    public native static io.qt.scxml.QScxmlStateMachine fromFile(java.lang.String fileName);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QScxmlStateMachine(QPrivateConstructor p) { super(p); } 
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#onEntry">QScxmlStateMachine::onEntry(QObject, const char*)</a></p>
     */
    public static io.qt.core.QMetaObject.Slot1<Boolean> onEntry(io.qt.core.QObject object, String slot){
        io.qt.core.QMetaMethod method = object.metaObject().method(slot);
        if(method==null || !method.isValid())
            throw new io.qt.QNoSuchSlotException(object, slot);
        return (isEnteringState) -> {
            if (isEnteringState && !object.isDisposed())
                method.invoke(object);
        };
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#onExit">QScxmlStateMachine::onExit(QObject, const char*)</a></p>
     */
    public static io.qt.core.QMetaObject.Slot1<Boolean> onExit(io.qt.core.QObject object, String slot){
        io.qt.core.QMetaMethod method = object.metaObject().method(slot);
        if(method==null || !method.isValid())
            throw new io.qt.QNoSuchSlotException(object, slot);
        return (isEnteringState) -> {
            if (!isEnteringState && !object.isDisposed())
                method.invoke(object);
        };
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#onEntry">QScxmlStateMachine::onEntry(Functor)</a></p>
     */
    public static io.qt.core.QMetaObject.Slot1<Boolean> onEntry(io.qt.core.QMetaObject.Slot0 slot){
        io.qt.core.QObject object = QtJambi_LibraryUtilities.internal.lambdaContext(slot);
        return (isEnteringState) -> {
            if (isEnteringState && (object==null || !object.isDisposed()))
                slot.invoke();
        };
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#onExit">QScxmlStateMachine::onExit(Functor)</a></p>
     */
    public static io.qt.core.QMetaObject.Slot1<Boolean> onExit(io.qt.core.QMetaObject.Slot0 slot){
        io.qt.core.QObject object = QtJambi_LibraryUtilities.internal.lambdaContext(slot);
        return (isEnteringState) -> {
            if (!isEnteringState && (object==null || !object.isDisposed()))
                slot.invoke();
        };
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#onEntry">QScxmlStateMachine::onEntry(Functor)</a></p>
     */
    public static io.qt.core.QMetaObject.Slot1<Boolean> onEntry(io.qt.core.QMetaObject.Emitable0 signal){
        return (isEnteringState) -> {
            if (isEnteringState && !(signal.containingObject() instanceof io.qt.core.QObject && ((io.qt.core.QObject)signal.containingObject()).isDisposed()))
                signal.emit();
        };
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#onExit">QScxmlStateMachine::onExit(Functor)</a></p>
     */
    public static io.qt.core.QMetaObject.Slot1<Boolean> onExit(io.qt.core.QMetaObject.Emitable0 signal){
        return (isEnteringState) -> {
            if (!isEnteringState && !(signal.containingObject() instanceof io.qt.core.QObject && ((io.qt.core.QObject)signal.containingObject()).isDisposed()))
                signal.emit();
        };
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToState">QScxmlStateMachine::connectToState(QString, Functor, Qt::ConnectionType)</a></p>
     */
    public io.qt.core.QMetaObject.Connection connectToState(String scxmlStateName,
            io.qt.core.QMetaObject.Slot0 slot, io.qt.core.Qt.ConnectionType... type){
        int _type = 0;
        for (io.qt.core.Qt.ConnectionType t : type) {
            _type |= t.value();
        }
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromMethod(java.util.Objects.requireNonNull(slot));
        if(metaMethod!=null && metaMethod.isValid() && metaMethod.parameterCount()==0) {
            io.qt.core.QObject object = QtJambi_LibraryUtilities.internal.lambdaContext(slot);
            if(object!=null) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToState(scxmlStateName, object, "2"+metaMethod.cppMethodSignature(), _type);
                case Method:
                case Slot:
                    return connectToState(scxmlStateName, object, "1"+metaMethod.cppMethodSignature(), _type);
                default:
                    break;
                }
            }
        }
        return connectToState(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlStateName, slot, _type);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToState">QScxmlStateMachine::connectToState(QString, Functor, Qt::ConnectionType)</a></p>
     */
    public io.qt.core.QMetaObject.Connection connectToState(String scxmlStateName,
            io.qt.core.QMetaObject.Connectable0 signal, io.qt.core.Qt.ConnectionType... type){
        int _type = 0;
        for (io.qt.core.Qt.ConnectionType t : type) {
            _type |= t.value();
        }
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromSignal(java.util.Objects.requireNonNull(signal));
        if(metaMethod!=null && metaMethod.isValid() && metaMethod.parameterCount()==0) {
            io.qt.core.QObject object = null;
            if(signal.containingObject() instanceof io.qt.core.QObject){
                object = (io.qt.core.QObject)signal.containingObject();
            }
            if(object!=null) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToState(scxmlStateName, object, "2"+metaMethod.cppMethodSignature(), _type);
                case Method:
                case Slot:
                    return connectToState(scxmlStateName, object, "1"+metaMethod.cppMethodSignature(), _type);
                default:
                    break;
                }
            }
        }
        if(signal instanceof io.qt.core.QMetaObject.Emitable0)
            return connectToState(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlStateName, (io.qt.core.QMetaObject.Slot0)((io.qt.core.QMetaObject.Emitable0)signal)::emit, _type);
        else return null;
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToState">QScxmlStateMachine::connectToState(QString, Functor, Qt::ConnectionType)</a></p>
     */
    public io.qt.core.QMetaObject.Connection connectToState(String scxmlStateName,
            io.qt.core.QMetaObject.Slot1<Boolean> slot, io.qt.core.Qt.ConnectionType... type){
        int _type = 0;
        for (io.qt.core.Qt.ConnectionType t : type) {
            _type |= t.value();
        }
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromMethod(java.util.Objects.requireNonNull(slot));
        if(metaMethod!=null && metaMethod.isValid()) {
            if(metaMethod.parameterCount()!=1 || metaMethod.parameterType(0)!=io.qt.core.QMetaType.Type.Bool.value()) {
                throw new IllegalArgumentException("Method does not take a single boolean argument: "+metaMethod.cppMethodSignature());
            }
            io.qt.core.QObject object = QtJambi_LibraryUtilities.internal.lambdaContext(slot);
            if(object!=null) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToEvent(scxmlStateName, object, "2"+metaMethod.cppMethodSignature(), _type);
                case Method:
                case Slot:
                    return connectToEvent(scxmlStateName, object, "1"+metaMethod.cppMethodSignature(), _type);
                default:
                    break;
                }
            }
        }
        return connectToState(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlStateName, slot, _type);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToState">QScxmlStateMachine::connectToState(QString, Functor, Qt::ConnectionType)</a></p>
     */
    @SuppressWarnings("unchecked")
    public io.qt.core.QMetaObject.Connection connectToState(String scxmlStateName,
            io.qt.core.QMetaObject.Connectable1<Boolean> signal, io.qt.core.Qt.ConnectionType... type){
        int _type = 0;
        for (io.qt.core.Qt.ConnectionType t : type) {
            _type |= t.value();
        }
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromSignal(java.util.Objects.requireNonNull(signal));
        if(metaMethod!=null && metaMethod.isValid()) {
            if(metaMethod.parameterCount()!=1 || metaMethod.parameterType(0)!=io.qt.core.QMetaType.Type.Bool.value()) {
                throw new IllegalArgumentException("Method does not take a single boolean argument: "+metaMethod.cppMethodSignature());
            }
            io.qt.core.QObject object = null;
            if(signal.containingObject() instanceof io.qt.core.QObject){
                object = (io.qt.core.QObject)signal.containingObject();
            }
            if(object!=null) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToEvent(scxmlStateName, object, "2"+metaMethod.cppMethodSignature(), _type);
                case Method:
                case Slot:
                    return connectToEvent(scxmlStateName, object, "1"+metaMethod.cppMethodSignature(), _type);
                default:
                    break;
                }
            }
        }
        if(signal instanceof io.qt.core.QMetaObject.Emitable1)
            return connectToState(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlStateName, (io.qt.core.QMetaObject.Slot1<Boolean>)((io.qt.core.QMetaObject.Emitable1<Boolean>)signal)::emit, _type);
        else return null;
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToState">QScxmlStateMachine::connectToState(QString, QObject, const char*, Qt::ConnectionType)</a></p>
     */
    public io.qt.core.QMetaObject.Connection connectToState(String scxmlStateName,
            io.qt.core.QObject object, String member, io.qt.core.Qt.ConnectionType... type){
        int _type = 0;
        for (io.qt.core.Qt.ConnectionType t : type) {
            _type |= t.value();
        }
        if(member!=null && !member.startsWith("1") && !member.startsWith("2")) {
            io.qt.core.QMetaMethod method = object.metaObject().method(member);
            if(method!=null && method.isValid()) {
                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    member = "2" + method.cppMethodSignature();
                else
                    member = "1" + method.cppMethodSignature();
            }else {
                member = "1" + member;
            }
        }
        return connectToState(scxmlStateName, object, member, _type);
    }
    
    private native io.qt.core.QMetaObject.Connection connectToState(long nativeId, String scxmlStateName, io.qt.core.QMetaObject.AbstractSlot slot, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToEvent">QScxmlStateMachine::connectToEvent(QString, Functor, Qt::ConnectionType)</a></p>
     */
    public io.qt.core.QMetaObject.Connection connectToEvent(String scxmlStateName,
            io.qt.core.QMetaObject.Slot0 slot, io.qt.core.Qt.ConnectionType... type){
        int _type = 0;
        for (io.qt.core.Qt.ConnectionType t : type) {
            _type |= t.value();
        }
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromMethod(java.util.Objects.requireNonNull(slot));
        if(metaMethod!=null && metaMethod.isValid() && metaMethod.parameterCount()==0) {
            io.qt.core.QObject object = QtJambi_LibraryUtilities.internal.lambdaContext(slot);
            if(object!=null) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToEvent(scxmlStateName, object, "2"+metaMethod.cppMethodSignature(), _type);
                case Method:
                case Slot:
                    return connectToEvent(scxmlStateName, object, "1"+metaMethod.cppMethodSignature(), _type);
                default:
                    break;
                }
            }
        }
        return connectToEvent(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlStateName, slot, _type);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToEvent">QScxmlStateMachine::connectToEvent(QString, Functor, Qt::ConnectionType)</a></p>
     */
    public io.qt.core.QMetaObject.Connection connectToEvent(String scxmlStateName,
            io.qt.core.QMetaObject.Connectable0 signal, io.qt.core.Qt.ConnectionType... type){
        int _type = 0;
        for (io.qt.core.Qt.ConnectionType t : type) {
            _type |= t.value();
        }
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromSignal(java.util.Objects.requireNonNull(signal));
        if(metaMethod!=null && metaMethod.isValid() && metaMethod.parameterCount()==0) {
            io.qt.core.QObject object = null;
            if(signal.containingObject() instanceof io.qt.core.QObject){
                object = (io.qt.core.QObject)signal.containingObject();
            }
            if(object!=null) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToEvent(scxmlStateName, object, "2"+metaMethod.cppMethodSignature(), _type);
                case Method:
                case Slot:
                    return connectToEvent(scxmlStateName, object, "1"+metaMethod.cppMethodSignature(), _type);
                default:
                    break;
                }
            }
        }
        if(signal instanceof io.qt.core.QMetaObject.Emitable0)
            return connectToEvent(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlStateName, (io.qt.core.QMetaObject.Slot0)((io.qt.core.QMetaObject.Emitable0)signal)::emit, _type);
        else
            return null;
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToEvent">QScxmlStateMachine::connectToEvent(QString, Functor, Qt::ConnectionType)</a></p>
     */
    public io.qt.core.QMetaObject.Connection connectToEvent(String scxmlStateName,
            io.qt.core.QMetaObject.Slot1<QScxmlEvent> slot, io.qt.core.Qt.ConnectionType... type){
        int _type = 0;
        for (io.qt.core.Qt.ConnectionType t : type) {
            _type |= t.value();
        }
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromMethod(java.util.Objects.requireNonNull(slot));
        if(metaMethod!=null && metaMethod.isValid()) {
            if(metaMethod.parameterCount()!=1 || metaMethod.parameterType(0)!=io.qt.core.QMetaType.fromType(QScxmlEvent.class).id()) {
                throw new IllegalArgumentException("Method does not take a single QScxmlEvent argument: "+metaMethod.cppMethodSignature());
            }
            io.qt.core.QObject object = QtJambi_LibraryUtilities.internal.lambdaContext(slot);
            if(object!=null) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToEvent(scxmlStateName, object, "2"+metaMethod.cppMethodSignature(), _type);
                case Method:
                case Slot:
                    return connectToEvent(scxmlStateName, object, "1"+metaMethod.cppMethodSignature(), _type);
                default:
                    break;
                }
            }
        }
        return connectToEvent(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlStateName, slot, _type);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToEvent">QScxmlStateMachine::connectToEvent(QString, Functor, Qt::ConnectionType)</a></p>
     */
    @SuppressWarnings("unchecked")
    public io.qt.core.QMetaObject.Connection connectToEvent(String scxmlStateName,
            io.qt.core.QMetaObject.Connectable1<QScxmlEvent> signal, io.qt.core.Qt.ConnectionType... type){
        int _type = 0;
        for (io.qt.core.Qt.ConnectionType t : type) {
            _type |= t.value();
        }
        io.qt.core.QMetaMethod metaMethod = io.qt.core.QMetaMethod.fromSignal(java.util.Objects.requireNonNull(signal));
        if(metaMethod!=null && metaMethod.isValid()) {
            if(metaMethod.parameterCount()!=1 || metaMethod.parameterType(0)!=io.qt.core.QMetaType.fromType(QScxmlEvent.class).id()) {
                throw new IllegalArgumentException("Method does not take a single QScxmlEvent argument: "+metaMethod.cppMethodSignature());
            }
            io.qt.core.QObject object = null;
            if(signal.containingObject() instanceof io.qt.core.QObject){
                object = (io.qt.core.QObject)signal.containingObject();
            }
            if(object!=null) {
                switch(metaMethod.methodType()) {
                case Signal:
                    return connectToEvent(scxmlStateName, object, "2"+metaMethod.cppMethodSignature(), _type);
                case Method:
                case Slot:
                    return connectToEvent(scxmlStateName, object, "1"+metaMethod.cppMethodSignature(), _type);
                default:
                    break;
                }
            }
        }
        if(signal instanceof io.qt.core.QMetaObject.Emitable1)
            return connectToEvent(QtJambi_LibraryUtilities.internal.nativeId(this), scxmlStateName, (io.qt.core.QMetaObject.Slot1<QScxmlEvent>)((io.qt.core.QMetaObject.Emitable1<QScxmlEvent>)signal)::emit, _type);
        else return null;
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlstatemachine.html#connectToEvent">QScxmlStateMachine::connectToEvent(QString, QObject, const char*, Qt::ConnectionType)</a></p>
     */
    public io.qt.core.QMetaObject.Connection connectToEvent(String scxmlStateName,
            io.qt.core.QObject object, String member, io.qt.core.Qt.ConnectionType... type){
        int _type = 0;
        for (io.qt.core.Qt.ConnectionType t : type) {
            _type |= t.value();
        }
        if(member!=null && !member.startsWith("1") && !member.startsWith("2")) {
            io.qt.core.QMetaMethod method = object.metaObject().method(member);
            if(method!=null && method.isValid()) {
                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                    member = "2" + method.cppMethodSignature();
                else
                    member = "1" + method.cppMethodSignature();
            }else {
                member = "1" + member;
            }
        }
        return connectToEvent(scxmlStateName, object, member, _type);
    }
    
    private native io.qt.core.QMetaObject.Connection connectToEvent(long nativeId, String scxmlStateName, io.qt.core.QMetaObject.AbstractSlot slot, int type);
}
