package io.qt.scxml;


/**
 * <p>The null data model for a Qt SCXML stateMachine</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qscxmlnulldatamodel.html">QScxmlNullDataModel</a></p>
 */
public class QScxmlNullDataModel extends io.qt.scxml.QScxmlDataModel
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScxmlNullDataModel.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QScxmlNullDataModel(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QScxmlNullDataModel() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlnulldatamodel.html#QScxmlNullDataModel">QScxmlNullDataModel::QScxmlNullDataModel(QObject*)</a></p>
     */
    public QScxmlNullDataModel(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QScxmlNullDataModel instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateAssignment">QScxmlDataModel::evaluateAssignment(QScxmlExecutableContent::EvaluatorId,bool*)</a></p>
     */
    public final void evaluateAssignment(int id, boolean[] ok){
        evaluateAssignment_native_int_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
    }
    
    private native void evaluateAssignment_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateForeach">QScxmlDataModel::evaluateForeach(QScxmlExecutableContent::EvaluatorId,bool*,QScxmlDataModel::ForeachLoopBody*)</a></p>
     */
    public final void evaluateForeach(int id, boolean[] ok, io.qt.scxml.QScxmlDataModel.ForeachLoopBody body){
        evaluateForeach_native_int_bool_ptr_QScxmlDataModel_ForeachLoopBody_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok, QtJambi_LibraryUtilities.internal.checkedNativeId(body));
    }
    
    private native void evaluateForeach_native_int_bool_ptr_QScxmlDataModel_ForeachLoopBody_ptr(long __this__nativeId, int id, boolean[] ok, long body);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateInitialization">QScxmlDataModel::evaluateInitialization(QScxmlExecutableContent::EvaluatorId,bool*)</a></p>
     */
    public final void evaluateInitialization(int id, boolean[] ok){
        evaluateInitialization_native_int_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
    }
    
    private native void evaluateInitialization_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateToBool">QScxmlDataModel::evaluateToBool(QScxmlExecutableContent::EvaluatorId,bool*)</a></p>
     */
    public final boolean evaluateToBool(int id, boolean[] ok){
        return evaluateToBool_native_int_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
    }
    
    private native boolean evaluateToBool_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateToString">QScxmlDataModel::evaluateToString(QScxmlExecutableContent::EvaluatorId,bool*)</a></p>
     */
    public final java.lang.String evaluateToString(int id, boolean[] ok){
        return evaluateToString_native_int_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
    }
    
    private native java.lang.String evaluateToString_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateToVariant">QScxmlDataModel::evaluateToVariant(QScxmlExecutableContent::EvaluatorId,bool*)</a></p>
     */
    public final java.lang.Object evaluateToVariant(int id, boolean[] ok){
        return evaluateToVariant_native_int_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
    }
    
    private native java.lang.Object evaluateToVariant_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#evaluateToVoid">QScxmlDataModel::evaluateToVoid(QScxmlExecutableContent::EvaluatorId,bool*)</a></p>
     */
    public final void evaluateToVoid(int id, boolean[] ok){
        evaluateToVoid_native_int_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, ok);
    }
    
    private native void evaluateToVoid_native_int_bool_ptr(long __this__nativeId, int id, boolean[] ok);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#hasScxmlProperty">QScxmlDataModel::hasScxmlProperty(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean hasScxmlProperty(java.lang.String name){
        return hasScxmlProperty_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native boolean hasScxmlProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#scxmlProperty">QScxmlDataModel::scxmlProperty(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.Object scxmlProperty(java.lang.String name){
        return scxmlProperty_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object scxmlProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#setScxmlEvent">QScxmlDataModel::setScxmlEvent(QScxmlEvent)</a></p>
     */
    @io.qt.QtUninvokable
    public void setScxmlEvent(io.qt.scxml.QScxmlEvent event){
        setScxmlEvent_native_cref_QScxmlEvent(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void setScxmlEvent_native_cref_QScxmlEvent(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#setScxmlProperty">QScxmlDataModel::setScxmlProperty(QString,QVariant,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean setScxmlProperty(java.lang.String name, java.lang.Object value, java.lang.String context){
        return setScxmlProperty_native_cref_QString_cref_QVariant_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name, value, context);
    }
    
    @io.qt.QtUninvokable
    private native boolean setScxmlProperty_native_cref_QString_cref_QVariant_cref_QString(long __this__nativeId, java.lang.String name, java.lang.Object value, java.lang.String context);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmldatamodel.html#setup">QScxmlDataModel::setup(QVariantMap)</a></p>
     */
    public boolean setup(java.util.Map<java.lang.String, ? extends java.lang.Object> initialDataValues){
        return setup_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), initialDataValues);
    }
    
    private native boolean setup_native_cref_QMap(long __this__nativeId, java.util.Map<java.lang.String, ? extends java.lang.Object> initialDataValues);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QScxmlNullDataModel(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QScxmlNullDataModel(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QScxmlNullDataModel instance, QDeclarativeConstructor constructor);
    
}
