package io.qt.scxml;


/**
 * <p>Contains various types used to interpret executable content in state machines</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qscxmlexecutablecontent.html">QScxmlExecutableContent</a></p>
 */
public final class QScxmlExecutableContent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QScxmlExecutableContent() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QScxmlExecutableContent."); }
    
    /**
     * <p>Represents a unit of executable content</p>
     * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-evaluatorinfo.html">QScxmlExecutableContent::EvaluatorInfo</a></p>
     */
    public static class EvaluatorInfo extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public EvaluatorInfo(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(EvaluatorInfo instance);
        
        /**
         * <p>For evaluating the expression</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-evaluatorinfo.html#context-var">QScxmlExecutableContent::EvaluatorInfo::context</a></p>
         */
        @io.qt.QtUninvokable
        public final void setContext(int context){
            setContext_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), context);
        }
        
        @io.qt.QtUninvokable
        private native void setContext_native_int(long __this__nativeId, int context);
        
        /**
         * <p>For evaluating the expression</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-evaluatorinfo.html#context-var">QScxmlExecutableContent::EvaluatorInfo::context</a></p>
         */
        @io.qt.QtUninvokable
        public final int context(){
            return context_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int context_native(long __this__nativeId);
        
        /**
         * <p>Expression to be evaluated</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-evaluatorinfo.html#expr-var">QScxmlExecutableContent::EvaluatorInfo::expr</a></p>
         */
        @io.qt.QtUninvokable
        public final void setExpr(int expr){
            setExpr_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), expr);
        }
        
        @io.qt.QtUninvokable
        private native void setExpr_native_int(long __this__nativeId, int expr);
        
        /**
         * <p>Expression to be evaluated</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-evaluatorinfo.html#expr-var">QScxmlExecutableContent::EvaluatorInfo::expr</a></p>
         */
        @io.qt.QtUninvokable
        public final int expr(){
            return expr_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int expr_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected EvaluatorInfo(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public EvaluatorInfo clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native EvaluatorInfo clone_native(long __this_nativeId);
    }
    /**
     * <p>AssingmentInfo class represents a data assignment</p>
     * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-assignmentinfo.html">QScxmlExecutableContent::AssignmentInfo</a></p>
     */
    public static class AssignmentInfo extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public AssignmentInfo(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(AssignmentInfo instance);
        
        /**
         * <p>For evaluating the expression</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-assignmentinfo.html#context-var">QScxmlExecutableContent::AssignmentInfo::context</a></p>
         */
        @io.qt.QtUninvokable
        public final void setContext(int context){
            setContext_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), context);
        }
        
        @io.qt.QtUninvokable
        private native void setContext_native_int(long __this__nativeId, int context);
        
        /**
         * <p>For evaluating the expression</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-assignmentinfo.html#context-var">QScxmlExecutableContent::AssignmentInfo::context</a></p>
         */
        @io.qt.QtUninvokable
        public final int context(){
            return context_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int context_native(long __this__nativeId);
        
        /**
         * <p>Name of the data item to assign to</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-assignmentinfo.html#dest-var">QScxmlExecutableContent::AssignmentInfo::dest</a></p>
         */
        @io.qt.QtUninvokable
        public final void setDest(int dest){
            setDest_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), dest);
        }
        
        @io.qt.QtUninvokable
        private native void setDest_native_int(long __this__nativeId, int dest);
        
        /**
         * <p>Name of the data item to assign to</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-assignmentinfo.html#dest-var">QScxmlExecutableContent::AssignmentInfo::dest</a></p>
         */
        @io.qt.QtUninvokable
        public final int dest(){
            return dest_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int dest_native(long __this__nativeId);
        
        /**
         * <p>Expression to be evaluated</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-assignmentinfo.html#expr-var">QScxmlExecutableContent::AssignmentInfo::expr</a></p>
         */
        @io.qt.QtUninvokable
        public final void setExpr(int expr){
            setExpr_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), expr);
        }
        
        @io.qt.QtUninvokable
        private native void setExpr_native_int(long __this__nativeId, int expr);
        
        /**
         * <p>Expression to be evaluated</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-assignmentinfo.html#expr-var">QScxmlExecutableContent::AssignmentInfo::expr</a></p>
         */
        @io.qt.QtUninvokable
        public final int expr(){
            return expr_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int expr_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected AssignmentInfo(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public AssignmentInfo clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native AssignmentInfo clone_native(long __this_nativeId);
    }
    /**
     * <p>Represents a foreach construct</p>
     * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html">QScxmlExecutableContent::ForeachInfo</a></p>
     */
    public static class ForeachInfo extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public ForeachInfo(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(ForeachInfo instance);
        
        /**
         * <p>Name of the array that is iterated over</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#array-var">QScxmlExecutableContent::ForeachInfo::array</a></p>
         */
        @io.qt.QtUninvokable
        public final void setArray(int array){
            setArray_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), array);
        }
        
        @io.qt.QtUninvokable
        private native void setArray_native_int(long __this__nativeId, int array);
        
        /**
         * <p>Name of the array that is iterated over</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#array-var">QScxmlExecutableContent::ForeachInfo::array</a></p>
         */
        @io.qt.QtUninvokable
        public final int array(){
            return array_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int array_native(long __this__nativeId);
        
        /**
         * <p>For evaluating the expression</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#context-var">QScxmlExecutableContent::ForeachInfo::context</a></p>
         */
        @io.qt.QtUninvokable
        public final void setContext(int context){
            setContext_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), context);
        }
        
        @io.qt.QtUninvokable
        private native void setContext_native_int(long __this__nativeId, int context);
        
        /**
         * <p>For evaluating the expression</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#context-var">QScxmlExecutableContent::ForeachInfo::context</a></p>
         */
        @io.qt.QtUninvokable
        public final int context(){
            return context_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int context_native(long __this__nativeId);
        
        /**
         * <p>Name of the index variable</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#index-var">QScxmlExecutableContent::ForeachInfo::index</a></p>
         */
        @io.qt.QtUninvokable
        public final void setIndex(int index){
            setIndex_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
        }
        
        @io.qt.QtUninvokable
        private native void setIndex_native_int(long __this__nativeId, int index);
        
        /**
         * <p>Name of the index variable</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#index-var">QScxmlExecutableContent::ForeachInfo::index</a></p>
         */
        @io.qt.QtUninvokable
        public final int index(){
            return index_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int index_native(long __this__nativeId);
        
        /**
         * <p>Name of the iteration variable</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#item-var">QScxmlExecutableContent::ForeachInfo::item</a></p>
         */
        @io.qt.QtUninvokable
        public final void setItem(int item){
            setItem_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), item);
        }
        
        @io.qt.QtUninvokable
        private native void setItem_native_int(long __this__nativeId, int item);
        
        /**
         * <p>Name of the iteration variable</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-foreachinfo.html#item-var">QScxmlExecutableContent::ForeachInfo::item</a></p>
         */
        @io.qt.QtUninvokable
        public final int item(){
            return item_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int item_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected ForeachInfo(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public ForeachInfo clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native ForeachInfo clone_native(long __this_nativeId);
    }
    /**
     * <p>Represents a parameter to a service invocation</p>
     * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-parameterinfo.html">QScxmlExecutableContent::ParameterInfo</a></p>
     */
    public static class ParameterInfo extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public ParameterInfo(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(ParameterInfo instance);
        
        /**
         * <p>Expression to be evaluated</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-parameterinfo.html#expr-var">QScxmlExecutableContent::ParameterInfo::expr</a></p>
         */
        @io.qt.QtUninvokable
        public final void setExpr(int expr){
            setExpr_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), expr);
        }
        
        @io.qt.QtUninvokable
        private native void setExpr_native_int(long __this__nativeId, int expr);
        
        /**
         * <p>Expression to be evaluated</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-parameterinfo.html#expr-var">QScxmlExecutableContent::ParameterInfo::expr</a></p>
         */
        @io.qt.QtUninvokable
        public final int expr(){
            return expr_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int expr_native(long __this__nativeId);
        
        /**
         * <p>Data model name of the item to be passed as a parameter</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-parameterinfo.html#location-var">QScxmlExecutableContent::ParameterInfo::location</a></p>
         */
        @io.qt.QtUninvokable
        public final void setLocation(int location){
            setLocation_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), location);
        }
        
        @io.qt.QtUninvokable
        private native void setLocation_native_int(long __this__nativeId, int location);
        
        /**
         * <p>Data model name of the item to be passed as a parameter</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-parameterinfo.html#location-var">QScxmlExecutableContent::ParameterInfo::location</a></p>
         */
        @io.qt.QtUninvokable
        public final int location(){
            return location_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int location_native(long __this__nativeId);
        
        /**
         * <p>Of the parameter</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-parameterinfo.html#name-var">QScxmlExecutableContent::ParameterInfo::name</a></p>
         */
        @io.qt.QtUninvokable
        public final void setName(int name){
            setName_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), name);
        }
        
        @io.qt.QtUninvokable
        private native void setName_native_int(long __this__nativeId, int name);
        
        /**
         * <p>Of the parameter</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-parameterinfo.html#name-var">QScxmlExecutableContent::ParameterInfo::name</a></p>
         */
        @io.qt.QtUninvokable
        public final int name(){
            return name_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int name_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected ParameterInfo(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public ParameterInfo clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native ParameterInfo clone_native(long __this_nativeId);
    }
    /**
     * <p>Represents a service invocation</p>
     * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html">QScxmlExecutableContent::InvokeInfo</a></p>
     */
    public static class InvokeInfo extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public InvokeInfo(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(InvokeInfo instance);
        
        /**
         * <p>Whether events should automatically be forwarded to the invoked service</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#autoforward-var">QScxmlExecutableContent::InvokeInfo::autoforward</a></p>
         */
        @io.qt.QtUninvokable
        public final void setAutoforward(boolean autoforward){
            setAutoforward_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), autoforward);
        }
        
        @io.qt.QtUninvokable
        private native void setAutoforward_native_bool(long __this__nativeId, boolean autoforward);
        
        /**
         * <p>Whether events should automatically be forwarded to the invoked service</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#autoforward-var">QScxmlExecutableContent::InvokeInfo::autoforward</a></p>
         */
        @io.qt.QtUninvokable
        public final boolean autoforward(){
            return autoforward_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean autoforward_native(long __this__nativeId);
        
        /**
         * <p>To interpret the location in</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#context-var">QScxmlExecutableContent::InvokeInfo::context</a></p>
         */
        @io.qt.QtUninvokable
        public final void setContext(int context){
            setContext_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), context);
        }
        
        @io.qt.QtUninvokable
        private native void setContext_native_int(long __this__nativeId, int context);
        
        /**
         * <p>To interpret the location in</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#context-var">QScxmlExecutableContent::InvokeInfo::context</a></p>
         */
        @io.qt.QtUninvokable
        public final int context(){
            return context_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int context_native(long __this__nativeId);
        
        /**
         * <p>Expression representing the srcexpr of the invoke element</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#expr-var">QScxmlExecutableContent::InvokeInfo::expr</a></p>
         */
        @io.qt.QtUninvokable
        public final void setExpr(int expr){
            setExpr_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), expr);
        }
        
        @io.qt.QtUninvokable
        private native void setExpr_native_int(long __this__nativeId, int expr);
        
        /**
         * <p>Expression representing the srcexpr of the invoke element</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#expr-var">QScxmlExecutableContent::InvokeInfo::expr</a></p>
         */
        @io.qt.QtUninvokable
        public final int expr(){
            return expr_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int expr_native(long __this__nativeId);
        
        /**
         * <p>ID of the container of executable content to be run on finalizing the invocation</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#finalize-var">QScxmlExecutableContent::InvokeInfo::finalize</a></p>
         */
        @io.qt.QtUninvokable
        public final void setFinalizeId(int finalizeId){
            setFinalizeId_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), finalizeId);
        }
        
        @io.qt.QtUninvokable
        private native void setFinalizeId_native_int(long __this__nativeId, int finalizeId);
        
        /**
         * <p>ID of the container of executable content to be run on finalizing the invocation</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#finalize-var">QScxmlExecutableContent::InvokeInfo::finalize</a></p>
         */
        @io.qt.QtUninvokable
        public final int finalizeId(){
            return finalizeId_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int finalizeId_native(long __this__nativeId);
        
        /**
         * <p>ID specified by the id attribute in the &lt;invoke&gt; element</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#id-var">QScxmlExecutableContent::InvokeInfo::id</a></p>
         */
        @io.qt.QtUninvokable
        public final void setId(int id){
            setId_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), id);
        }
        
        @io.qt.QtUninvokable
        private native void setId_native_int(long __this__nativeId, int id);
        
        /**
         * <p>ID specified by the id attribute in the &lt;invoke&gt; element</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#id-var">QScxmlExecutableContent::InvokeInfo::id</a></p>
         */
        @io.qt.QtUninvokable
        public final int id(){
            return id_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int id_native(long __this__nativeId);
        
        /**
         * <p>Data model location to write the invocation ID to</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#location-var">QScxmlExecutableContent::InvokeInfo::location</a></p>
         */
        @io.qt.QtUninvokable
        public final void setLocation(int location){
            setLocation_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), location);
        }
        
        @io.qt.QtUninvokable
        private native void setLocation_native_int(long __this__nativeId, int location);
        
        /**
         * <p>Data model location to write the invocation ID to</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#location-var">QScxmlExecutableContent::InvokeInfo::location</a></p>
         */
        @io.qt.QtUninvokable
        public final int location(){
            return location_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int location_native(long __this__nativeId);
        
        /**
         * <p>Unique prefix for this invocation in the context of the state from which it is called</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#prefix-var">QScxmlExecutableContent::InvokeInfo::prefix</a></p>
         */
        @io.qt.QtUninvokable
        public final void setPrefix(int prefix){
            setPrefix_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), prefix);
        }
        
        @io.qt.QtUninvokable
        private native void setPrefix_native_int(long __this__nativeId, int prefix);
        
        /**
         * <p>Unique prefix for this invocation in the context of the state from which it is called</p>
         * <p>See <a href="https://doc.qt.io/qt/qscxmlexecutablecontent-invokeinfo.html#prefix-var">QScxmlExecutableContent::InvokeInfo::prefix</a></p>
         */
        @io.qt.QtUninvokable
        public final int prefix(){
            return prefix_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int prefix_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected InvokeInfo(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public InvokeInfo clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native InvokeInfo clone_native(long __this_nativeId);
    }
    
    public final static int NoContainer = -1;
    public final static int NoString = -1;
    public final static int NoInstruction = -1;
    public final static int NoEvaluator = -1;
}
