package io.qt.scxml;


/**
 * <p>Event for a Qt SCXML state machine</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qscxmlevent.html">QScxmlEvent</a></p>
 */
public class QScxmlEvent extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScxmlEvent.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qscxmlevent.html#EventType-enum">QScxmlEvent::EventType</a></p>
     */
    public enum EventType implements io.qt.QtEnumerator {
        PlatformEvent(0),
        InternalEvent(1),
        ExternalEvent(2);

        private EventType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static EventType resolve(int value) {
            switch (value) {
            case 0: return PlatformEvent;
            case 1: return InternalEvent;
            case 2: return ExternalEvent;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#QScxmlEvent">QScxmlEvent::QScxmlEvent()</a></p>
     */
    public QScxmlEvent(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QScxmlEvent instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#QScxmlEvent-1">QScxmlEvent::QScxmlEvent(QScxmlEvent)</a></p>
     */
    public QScxmlEvent(io.qt.scxml.QScxmlEvent other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QScxmlEvent instance, io.qt.scxml.QScxmlEvent other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#clear">QScxmlEvent::clear()</a></p>
     */
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#data">QScxmlEvent::data()const</a></p>
     */
    @io.qt.QtPropertyReader(name="data")
    @io.qt.QtUninvokable
    public final java.lang.Object data(){
        return data_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object data_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#delay">QScxmlEvent::delay()const</a></p>
     */
    @io.qt.QtPropertyReader(name="delay")
    @io.qt.QtUninvokable
    public final int delay(){
        return delay_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int delay_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#errorMessage">QScxmlEvent::errorMessage()const</a></p>
     */
    @io.qt.QtPropertyReader(name="errorMessage")
    @io.qt.QtUninvokable
    public final java.lang.String errorMessage(){
        return errorMessage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String errorMessage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#eventType">QScxmlEvent::eventType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="eventType")
    @io.qt.QtUninvokable
    public final io.qt.scxml.QScxmlEvent.EventType eventType(){
        return io.qt.scxml.QScxmlEvent.EventType.resolve(eventType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int eventType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#invokeId">QScxmlEvent::invokeId()const</a></p>
     */
    @io.qt.QtPropertyReader(name="invokeId")
    @io.qt.QtUninvokable
    public final java.lang.String invokeId(){
        return invokeId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String invokeId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#isErrorEvent">QScxmlEvent::isErrorEvent()const</a></p>
     */
    @io.qt.QtPropertyReader(name="errorEvent")
    @io.qt.QtUninvokable
    public final boolean isErrorEvent(){
        return isErrorEvent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isErrorEvent_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#name">QScxmlEvent::name()const</a></p>
     */
    @io.qt.QtPropertyReader(name="name")
    @io.qt.QtUninvokable
    public final java.lang.String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#origin">QScxmlEvent::origin()const</a></p>
     */
    @io.qt.QtPropertyReader(name="origin")
    @io.qt.QtUninvokable
    public final java.lang.String origin(){
        return origin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String origin_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#originType">QScxmlEvent::originType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="originType")
    @io.qt.QtUninvokable
    public final java.lang.String originType(){
        return originType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String originType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#scxmlType">QScxmlEvent::scxmlType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="scxmlType")
    @io.qt.QtUninvokable
    public final java.lang.String scxmlType(){
        return scxmlType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String scxmlType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#sendId">QScxmlEvent::sendId()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sendId")
    @io.qt.QtUninvokable
    public final java.lang.String sendId(){
        return sendId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String sendId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#setData">QScxmlEvent::setData(QVariant)</a></p>
     */
    @io.qt.QtPropertyWriter(name="data")
    @io.qt.QtUninvokable
    public final void setData(java.lang.Object data){
        setData_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @io.qt.QtUninvokable
    private native void setData_native_cref_QVariant(long __this__nativeId, java.lang.Object data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#setDelay">QScxmlEvent::setDelay(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="delay")
    @io.qt.QtUninvokable
    public final void setDelay(int delayInMiliSecs){
        setDelay_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), delayInMiliSecs);
    }
    
    @io.qt.QtUninvokable
    private native void setDelay_native_int(long __this__nativeId, int delayInMiliSecs);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#setErrorMessage">QScxmlEvent::setErrorMessage(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="errorMessage")
    @io.qt.QtUninvokable
    public final void setErrorMessage(java.lang.String message){
        setErrorMessage_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), message);
    }
    
    @io.qt.QtUninvokable
    private native void setErrorMessage_native_cref_QString(long __this__nativeId, java.lang.String message);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#setEventType">QScxmlEvent::setEventType(QScxmlEvent::EventType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="eventType")
    @io.qt.QtUninvokable
    public final void setEventType(io.qt.scxml.QScxmlEvent.EventType type){
        setEventType_native_cref_QScxmlEvent_EventType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @io.qt.QtUninvokable
    private native void setEventType_native_cref_QScxmlEvent_EventType(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#setInvokeId">QScxmlEvent::setInvokeId(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="invokeId")
    @io.qt.QtUninvokable
    public final void setInvokeId(java.lang.String invokeId){
        setInvokeId_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), invokeId);
    }
    
    @io.qt.QtUninvokable
    private native void setInvokeId_native_cref_QString(long __this__nativeId, java.lang.String invokeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#setName">QScxmlEvent::setName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="name")
    @io.qt.QtUninvokable
    public final void setName(java.lang.String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#setOrigin">QScxmlEvent::setOrigin(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="origin")
    @io.qt.QtUninvokable
    public final void setOrigin(java.lang.String origin){
        setOrigin_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), origin);
    }
    
    @io.qt.QtUninvokable
    private native void setOrigin_native_cref_QString(long __this__nativeId, java.lang.String origin);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#setOriginType">QScxmlEvent::setOriginType(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="originType")
    @io.qt.QtUninvokable
    public final void setOriginType(java.lang.String originType){
        setOriginType_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), originType);
    }
    
    @io.qt.QtUninvokable
    private native void setOriginType_native_cref_QString(long __this__nativeId, java.lang.String originType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlevent.html#setSendId">QScxmlEvent::setSendId(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sendId")
    @io.qt.QtUninvokable
    public final void setSendId(java.lang.String sendId){
        setSendId_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), sendId);
    }
    
    @io.qt.QtUninvokable
    private native void setSendId_native_cref_QString(long __this__nativeId, java.lang.String sendId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QScxmlEvent(QPrivateConstructor p) { super(p); } 
    
    
    @Override
    public QScxmlEvent clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QScxmlEvent clone_native(long __this_nativeId);
}
