package io.qt.scxml;


/**
 * <p>Compiler for SCXML files</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qscxmlcompiler.html">QScxmlCompiler</a></p>
 */
public class QScxmlCompiler extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcLoader = null;
    
    /**
     * <p>URI resolver and resource loader for an SCXML compiler</p>
     * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qscxmlcompiler-loader.html">QScxmlCompiler::Loader</a></p>
     */
    public interface Loader extends io.qt.QtObjectInterface
    {
        /**
         * <p>Implementor class for interface {@link io.qt.scxml.QScxmlCompiler.Loader}</p>
         */
        public static abstract class Impl extends io.qt.QtObject
            implements io.qt.scxml.QScxmlCompiler.Loader
        {
            static {
                QtJambi_LibraryUtilities.initialize();
            }
            
            @io.qt.NativeAccess
            private static final class ConcreteWrapper extends QScxmlCompiler.Loader.Impl {
                
                @io.qt.NativeAccess
                private ConcreteWrapper(QPrivateConstructor p) { super(p); }
                
                @Override
                @io.qt.QtUninvokable
                public io.qt.core.QByteArray load(java.lang.String name, java.lang.String baseDir, java.util.Collection<java.lang.String> errors){
                    return load_native_cref_QString_cref_QString_QStringList_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), name, baseDir, errors);
                }
                private native static io.qt.core.QByteArray load_native_cref_QString_cref_QString_QStringList_ptr(long __this__nativeId, java.lang.String name, java.lang.String baseDir, java.util.Collection<java.lang.String> errors);
                
            }
            
            
            /**
             * <p>See <a href="https://doc.qt.io/qt/qscxmlcompiler-loader.html#Loader">QScxmlCompiler::Loader::Loader()</a></p>
             */
            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }
            
            private native static void initialize_native(Loader instance);
            
            /**
             * <p>See <a href="https://doc.qt.io/qt/qscxmlcompiler-loader.html#load">QScxmlCompiler::Loader::load(QString,QString,QStringList*)</a></p>
             */
            @io.qt.QtUninvokable
            public abstract io.qt.core.QByteArray load(java.lang.String name, java.lang.String baseDir, java.util.Collection<java.lang.String> errors);
            
            private native static io.qt.core.QByteArray load_native_cref_QString_cref_QString_QStringList_ptr(long __this__nativeId, java.lang.String name, java.lang.String baseDir, java.util.Collection<java.lang.String> errors);
            
            /**
             * Constructor for internal use only.
             * @param p expected to be <code>null</code>.
             */
            @io.qt.NativeAccess
            protected Impl(QPrivateConstructor p) { super(p); } 
            
        }

        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qscxmlcompiler-loader.html#load">QScxmlCompiler::Loader::load(QString,QString,QStringList*)</a></p>
         */
        @io.qt.QtUninvokable
        public io.qt.core.QByteArray load(java.lang.String name, java.lang.String baseDir, java.util.Collection<java.lang.String> errors);
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlcompiler.html#QScxmlCompiler">QScxmlCompiler::QScxmlCompiler(QXmlStreamReader*)</a></p>
     */
    public QScxmlCompiler(io.qt.core.QXmlStreamReader xmlReader){
        super((QPrivateConstructor)null);
        initialize_native(this, xmlReader);
    }
    
    private native static void initialize_native(QScxmlCompiler instance, io.qt.core.QXmlStreamReader xmlReader);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlcompiler.html#compile">QScxmlCompiler::compile()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.scxml.QScxmlStateMachine compile(){
        return compile_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.scxml.QScxmlStateMachine compile_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlcompiler.html#errors">QScxmlCompiler::errors()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.scxml.QScxmlError> errors(){
        return errors_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.scxml.QScxmlError> errors_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlcompiler.html#fileName">QScxmlCompiler::fileName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String fileName(){
        return fileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String fileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlcompiler.html#loader">QScxmlCompiler::loader()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.scxml.QScxmlCompiler.Loader loader(){
        return loader_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.scxml.QScxmlCompiler.Loader loader_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlcompiler.html#setFileName">QScxmlCompiler::setFileName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFileName(java.lang.String fileName){
        setFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @io.qt.QtUninvokable
    private native void setFileName_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscxmlcompiler.html#setLoader">QScxmlCompiler::setLoader(QScxmlCompiler::Loader*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setLoader(io.qt.scxml.QScxmlCompiler.Loader newLoader){
        setLoader_native_QScxmlCompiler_Loader_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newLoader));
        __rcLoader = newLoader;
    }
    
    @io.qt.QtUninvokable
    private native void setLoader_native_QScxmlCompiler_Loader_ptr(long __this__nativeId, long newLoader);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QScxmlCompiler(QPrivateConstructor p) { super(p); } 
    
}
