package io.qt.script.tools;


/**
 * <p>QScriptEngine debugger</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html">QScriptEngineDebugger</a></p>
 */
public class QScriptEngineDebugger extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScriptEngineDebugger.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::DebuggerAction</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum DebuggerAction implements io.qt.QtEnumerator {
        InterruptAction(0),
        ContinueAction(1),
        StepIntoAction(2),
        StepOverAction(3),
        StepOutAction(4),
        RunToCursorAction(5),
        RunToNewScriptAction(6),
        ToggleBreakpointAction(7),
        ClearDebugOutputAction(8),
        ClearErrorLogAction(9),
        ClearConsoleAction(10),
        FindInScriptAction(11),
        FindNextInScriptAction(12),
        FindPreviousInScriptAction(13),
        GoToLineAction(14);

        private DebuggerAction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DebuggerAction resolve(int value) {
            switch (value) {
            case 0: return InterruptAction;
            case 1: return ContinueAction;
            case 2: return StepIntoAction;
            case 3: return StepOverAction;
            case 4: return StepOutAction;
            case 5: return RunToCursorAction;
            case 6: return RunToNewScriptAction;
            case 7: return ToggleBreakpointAction;
            case 8: return ClearDebugOutputAction;
            case 9: return ClearErrorLogAction;
            case 10: return ClearConsoleAction;
            case 11: return FindInScriptAction;
            case 12: return FindNextInScriptAction;
            case 13: return FindPreviousInScriptAction;
            case 14: return GoToLineAction;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerState-enum">QScriptEngineDebugger::DebuggerState</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum DebuggerState implements io.qt.QtEnumerator {
        RunningState(0),
        SuspendedState(1);

        private DebuggerState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DebuggerState resolve(int value) {
            switch (value) {
            case 0: return RunningState;
            case 1: return SuspendedState;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerWidget-enum">QScriptEngineDebugger::DebuggerWidget</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum DebuggerWidget implements io.qt.QtEnumerator {
        ConsoleWidget(0),
        StackWidget(1),
        ScriptsWidget(2),
        LocalsWidget(3),
        CodeWidget(4),
        CodeFinderWidget(5),
        BreakpointsWidget(6),
        DebugOutputWidget(7),
        ErrorLogWidget(8);

        private DebuggerWidget(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DebuggerWidget resolve(int value) {
            switch (value) {
            case 0: return ConsoleWidget;
            case 1: return StackWidget;
            case 2: return ScriptsWidget;
            case 3: return LocalsWidget;
            case 4: return CodeWidget;
            case 5: return CodeFinderWidget;
            case 6: return BreakpointsWidget;
            case 7: return DebugOutputWidget;
            case 8: return ErrorLogWidget;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#evaluationResumed">QScriptEngineDebugger::evaluationResumed()</a></p>
     */
    public final Signal0 evaluationResumed = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#evaluationSuspended">QScriptEngineDebugger::evaluationSuspended()</a></p>
     */
    public final Signal0 evaluationSuspended = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QScriptEngineDebugger(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QScriptEngineDebugger() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#QScriptEngineDebugger">QScriptEngineDebugger::QScriptEngineDebugger(QObject*)</a></p>
     */
    public QScriptEngineDebugger(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QScriptEngineDebugger instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#action">QScriptEngineDebugger::action(QScriptEngineDebugger::DebuggerAction)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.widgets.QAction action(io.qt.script.tools.QScriptEngineDebugger.DebuggerAction action){
        return action_native_QScriptEngineDebugger_DebuggerAction_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), action.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QAction action_native_QScriptEngineDebugger_DebuggerAction_constfct(long __this__nativeId, int action);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#attachTo">QScriptEngineDebugger::attachTo(QScriptEngine*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void attachTo(io.qt.script.QScriptEngine engine){
        attachTo_native_QScriptEngine_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(engine));
    }
    
    @io.qt.QtUninvokable
    private native void attachTo_native_QScriptEngine_ptr(long __this__nativeId, long engine);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#autoShowStandardWindow">QScriptEngineDebugger::autoShowStandardWindow()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean autoShowStandardWindow(){
        return autoShowStandardWindow_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean autoShowStandardWindow_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #createStandardMenu(io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.widgets.QMenu createStandardMenu() {
        return createStandardMenu((io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#createStandardMenu">QScriptEngineDebugger::createStandardMenu(QWidget*)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.widgets.QMenu createStandardMenu(io.qt.widgets.QWidget parent){
        return createStandardMenu_native_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QMenu createStandardMenu_native_QWidget_ptr(long __this__nativeId, long parent);
    
    /**
     * <p>Overloaded function for {@link #createStandardToolBar(io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.widgets.QToolBar createStandardToolBar() {
        return createStandardToolBar((io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#createStandardToolBar">QScriptEngineDebugger::createStandardToolBar(QWidget*)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.widgets.QToolBar createStandardToolBar(io.qt.widgets.QWidget parent){
        return createStandardToolBar_native_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QToolBar createStandardToolBar_native_QWidget_ptr(long __this__nativeId, long parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#detach">QScriptEngineDebugger::detach()</a></p>
     */
    @io.qt.QtUninvokable
    public final void detach(){
        detach_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void detach_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#setAutoShowStandardWindow">QScriptEngineDebugger::setAutoShowStandardWindow(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAutoShowStandardWindow(boolean autoShow){
        setAutoShowStandardWindow_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), autoShow);
    }
    
    @io.qt.QtUninvokable
    private native void setAutoShowStandardWindow_native_bool(long __this__nativeId, boolean autoShow);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#standardWindow">QScriptEngineDebugger::standardWindow()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.widgets.QMainWindow standardWindow(){
        return standardWindow_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QMainWindow standardWindow_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#state">QScriptEngineDebugger::state()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.tools.QScriptEngineDebugger.DebuggerState state(){
        return io.qt.script.tools.QScriptEngineDebugger.DebuggerState.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#widget">QScriptEngineDebugger::widget(QScriptEngineDebugger::DebuggerWidget)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.widgets.QWidget widget(io.qt.script.tools.QScriptEngineDebugger.DebuggerWidget widget){
        return widget_native_QScriptEngineDebugger_DebuggerWidget_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), widget.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QWidget widget_native_QScriptEngineDebugger_DebuggerWidget_constfct(long __this__nativeId, int widget);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QScriptEngineDebugger(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QScriptEngineDebugger(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QScriptEngineDebugger instance, QDeclarativeConstructor constructor);
    
}
