package io.qt.script.tools;

import io.qt.*;


/**
 * <p>QScriptEngine debugger</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html">QScriptEngineDebugger</a></code></p>
 */
public class QScriptEngineDebugger extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScriptEngineDebugger.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::DebuggerAction</a></code></p>
     */
    @QtUnlistedEnum
    public enum DebuggerAction implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>InterruptAction</a></code></p>
         */
        InterruptAction(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>ContinueAction</a></code></p>
         */
        ContinueAction(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>StepIntoAction</a></code></p>
         */
        StepIntoAction(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>StepOverAction</a></code></p>
         */
        StepOverAction(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>StepOutAction</a></code></p>
         */
        StepOutAction(4),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>RunToCursorAction</a></code></p>
         */
        RunToCursorAction(5),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>RunToNewScriptAction</a></code></p>
         */
        RunToNewScriptAction(6),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>ToggleBreakpointAction</a></code></p>
         */
        ToggleBreakpointAction(7),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>ClearDebugOutputAction</a></code></p>
         */
        ClearDebugOutputAction(8),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>ClearErrorLogAction</a></code></p>
         */
        ClearErrorLogAction(9),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>ClearConsoleAction</a></code></p>
         */
        ClearConsoleAction(10),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>FindInScriptAction</a></code></p>
         */
        FindInScriptAction(11),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>FindNextInScriptAction</a></code></p>
         */
        FindNextInScriptAction(12),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>FindPreviousInScriptAction</a></code></p>
         */
        FindPreviousInScriptAction(13),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerAction-enum">QScriptEngineDebugger::<wbr>GoToLineAction</a></code></p>
         */
        GoToLineAction(14);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DebuggerAction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DebuggerAction resolve(int value) {
            switch (value) {
            case 0: return InterruptAction;
            case 1: return ContinueAction;
            case 2: return StepIntoAction;
            case 3: return StepOverAction;
            case 4: return StepOutAction;
            case 5: return RunToCursorAction;
            case 6: return RunToNewScriptAction;
            case 7: return ToggleBreakpointAction;
            case 8: return ClearDebugOutputAction;
            case 9: return ClearErrorLogAction;
            case 10: return ClearConsoleAction;
            case 11: return FindInScriptAction;
            case 12: return FindNextInScriptAction;
            case 13: return FindPreviousInScriptAction;
            case 14: return GoToLineAction;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerState-enum">QScriptEngineDebugger::DebuggerState</a></code></p>
     */
    @QtUnlistedEnum
    public enum DebuggerState implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerState-enum">QScriptEngineDebugger::<wbr>RunningState</a></code></p>
         */
        RunningState(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerState-enum">QScriptEngineDebugger::<wbr>SuspendedState</a></code></p>
         */
        SuspendedState(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DebuggerState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DebuggerState resolve(int value) {
            switch (value) {
            case 0: return RunningState;
            case 1: return SuspendedState;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerWidget-enum">QScriptEngineDebugger::DebuggerWidget</a></code></p>
     */
    @QtUnlistedEnum
    public enum DebuggerWidget implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerWidget-enum">QScriptEngineDebugger::<wbr>ConsoleWidget</a></code></p>
         */
        ConsoleWidget(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerWidget-enum">QScriptEngineDebugger::<wbr>StackWidget</a></code></p>
         */
        StackWidget(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerWidget-enum">QScriptEngineDebugger::<wbr>ScriptsWidget</a></code></p>
         */
        ScriptsWidget(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerWidget-enum">QScriptEngineDebugger::<wbr>LocalsWidget</a></code></p>
         */
        LocalsWidget(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerWidget-enum">QScriptEngineDebugger::<wbr>CodeWidget</a></code></p>
         */
        CodeWidget(4),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerWidget-enum">QScriptEngineDebugger::<wbr>CodeFinderWidget</a></code></p>
         */
        CodeFinderWidget(5),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerWidget-enum">QScriptEngineDebugger::<wbr>BreakpointsWidget</a></code></p>
         */
        BreakpointsWidget(6),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerWidget-enum">QScriptEngineDebugger::<wbr>DebugOutputWidget</a></code></p>
         */
        DebugOutputWidget(7),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#DebuggerWidget-enum">QScriptEngineDebugger::<wbr>ErrorLogWidget</a></code></p>
         */
        ErrorLogWidget(8);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DebuggerWidget(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DebuggerWidget resolve(int value) {
            switch (value) {
            case 0: return ConsoleWidget;
            case 1: return StackWidget;
            case 2: return ScriptsWidget;
            case 3: return LocalsWidget;
            case 4: return CodeWidget;
            case 5: return CodeFinderWidget;
            case 6: return BreakpointsWidget;
            case 7: return DebugOutputWidget;
            case 8: return ErrorLogWidget;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#evaluationResumed">QScriptEngineDebugger::<wbr>evaluationResumed()</a></code></p>
     */
    public final @NonNull Signal0 evaluationResumed = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#evaluationSuspended">QScriptEngineDebugger::<wbr>evaluationSuspended()</a></code></p>
     */
    public final @NonNull Signal0 evaluationSuspended = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QScriptEngineDebugger(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QScriptEngineDebugger() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#QScriptEngineDebugger">QScriptEngineDebugger::<wbr>QScriptEngineDebugger(QObject*)</a></code></p>
     */
    public QScriptEngineDebugger(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QScriptEngineDebugger instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#action">QScriptEngineDebugger::<wbr>action(QScriptEngineDebugger::DebuggerAction)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.widgets.@Nullable QAction action(io.qt.script.tools.QScriptEngineDebugger.@NonNull DebuggerAction action){
        return action_native_QScriptEngineDebugger_DebuggerAction_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), action.value());
    }
    
    @QtUninvokable
    private native io.qt.widgets.QAction action_native_QScriptEngineDebugger_DebuggerAction_constfct(long __this__nativeId, int action);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#attachTo">QScriptEngineDebugger::<wbr>attachTo(QScriptEngine*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void attachTo(io.qt.script.@Nullable QScriptEngine engine){
        attachTo_native_QScriptEngine_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(engine));
    }
    
    @QtUninvokable
    private native void attachTo_native_QScriptEngine_ptr(long __this__nativeId, long engine);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#autoShowStandardWindow">QScriptEngineDebugger::<wbr>autoShowStandardWindow()const</a></code></p>
     */
    @QtUninvokable
    public final boolean autoShowStandardWindow(){
        return autoShowStandardWindow_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoShowStandardWindow_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #createStandardMenu(io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    @QtUninvokable
    public final io.qt.widgets.@Nullable QMenu createStandardMenu() {
        return createStandardMenu((io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#createStandardMenu">QScriptEngineDebugger::<wbr>createStandardMenu(QWidget*)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.widgets.@Nullable QMenu createStandardMenu(io.qt.widgets.@Nullable QWidget parent){
        return createStandardMenu_native_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native io.qt.widgets.QMenu createStandardMenu_native_QWidget_ptr(long __this__nativeId, long parent);
    
    /**
     * <p>Overloaded function for {@link #createStandardToolBar(io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    @QtUninvokable
    public final io.qt.widgets.@Nullable QToolBar createStandardToolBar() {
        return createStandardToolBar((io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#createStandardToolBar">QScriptEngineDebugger::<wbr>createStandardToolBar(QWidget*)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.widgets.@Nullable QToolBar createStandardToolBar(io.qt.widgets.@Nullable QWidget parent){
        return createStandardToolBar_native_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native io.qt.widgets.QToolBar createStandardToolBar_native_QWidget_ptr(long __this__nativeId, long parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#detach">QScriptEngineDebugger::<wbr>detach()</a></code></p>
     */
    @QtUninvokable
    public final void detach(){
        detach_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void detach_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#setAutoShowStandardWindow">QScriptEngineDebugger::<wbr>setAutoShowStandardWindow(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setAutoShowStandardWindow(boolean autoShow){
        setAutoShowStandardWindow_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), autoShow);
    }
    
    @QtUninvokable
    private native void setAutoShowStandardWindow_native_bool(long __this__nativeId, boolean autoShow);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#standardWindow">QScriptEngineDebugger::<wbr>standardWindow()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.widgets.@Nullable QMainWindow standardWindow(){
        return standardWindow_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.widgets.QMainWindow standardWindow_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#state">QScriptEngineDebugger::<wbr>state()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.tools.QScriptEngineDebugger.@NonNull DebuggerState state(){
        return io.qt.script.tools.QScriptEngineDebugger.DebuggerState.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptenginedebugger.html#widget">QScriptEngineDebugger::<wbr>widget(QScriptEngineDebugger::DebuggerWidget)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.widgets.@Nullable QWidget widget(io.qt.script.tools.QScriptEngineDebugger.@NonNull DebuggerWidget widget){
        return widget_native_QScriptEngineDebugger_DebuggerWidget_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), widget.value());
    }
    
    @QtUninvokable
    private native io.qt.widgets.QWidget widget_native_QScriptEngineDebugger_DebuggerWidget_constfct(long __this__nativeId, int widget);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScriptEngineDebugger(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QScriptEngineDebugger(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QScriptEngineDebugger instance, QDeclarativeConstructor constructor);
    
}
