package io.qt.script;


/**
 * <p>Interface to report events pertaining to QScriptEngine execution</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qscriptengineagent.html">QScriptEngineAgent</a></p>
 */
public class QScriptEngineAgent extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptengineagent.html#Extension-enum">QScriptEngineAgent::Extension</a></p>
     */
    public enum Extension implements io.qt.QtEnumerator {
        DebuggerInvocationRequest(0);

        private Extension(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Extension resolve(int value) {
            switch (value) {
            case 0: return DebuggerInvocationRequest;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengineagent.html#QScriptEngineAgent">QScriptEngineAgent::QScriptEngineAgent(QScriptEngine*)</a></p>
     */
    public QScriptEngineAgent(io.qt.script.QScriptEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, engine);
    }
    
    private native static void initialize_native(QScriptEngineAgent instance, io.qt.script.QScriptEngine engine);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengineagent.html#engine">QScriptEngineAgent::engine()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengineagent.html#contextPop">QScriptEngineAgent::contextPop()</a></p>
     */
    @io.qt.QtUninvokable
    public void contextPop(){
        contextPop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void contextPop_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengineagent.html#contextPush">QScriptEngineAgent::contextPush()</a></p>
     */
    @io.qt.QtUninvokable
    public void contextPush(){
        contextPush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void contextPush_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengineagent.html#exceptionCatch">QScriptEngineAgent::exceptionCatch(qint64,QScriptValue)</a></p>
     */
    @io.qt.QtUninvokable
    public void exceptionCatch(long scriptId, io.qt.script.QScriptValue exception){
        exceptionCatch_native_long_long_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), scriptId, QtJambi_LibraryUtilities.internal.checkedNativeId(exception));
    }
    
    @io.qt.QtUninvokable
    private native void exceptionCatch_native_long_long_cref_QScriptValue(long __this__nativeId, long scriptId, long exception);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengineagent.html#exceptionThrow">QScriptEngineAgent::exceptionThrow(qint64,QScriptValue,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public void exceptionThrow(long scriptId, io.qt.script.QScriptValue exception, boolean hasHandler){
        exceptionThrow_native_long_long_cref_QScriptValue_bool(QtJambi_LibraryUtilities.internal.nativeId(this), scriptId, QtJambi_LibraryUtilities.internal.checkedNativeId(exception), hasHandler);
    }
    
    @io.qt.QtUninvokable
    private native void exceptionThrow_native_long_long_cref_QScriptValue_bool(long __this__nativeId, long scriptId, long exception, boolean hasHandler);
    
    /**
     * <p>Overloaded function for {@link #extension(io.qt.script.QScriptEngineAgent.Extension, java.lang.Object)}
     *  with <code>argument = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object extension(io.qt.script.QScriptEngineAgent.Extension extension) {
        return extension(extension, (java.lang.Object)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengineagent.html#extension">QScriptEngineAgent::extension(QScriptEngineAgent::Extension,QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.Object extension(io.qt.script.QScriptEngineAgent.Extension extension, java.lang.Object argument){
        return extension_native_QScriptEngineAgent_Extension_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), extension.value(), argument);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object extension_native_QScriptEngineAgent_Extension_cref_QVariant(long __this__nativeId, int extension, java.lang.Object argument);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengineagent.html#functionEntry">QScriptEngineAgent::functionEntry(qint64)</a></p>
     */
    @io.qt.QtUninvokable
    public void functionEntry(long scriptId){
        functionEntry_native_long_long(QtJambi_LibraryUtilities.internal.nativeId(this), scriptId);
    }
    
    @io.qt.QtUninvokable
    private native void functionEntry_native_long_long(long __this__nativeId, long scriptId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengineagent.html#functionExit">QScriptEngineAgent::functionExit(qint64,QScriptValue)</a></p>
     */
    @io.qt.QtUninvokable
    public void functionExit(long scriptId, io.qt.script.QScriptValue returnValue){
        functionExit_native_long_long_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), scriptId, QtJambi_LibraryUtilities.internal.checkedNativeId(returnValue));
    }
    
    @io.qt.QtUninvokable
    private native void functionExit_native_long_long_cref_QScriptValue(long __this__nativeId, long scriptId, long returnValue);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengineagent.html#positionChange">QScriptEngineAgent::positionChange(qint64,int,int)</a></p>
     */
    @io.qt.QtUninvokable
    public void positionChange(long scriptId, int lineNumber, int columnNumber){
        positionChange_native_long_long_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), scriptId, lineNumber, columnNumber);
    }
    
    @io.qt.QtUninvokable
    private native void positionChange_native_long_long_int_int(long __this__nativeId, long scriptId, int lineNumber, int columnNumber);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengineagent.html#scriptLoad">QScriptEngineAgent::scriptLoad(qint64,QString,QString,int)</a></p>
     */
    @io.qt.QtUninvokable
    public void scriptLoad(long id, java.lang.String program, java.lang.String fileName, int baseLineNumber){
        scriptLoad_native_long_long_cref_QString_cref_QString_int(QtJambi_LibraryUtilities.internal.nativeId(this), id, program, fileName, baseLineNumber);
    }
    
    @io.qt.QtUninvokable
    private native void scriptLoad_native_long_long_cref_QString_cref_QString_int(long __this__nativeId, long id, java.lang.String program, java.lang.String fileName, int baseLineNumber);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengineagent.html#scriptUnload">QScriptEngineAgent::scriptUnload(qint64)</a></p>
     */
    @io.qt.QtUninvokable
    public void scriptUnload(long id){
        scriptUnload_native_long_long(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @io.qt.QtUninvokable
    private native void scriptUnload_native_long_long(long __this__nativeId, long id);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengineagent.html#supportsExtension">QScriptEngineAgent::supportsExtension(QScriptEngineAgent::Extension)const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean supportsExtension(io.qt.script.QScriptEngineAgent.Extension extension){
        return supportsExtension_native_QScriptEngineAgent_Extension_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), extension.value());
    }
    
    @io.qt.QtUninvokable
    private native boolean supportsExtension_native_QScriptEngineAgent_Extension_constfct(long __this__nativeId, int extension);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QScriptEngineAgent(QPrivateConstructor p) { super(p); } 
    
}
