package io.qt.script;

import io.qt.*;


/**
 * <p>The result of a script syntax check</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html">QScriptSyntaxCheckResult</a></code></p>
 * @since This class was introduced in Qt 4.5.
 */
public class QScriptSyntaxCheckResult extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#State-enum">QScriptSyntaxCheckResult::State</a></code></p>
     */
    public enum State implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#State-enum">QScriptSyntaxCheckResult::<wbr/>Error</a></code></p>
         */
        Error(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#State-enum">QScriptSyntaxCheckResult::<wbr/>Intermediate</a></code></p>
         */
        Intermediate(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#State-enum">QScriptSyntaxCheckResult::<wbr/>Valid</a></code></p>
         */
        Valid(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private State(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull State resolve(int value) {
            switch (value) {
            case 0: return Error;
            case 1: return Intermediate;
            case 2: return Valid;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#QScriptSyntaxCheckResult">QScriptSyntaxCheckResult::<wbr/>QScriptSyntaxCheckResult(QScriptSyntaxCheckResult)</a></code></p>
     * @param other
     */
    public QScriptSyntaxCheckResult(io.qt.script.@NonNull QScriptSyntaxCheckResult other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QScriptSyntaxCheckResult instance, io.qt.script.QScriptSyntaxCheckResult other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#errorColumnNumber">QScriptSyntaxCheckResult::<wbr/>errorColumnNumber()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int errorColumnNumber(){
        return errorColumnNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int errorColumnNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#errorLineNumber">QScriptSyntaxCheckResult::<wbr/>errorLineNumber()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int errorLineNumber(){
        return errorLineNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int errorLineNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#errorMessage">QScriptSyntaxCheckResult::<wbr/>errorMessage()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final java.lang.@NonNull String errorMessage(){
        return errorMessage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorMessage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#operator-eq">QScriptSyntaxCheckResult::<wbr/>operator=(QScriptSyntaxCheckResult)</a></code></p>
     * @param other
     */
    @QtUninvokable
    public final void assign(io.qt.script.@NonNull QScriptSyntaxCheckResult other){
        assign_native_cref_QScriptSyntaxCheckResult(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QScriptSyntaxCheckResult(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#state">QScriptSyntaxCheckResult::<wbr/>state()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final io.qt.script.QScriptSyntaxCheckResult.@NonNull State state(){
        return io.qt.script.QScriptSyntaxCheckResult.State.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScriptSyntaxCheckResult(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#QScriptSyntaxCheckResult">QScriptSyntaxCheckResult::<wbr/>QScriptSyntaxCheckResult(QScriptSyntaxCheckResult)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QScriptSyntaxCheckResult clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QScriptSyntaxCheckResult clone_native(long __this_nativeId);
}
