package io.qt.script;

import io.qt.*;


/**
 * <p>Additional information about a QScriptContext</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html">QScriptContextInfo</a></code></p>
 * @since This class was introduced in Qt 4.4.
 */
public class QScriptContextInfo extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#FunctionType-enum">QScriptContextInfo::FunctionType</a></code></p>
     */
    public enum FunctionType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#FunctionType-enum">QScriptContextInfo::<wbr/>ScriptFunction</a></code></p>
         */
        ScriptFunction(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#FunctionType-enum">QScriptContextInfo::<wbr/>QtFunction</a></code></p>
         */
        QtFunction(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#FunctionType-enum">QScriptContextInfo::<wbr/>QtPropertyFunction</a></code></p>
         */
        QtPropertyFunction(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#FunctionType-enum">QScriptContextInfo::<wbr/>NativeFunction</a></code></p>
         */
        NativeFunction(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FunctionType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FunctionType resolve(int value) {
            switch (value) {
            case 0: return ScriptFunction;
            case 1: return QtFunction;
            case 2: return QtPropertyFunction;
            case 3: return NativeFunction;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#QScriptContextInfo-2">QScriptContextInfo::<wbr/>QScriptContextInfo()</a></code></p>
     */
    public QScriptContextInfo(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QScriptContextInfo instance);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#QScriptContextInfo-1">QScriptContextInfo::<wbr/>QScriptContextInfo(QScriptContextInfo)</a></code></p>
     * @param other
     */
    public QScriptContextInfo(io.qt.script.@NonNull QScriptContextInfo other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QScriptContextInfo instance, io.qt.script.QScriptContextInfo other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#QScriptContextInfo">QScriptContextInfo::<wbr/>QScriptContextInfo(const QScriptContext*)</a></code></p>
     * @param context
     */
    public QScriptContextInfo(io.qt.script.@Nullable QScriptContext context){
        super((QPrivateConstructor)null);
        initialize_native(this, context);
    }
    
    private native static void initialize_native(QScriptContextInfo instance, io.qt.script.QScriptContext context);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo-obsolete.html#columnNumber">QScriptContextInfo::<wbr/>columnNumber()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int columnNumber(){
        return columnNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int columnNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#fileName">QScriptContextInfo::<wbr/>fileName()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final java.lang.@NonNull String fileName(){
        return fileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String fileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#functionEndLineNumber">QScriptContextInfo::<wbr/>functionEndLineNumber()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int functionEndLineNumber(){
        return functionEndLineNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int functionEndLineNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#functionMetaIndex">QScriptContextInfo::<wbr/>functionMetaIndex()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int functionMetaIndex(){
        return functionMetaIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int functionMetaIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#functionName">QScriptContextInfo::<wbr/>functionName()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final java.lang.@NonNull String functionName(){
        return functionName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String functionName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#functionParameterNames">QScriptContextInfo::<wbr/>functionParameterNames()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList functionParameterNames(){
        return functionParameterNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList functionParameterNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#functionStartLineNumber">QScriptContextInfo::<wbr/>functionStartLineNumber()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int functionStartLineNumber(){
        return functionStartLineNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int functionStartLineNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#functionType">QScriptContextInfo::<wbr/>functionType()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final io.qt.script.QScriptContextInfo.@NonNull FunctionType functionType(){
        return io.qt.script.QScriptContextInfo.FunctionType.resolve(functionType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int functionType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#isNull">QScriptContextInfo::<wbr/>isNull()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#lineNumber">QScriptContextInfo::<wbr/>lineNumber()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int lineNumber(){
        return lineNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int lineNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#operator-lt-lt">operator&lt;&lt;(QDataStream&amp;,<wbr/>QScriptContextInfo)</a></code></p>
     * @since This function was introduced in Qt 4.4.
     * @param arg__1
     */
    @QtUninvokable
    public void writeTo(io.qt.core.@StrictNonNull QDataStream arg__1){
        java.util.Objects.requireNonNull(arg__1, "Argument 'arg__1': null not expected.");
        writeTo_native_ref_QDataStream(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void writeTo_native_ref_QDataStream(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#operator-eq">QScriptContextInfo::<wbr/>operator=(QScriptContextInfo)</a></code></p>
     * @param other
     */
    @QtUninvokable
    public final void assign(io.qt.script.@NonNull QScriptContextInfo other){
        assign_native_cref_QScriptContextInfo(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QScriptContextInfo(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#operator-eq-eq">QScriptContextInfo::<wbr/>operator==(QScriptContextInfo)const</a></code></p>
     * @param other
     * @return
     */
    @QtUninvokable
    public final boolean equals(io.qt.script.@NonNull QScriptContextInfo other){
        return equals_native_cref_QScriptContextInfo_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QScriptContextInfo_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#operator-gt-gt">operator&gt;&gt;(QDataStream&amp;,<wbr/>QScriptContextInfo&amp;)</a></code></p>
     * @since This function was introduced in Qt 4.4.
     * @param arg__1
     */
    @QtUninvokable
    public void readFrom(io.qt.core.@StrictNonNull QDataStream arg__1){
        java.util.Objects.requireNonNull(arg__1, "Argument 'arg__1': null not expected.");
        readFrom_native_ref_QDataStream(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void readFrom_native_ref_QDataStream(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#scriptId">QScriptContextInfo::<wbr/>scriptId()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final long scriptId(){
        return scriptId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long scriptId_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScriptContextInfo(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#operator-eq-eq">QScriptContextInfo::<wbr/>operator==(QScriptContextInfo)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other==null || other instanceof io.qt.script.QScriptContextInfo) {
            return equals((io.qt.script.QScriptContextInfo) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QScriptContextInfo)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#QScriptContextInfo-1">QScriptContextInfo::<wbr/>QScriptContextInfo(QScriptContextInfo)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QScriptContextInfo clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QScriptContextInfo clone_native(long __this_nativeId);
}
