package io.qt.script;

import io.qt.*;


/**
 * <p>Iterator interface for custom Qt Script objects</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html">QScriptClassPropertyIterator</a></code></p>
 * @since This class was introduced in Qt 4.4.
 */
public abstract class QScriptClassPropertyIterator extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @NativeAccess
    private static final class ConcreteWrapper extends QScriptClassPropertyIterator {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public boolean hasNext(){
            return hasNext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native boolean hasNext_native_constfct(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public boolean hasPrevious(){
            return hasPrevious_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native boolean hasPrevious_native_constfct(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public io.qt.script.@NonNull QScriptString name(){
            return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native io.qt.script.QScriptString name_native_constfct(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void next(){
            next_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void next_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void previous(){
            previous_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void previous_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void toBack(){
            toBack_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void toBack_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void toFront(){
            toFront_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void toFront_native(long __this__nativeId);
        
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#QScriptClassPropertyIterator">QScriptClassPropertyIterator::<wbr/>QScriptClassPropertyIterator(QScriptValue)</a></code></p>
     * @param object
     */
    protected QScriptClassPropertyIterator(io.qt.script.@NonNull QScriptValue object){
        super((QPrivateConstructor)null);
        initialize_native(this, object);
    }
    
    private native static void initialize_native(QScriptClassPropertyIterator instance, io.qt.script.QScriptValue object);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#object">QScriptClassPropertyIterator::<wbr/>object()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue object(){
        return object_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue object_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#flags">QScriptClassPropertyIterator::<wbr/>flags()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public io.qt.script.QScriptValue.@NonNull PropertyFlags flags(){
        return new io.qt.script.QScriptValue.PropertyFlags(flags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int flags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#hasNext">QScriptClassPropertyIterator::<wbr/>hasNext()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public abstract boolean hasNext();
    
    @QtUninvokable
    private native boolean hasNext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#hasPrevious">QScriptClassPropertyIterator::<wbr/>hasPrevious()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public abstract boolean hasPrevious();
    
    @QtUninvokable
    private native boolean hasPrevious_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#id">QScriptClassPropertyIterator::<wbr/>id()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public int id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#name">QScriptClassPropertyIterator::<wbr/>name()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public abstract io.qt.script.@NonNull QScriptString name();
    
    @QtUninvokable
    private native io.qt.script.QScriptString name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#next">QScriptClassPropertyIterator::<wbr/>next()</a></code></p>
     */
    @QtUninvokable
    public abstract void next();
    
    @QtUninvokable
    private native void next_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#previous">QScriptClassPropertyIterator::<wbr/>previous()</a></code></p>
     */
    @QtUninvokable
    public abstract void previous();
    
    @QtUninvokable
    private native void previous_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#toBack">QScriptClassPropertyIterator::<wbr/>toBack()</a></code></p>
     */
    @QtUninvokable
    public abstract void toBack();
    
    @QtUninvokable
    private native void toBack_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#toFront">QScriptClassPropertyIterator::<wbr/>toFront()</a></code></p>
     */
    @QtUninvokable
    public abstract void toFront();
    
    @QtUninvokable
    private native void toFront_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScriptClassPropertyIterator(QPrivateConstructor p) { super(p); } 
    
}
