package io.qt.script;

import io.qt.*;


/**
 * <p>Acts as a container for the Qt Script data types</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html">QScriptValue</a></code></p>
 */
public class QScriptValue extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#PropertyFlag-enum">QScriptValue::PropertyFlag</a></code></p>
     * 
     * @see PropertyFlags
     */
    public enum PropertyFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#PropertyFlag-enum">QScriptValue::<wbr/>ReadOnly</a></code></p>
         */
        ReadOnly(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#PropertyFlag-enum">QScriptValue::<wbr/>Undeletable</a></code></p>
         */
        Undeletable(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#PropertyFlag-enum">QScriptValue::<wbr/>SkipInEnumeration</a></code></p>
         */
        SkipInEnumeration(4),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#PropertyFlag-enum">QScriptValue::<wbr/>PropertyGetter</a></code></p>
         */
        PropertyGetter(8),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#PropertyFlag-enum">QScriptValue::<wbr/>PropertySetter</a></code></p>
         */
        PropertySetter(16),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#PropertyFlag-enum">QScriptValue::<wbr/>QObjectMember</a></code></p>
         */
        QObjectMember(32),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#PropertyFlag-enum">QScriptValue::<wbr/>KeepExistingFlags</a></code></p>
         */
        KeepExistingFlags(2048),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#PropertyFlag-enum">QScriptValue::<wbr/>UserRange</a></code></p>
         */
        UserRange(-16777216);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PropertyFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull PropertyFlags asFlags() {
            return new PropertyFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull PropertyFlags combined(@NonNull PropertyFlag e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull PropertyFlags cleared(@NonNull PropertyFlag e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link PropertyFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull PropertyFlags flags(@Nullable PropertyFlag @NonNull... values) {
            return new PropertyFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PropertyFlag resolve(int value) {
            switch (value) {
            case 1: return ReadOnly;
            case 2: return Undeletable;
            case 4: return SkipInEnumeration;
            case 8: return PropertyGetter;
            case 16: return PropertySetter;
            case 32: return QObjectMember;
            case 2048: return KeepExistingFlags;
            case -16777216: return UserRange;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link PropertyFlag}
     */
    public static final class PropertyFlags extends QFlags<PropertyFlag> implements Comparable<PropertyFlags> {
        private static final long serialVersionUID = 0xc15141a73ea3ed05L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new PropertyFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public PropertyFlags(@Nullable PropertyFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new PropertyFlags with given <code>value</code>.
         * @param value
         */
        public PropertyFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new PropertyFlags
         */
        @Override
        public final @NonNull PropertyFlags combined(@StrictNonNull PropertyFlag e){
            return new PropertyFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull PropertyFlags setFlag(@Nullable PropertyFlag e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull PropertyFlags setFlag(@Nullable PropertyFlag e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this PropertyFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull PropertyFlag @NonNull[] flags(){
            return super.flags(PropertyFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull PropertyFlags clone(){
            return new PropertyFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull PropertyFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#ResolveFlag-enum">QScriptValue::ResolveFlag</a></code></p>
     * 
     * @see ResolveFlags
     */
    public enum ResolveFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#ResolveFlag-enum">QScriptValue::<wbr/>ResolveLocal</a></code></p>
         */
        ResolveLocal(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#ResolveFlag-enum">QScriptValue::<wbr/>ResolvePrototype</a></code></p>
         */
        ResolvePrototype(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#ResolveFlag-enum">QScriptValue::<wbr/>ResolveScope</a></code></p>
         */
        ResolveScope(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#ResolveFlag-enum">QScriptValue::<wbr/>ResolveFull</a></code></p>
         */
        ResolveFull(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ResolveFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull ResolveFlags asFlags() {
            return new ResolveFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ResolveFlags combined(@NonNull ResolveFlag e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ResolveFlags cleared(@NonNull ResolveFlag e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link ResolveFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull ResolveFlags flags(@Nullable ResolveFlag @NonNull... values) {
            return new ResolveFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ResolveFlag resolve(int value) {
            switch (value) {
            case 0: return ResolveLocal;
            case 1: return ResolvePrototype;
            case 2: return ResolveScope;
            case 3: return ResolveFull;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link ResolveFlag}
     */
    public static final class ResolveFlags extends QFlags<ResolveFlag> implements Comparable<ResolveFlags> {
        private static final long serialVersionUID = 0x3cc119ddc5828ef8L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new ResolveFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ResolveFlags(@Nullable ResolveFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new ResolveFlags with given <code>value</code>.
         * @param value
         */
        public ResolveFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ResolveFlags
         */
        @Override
        public final @NonNull ResolveFlags combined(@StrictNonNull ResolveFlag e){
            return new ResolveFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull ResolveFlags setFlag(@Nullable ResolveFlag e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull ResolveFlags setFlag(@Nullable ResolveFlag e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ResolveFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull ResolveFlag @NonNull[] flags(){
            return super.flags(ResolveFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull ResolveFlags clone(){
            return new ResolveFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull ResolveFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#SpecialValue-enum">QScriptValue::SpecialValue</a></code></p>
     */
    public enum SpecialValue implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#SpecialValue-enum">QScriptValue::<wbr/>NullValue</a></code></p>
         */
        NullValue(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#SpecialValue-enum">QScriptValue::<wbr/>UndefinedValue</a></code></p>
         */
        UndefinedValue(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SpecialValue(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull SpecialValue resolve(int value) {
            switch (value) {
            case 0: return NullValue;
            case 1: return UndefinedValue;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue">QScriptValue::<wbr/>QScriptValue()</a></code></p>
     */
    public QScriptValue(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QScriptValue instance);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue-obsolete.html#QScriptValue-2">QScriptValue::<wbr/>QScriptValue(QScriptEngine*,<wbr/>QScriptValue::SpecialValue)</a></code></p>
     */
    public QScriptValue(io.qt.script.@Nullable QScriptEngine engine, io.qt.script.QScriptValue.@NonNull SpecialValue val){
        super((QPrivateConstructor)null);
        initialize_native(this, engine, val);
    }
    
    private native static void initialize_native(QScriptValue instance, io.qt.script.QScriptEngine engine, io.qt.script.QScriptValue.SpecialValue val);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue-obsolete.html#QScriptValue-7">QScriptValue::<wbr/>QScriptValue(QScriptEngine*,<wbr/>QString)</a></code></p>
     */
    public QScriptValue(io.qt.script.@Nullable QScriptEngine engine, java.lang.@NonNull String val){
        super((QPrivateConstructor)null);
        initialize_native(this, engine, val);
    }
    
    private native static void initialize_native(QScriptValue instance, io.qt.script.QScriptEngine engine, java.lang.String val);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue-obsolete.html#QScriptValue-3">QScriptValue::<wbr/>QScriptValue(QScriptEngine*,<wbr/>bool)</a></code></p>
     */
    public QScriptValue(io.qt.script.@Nullable QScriptEngine engine, boolean val){
        super((QPrivateConstructor)null);
        initialize_native(this, engine, val);
    }
    
    private native static void initialize_native(QScriptValue instance, io.qt.script.QScriptEngine engine, boolean val);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue-obsolete.html#QScriptValue-6">QScriptValue::<wbr/>QScriptValue(QScriptEngine*,<wbr/>qsreal)</a></code></p>
     */
    public QScriptValue(io.qt.script.@Nullable QScriptEngine engine, double val){
        super((QPrivateConstructor)null);
        initialize_native(this, engine, val);
    }
    
    private native static void initialize_native(QScriptValue instance, io.qt.script.QScriptEngine engine, double val);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue-obsolete.html#QScriptValue-4">QScriptValue::<wbr/>QScriptValue(QScriptEngine*,<wbr/>int)</a></code></p>
     */
    public QScriptValue(io.qt.script.@Nullable QScriptEngine engine, int val){
        super((QPrivateConstructor)null);
        initialize_native(this, engine, val);
    }
    
    private native static void initialize_native(QScriptValue instance, io.qt.script.QScriptEngine engine, int val);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue-1">QScriptValue::<wbr/>QScriptValue(QScriptValue)</a></code></p>
     */
    public QScriptValue(io.qt.script.@NonNull QScriptValue other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QScriptValue instance, io.qt.script.QScriptValue other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue-9">QScriptValue::<wbr/>QScriptValue(QScriptValue::SpecialValue)</a></code></p>
     */
    public QScriptValue(io.qt.script.QScriptValue.@NonNull SpecialValue value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QScriptValue instance, io.qt.script.QScriptValue.SpecialValue value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue-14">QScriptValue::<wbr/>QScriptValue(QString)</a></code></p>
     */
    public QScriptValue(java.lang.@NonNull String value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QScriptValue instance, java.lang.String value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue-10">QScriptValue::<wbr/>QScriptValue(bool)</a></code></p>
     */
    public QScriptValue(boolean value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QScriptValue instance, boolean value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue-13">QScriptValue::<wbr/>QScriptValue(qsreal)</a></code></p>
     */
    public QScriptValue(double value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QScriptValue instance, double value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue-11">QScriptValue::<wbr/>QScriptValue(int)</a></code></p>
     */
    public QScriptValue(int value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QScriptValue instance, int value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#call">QScriptValue::<wbr/>call(QScriptValue,<wbr/>QScriptValueList)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue call(io.qt.script.@NonNull QScriptValue thisObject, java.util.@Nullable Collection<@NonNull QScriptValue> args){
        return call_native_cref_QScriptValue_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(thisObject), args);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue call_native_cref_QScriptValue_cref_QList(long __this__nativeId, long thisObject, java.util.Collection<@NonNull QScriptValue> args);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#call-1">QScriptValue::<wbr/>call(QScriptValue,<wbr/>QScriptValue)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue call(io.qt.script.@NonNull QScriptValue thisObject, io.qt.script.@NonNull QScriptValue arguments){
        return call_native_cref_QScriptValue_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(thisObject), QtJambi_LibraryUtilities.internal.checkedNativeId(arguments));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue call_native_cref_QScriptValue_cref_QScriptValue(long __this__nativeId, long thisObject, long arguments);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#construct">QScriptValue::<wbr/>construct(QScriptValueList)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue construct(java.util.@Nullable Collection<@NonNull QScriptValue> args){
        return construct_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), args);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue construct_native_cref_QList(long __this__nativeId, java.util.Collection<@NonNull QScriptValue> args);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#construct-1">QScriptValue::<wbr/>construct(QScriptValue)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue construct(io.qt.script.@NonNull QScriptValue arguments){
        return construct_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arguments));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue construct_native_cref_QScriptValue(long __this__nativeId, long arguments);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#data">QScriptValue::<wbr/>data()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue data(){
        return data_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue data_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#engine">QScriptValue::<wbr/>engine()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@Nullable QScriptEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#equals">QScriptValue::<wbr/>equals(QScriptValue)const</a></code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.script.@NonNull QScriptValue other){
        return equals_native_cref_QScriptValue_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QScriptValue_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#instanceOf">QScriptValue::<wbr/>instanceOf(QScriptValue)const</a></code></p>
     */
    @QtUninvokable
    public final boolean instanceOf(io.qt.script.@NonNull QScriptValue other){
        return instanceOf_native_cref_QScriptValue_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean instanceOf_native_cref_QScriptValue_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#isArray">QScriptValue::<wbr/>isArray()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isArray(){
        return isArray_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isArray_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#isBool">QScriptValue::<wbr/>isBool()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isBoolean(){
        return isBoolean_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isBoolean_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#isDate">QScriptValue::<wbr/>isDate()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isDate(){
        return isDate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isDate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#isError">QScriptValue::<wbr/>isError()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isError(){
        return isError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#isFunction">QScriptValue::<wbr/>isFunction()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isFunction(){
        return isFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isFunction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#isNull">QScriptValue::<wbr/>isNull()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#isNumber">QScriptValue::<wbr/>isNumber()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNumber(){
        return isNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#isObject">QScriptValue::<wbr/>isObject()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isObject(){
        return isObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#isQObject">QScriptValue::<wbr/>isQObject()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isQObject(){
        return isQObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isQObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#isRegExp">QScriptValue::<wbr/>isRegExp()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isRegExp(){
        return isRegExp_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isRegExp_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#isString">QScriptValue::<wbr/>isString()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isString(){
        return isString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#isUndefined">QScriptValue::<wbr/>isUndefined()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isUndefined(){
        return isUndefined_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isUndefined_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#isValid">QScriptValue::<wbr/>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#isVariant">QScriptValue::<wbr/>isVariant()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isVariant(){
        return isVariant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isVariant_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#lessThan">QScriptValue::<wbr/>lessThan(QScriptValue)const</a></code></p>
     */
    @QtUninvokable
    public final boolean lessThan(io.qt.script.@NonNull QScriptValue other){
        return lessThan_native_cref_QScriptValue_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean lessThan_native_cref_QScriptValue_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code>QScriptValue::<wbr/>objectId()const</code></p>
     */
    @QtUninvokable
    public final long objectId(){
        return objectId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long objectId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#operator-eq">QScriptValue::<wbr/>operator=(QScriptValue)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.script.@NonNull QScriptValue other){
        assign_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QScriptValue(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#property-2">QScriptValue::<wbr/>property(QScriptString,<wbr/>QScriptValue::ResolveFlags)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue property(io.qt.script.@NonNull QScriptString name, io.qt.script.QScriptValue.@NonNull ResolveFlags mode){
        return property_native_cref_QScriptString_cref_QScriptValue_ResolveFlags_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), mode.value());
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue property_native_cref_QScriptString_cref_QScriptValue_ResolveFlags_constfct(long __this__nativeId, long name, int mode);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#property">QScriptValue::<wbr/>property(QString,<wbr/>QScriptValue::ResolveFlags)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue property(java.lang.@NonNull String name, io.qt.script.QScriptValue.@NonNull ResolveFlags mode){
        return property_native_cref_QString_cref_QScriptValue_ResolveFlags_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name, mode.value());
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue property_native_cref_QString_cref_QScriptValue_ResolveFlags_constfct(long __this__nativeId, java.lang.String name, int mode);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#property-1">QScriptValue::<wbr/>property(quint32,<wbr/>QScriptValue::ResolveFlags)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue property(int arrayIndex, io.qt.script.QScriptValue.@NonNull ResolveFlags mode){
        return property_native_quint32_cref_QScriptValue_ResolveFlags_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arrayIndex, mode.value());
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue property_native_quint32_cref_QScriptValue_ResolveFlags_constfct(long __this__nativeId, int arrayIndex, int mode);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#propertyFlags-1">QScriptValue::<wbr/>propertyFlags(QScriptString,<wbr/>QScriptValue::ResolveFlags)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.QScriptValue.@NonNull PropertyFlags propertyFlags(io.qt.script.@NonNull QScriptString name, io.qt.script.QScriptValue.@NonNull ResolveFlags mode){
        return new io.qt.script.QScriptValue.PropertyFlags(propertyFlags_native_cref_QScriptString_cref_QScriptValue_ResolveFlags_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), mode.value()));
    }
    
    @QtUninvokable
    private native int propertyFlags_native_cref_QScriptString_cref_QScriptValue_ResolveFlags_constfct(long __this__nativeId, long name, int mode);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#propertyFlags">QScriptValue::<wbr/>propertyFlags(QString,<wbr/>QScriptValue::ResolveFlags)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.QScriptValue.@NonNull PropertyFlags propertyFlags(java.lang.@NonNull String name, io.qt.script.QScriptValue.@NonNull ResolveFlags mode){
        return new io.qt.script.QScriptValue.PropertyFlags(propertyFlags_native_cref_QString_cref_QScriptValue_ResolveFlags_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name, mode.value()));
    }
    
    @QtUninvokable
    private native int propertyFlags_native_cref_QString_cref_QScriptValue_ResolveFlags_constfct(long __this__nativeId, java.lang.String name, int mode);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#prototype">QScriptValue::<wbr/>prototype()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue prototype(){
        return prototype_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue prototype_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QScriptValue::<wbr/>scope()const</code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue scope(){
        return scope_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue scope_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#scriptClass">QScriptValue::<wbr/>scriptClass()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@Nullable QScriptClass scriptClass(){
        return scriptClass_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptClass scriptClass_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#setData">QScriptValue::<wbr/>setData(QScriptValue)</a></code></p>
     */
    @QtUninvokable
    public final void setData(io.qt.script.@NonNull QScriptValue data){
        setData_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    @QtUninvokable
    private native void setData_native_cref_QScriptValue(long __this__nativeId, long data);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#setProperty-2">QScriptValue::<wbr/>setProperty(QScriptString,<wbr/>QScriptValue,<wbr/>PropertyFlags)</a></code></p>
     */
    @QtUninvokable
    public final void setProperty(io.qt.script.@NonNull QScriptString name, io.qt.script.@NonNull QScriptValue value, io.qt.script.QScriptValue.@NonNull PropertyFlags flags){
        setProperty_native_cref_QScriptString_cref_QScriptValue_cref_QScriptValue_PropertyFlags(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), QtJambi_LibraryUtilities.internal.checkedNativeId(value), flags.value());
    }
    
    @QtUninvokable
    private native void setProperty_native_cref_QScriptString_cref_QScriptValue_cref_QScriptValue_PropertyFlags(long __this__nativeId, long name, long value, int flags);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#setProperty">QScriptValue::<wbr/>setProperty(QString,<wbr/>QScriptValue,<wbr/>PropertyFlags)</a></code></p>
     */
    @QtUninvokable
    public final void setProperty(java.lang.@NonNull String name, io.qt.script.@NonNull QScriptValue value, io.qt.script.QScriptValue.@NonNull PropertyFlags flags){
        setProperty_native_cref_QString_cref_QScriptValue_cref_QScriptValue_PropertyFlags(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value), flags.value());
    }
    
    @QtUninvokable
    private native void setProperty_native_cref_QString_cref_QScriptValue_cref_QScriptValue_PropertyFlags(long __this__nativeId, java.lang.String name, long value, int flags);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#setProperty-1">QScriptValue::<wbr/>setProperty(quint32,<wbr/>QScriptValue,<wbr/>PropertyFlags)</a></code></p>
     */
    @QtUninvokable
    public final void setProperty(int arrayIndex, io.qt.script.@NonNull QScriptValue value, io.qt.script.QScriptValue.@NonNull PropertyFlags flags){
        setProperty_native_quint32_cref_QScriptValue_cref_QScriptValue_PropertyFlags(QtJambi_LibraryUtilities.internal.nativeId(this), arrayIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(value), flags.value());
    }
    
    @QtUninvokable
    private native void setProperty_native_quint32_cref_QScriptValue_cref_QScriptValue_PropertyFlags(long __this__nativeId, int arrayIndex, long value, int flags);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#setPrototype">QScriptValue::<wbr/>setPrototype(QScriptValue)</a></code></p>
     */
    @QtUninvokable
    public final void setPrototype(io.qt.script.@NonNull QScriptValue prototype){
        setPrototype_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(prototype));
    }
    
    @QtUninvokable
    private native void setPrototype_native_cref_QScriptValue(long __this__nativeId, long prototype);
    
    /**
     * <p>See <code>QScriptValue::<wbr/>setScope(QScriptValue)</code></p>
     */
    @QtUninvokable
    public final void setScope(io.qt.script.@NonNull QScriptValue scope){
        setScope_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scope));
    }
    
    @QtUninvokable
    private native void setScope_native_cref_QScriptValue(long __this__nativeId, long scope);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#setScriptClass">QScriptValue::<wbr/>setScriptClass(QScriptClass*)</a></code></p>
     */
    @QtUninvokable
    public final void setScriptClass(io.qt.script.@Nullable QScriptClass scriptClass){
        setScriptClass_native_QScriptClass_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scriptClass));
    }
    
    @QtUninvokable
    private native void setScriptClass_native_QScriptClass_ptr(long __this__nativeId, long scriptClass);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#strictlyEquals">QScriptValue::<wbr/>strictlyEquals(QScriptValue)const</a></code></p>
     */
    @QtUninvokable
    public final boolean strictlyEquals(io.qt.script.@NonNull QScriptValue other){
        return strictlyEquals_native_cref_QScriptValue_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean strictlyEquals_native_cref_QScriptValue_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#toBool">QScriptValue::<wbr/>toBool()const</a></code></p>
     */
    @QtUninvokable
    public final boolean toBoolean(){
        return toBoolean_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean toBoolean_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#toDateTime">QScriptValue::<wbr/>toDateTime()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QDateTime toDateTime(){
        return toDateTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QDateTime toDateTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#toInt32">QScriptValue::<wbr/>toInt32()const</a></code></p>
     */
    @QtUninvokable
    public final int toInt(){
        return toInt_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int toInt_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#toInteger">QScriptValue::<wbr/>toInteger()const</a></code></p>
     */
    @QtUninvokable
    private final double private_toInteger(){
        return private_toInteger_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double private_toInteger_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#toNumber">QScriptValue::<wbr/>toNumber()const</a></code></p>
     */
    @QtUninvokable
    public final double toDouble(){
        return toDouble_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double toDouble_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#toQObject">QScriptValue::<wbr/>toQObject()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QObject toQObject(){
        return toQObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QObject toQObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#toRegExp">QScriptValue::<wbr/>toRegExp()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp toRegExp(){
        return toRegExp_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegExp toRegExp_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#toString">QScriptValue::<wbr/>toString()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String toString(){
        return toString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String toString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#toUInt16">QScriptValue::<wbr/>toUInt16()const</a></code></p>
     */
    @QtUninvokable
    public final short toShort(){
        return toShort_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native short toShort_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#toVariant">QScriptValue::<wbr/>toVariant()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object toVariant(){
        return toVariant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Object toVariant_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScriptValue(QPrivateConstructor p) { super(p); } 
    
    @QtUninvokable
    public final Integer toInteger() {
        if(Double.isNaN(private_toInteger())){
            return null;
        }else{
            return toInt();
        }
    }
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue-1">QScriptValue::<wbr/>QScriptValue(QScriptValue)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QScriptValue clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QScriptValue clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded function for {@link #call(io.qt.script.QScriptValue, java.util.Collection)}
     *  with <code>args = new java.util.ArrayList&lt;&gt;()</code>.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue call(io.qt.script.@NonNull QScriptValue thisObject) {
        return call(thisObject, new java.util.ArrayList<>());
    }
    
    /**
     * <p>Overloaded function for {@link #call(io.qt.script.QScriptValue, java.util.Collection)}</p>
     * <p>with: </p><ul>
     * <li><code>thisObject = new io.qt.script.QScriptValue()</code></li>
     * <li><code>args = new java.util.ArrayList&lt;&gt;()</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue call() {
        return call(new io.qt.script.QScriptValue(), new java.util.ArrayList<>());
    }
    
    /**
     * <p>Overloaded function for {@link #construct(java.util.Collection)}
     *  with <code>args = new java.util.ArrayList&lt;&gt;()</code>.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue construct() {
        return construct(new java.util.ArrayList<>());
    }
    
    /**
     * <p>Overloaded function for {@link #property(io.qt.script.QScriptString, io.qt.script.QScriptValue.ResolveFlags)}
     *  with <code>mode = new io.qt.script.QScriptValue.ResolveFlags(1)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue property(io.qt.script.@NonNull QScriptString name) {
        return property(name, new io.qt.script.QScriptValue.ResolveFlags(1));
    }
    
    /**
     * <p>Overloaded function for {@link #property(io.qt.script.QScriptString, io.qt.script.QScriptValue.ResolveFlags)}.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue property(io.qt.script.@NonNull QScriptString name, io.qt.script.QScriptValue.@NonNull ResolveFlag @NonNull... mode) {
        return property(name, new io.qt.script.QScriptValue.ResolveFlags(mode));
    }
    
    /**
     * <p>Overloaded function for {@link #property(java.lang.String, io.qt.script.QScriptValue.ResolveFlags)}
     *  with <code>mode = new io.qt.script.QScriptValue.ResolveFlags(1)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue property(java.lang.@NonNull String name) {
        return property(name, new io.qt.script.QScriptValue.ResolveFlags(1));
    }
    
    /**
     * <p>Overloaded function for {@link #property(java.lang.String, io.qt.script.QScriptValue.ResolveFlags)}.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue property(java.lang.@NonNull String name, io.qt.script.QScriptValue.@NonNull ResolveFlag @NonNull... mode) {
        return property(name, new io.qt.script.QScriptValue.ResolveFlags(mode));
    }
    
    /**
     * <p>Overloaded function for {@link #property(int, io.qt.script.QScriptValue.ResolveFlags)}
     *  with <code>mode = new io.qt.script.QScriptValue.ResolveFlags(1)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue property(int arrayIndex) {
        return property(arrayIndex, new io.qt.script.QScriptValue.ResolveFlags(1));
    }
    
    /**
     * <p>Overloaded function for {@link #property(int, io.qt.script.QScriptValue.ResolveFlags)}.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue property(int arrayIndex, io.qt.script.QScriptValue.@NonNull ResolveFlag @NonNull... mode) {
        return property(arrayIndex, new io.qt.script.QScriptValue.ResolveFlags(mode));
    }
    
    /**
     * <p>Overloaded function for {@link #propertyFlags(io.qt.script.QScriptString, io.qt.script.QScriptValue.ResolveFlags)}
     *  with <code>mode = new io.qt.script.QScriptValue.ResolveFlags(1)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.script.QScriptValue.@NonNull PropertyFlags propertyFlags(io.qt.script.@NonNull QScriptString name) {
        return propertyFlags(name, new io.qt.script.QScriptValue.ResolveFlags(1));
    }
    
    /**
     * <p>Overloaded function for {@link #propertyFlags(io.qt.script.QScriptString, io.qt.script.QScriptValue.ResolveFlags)}.</p>
     */
    @QtUninvokable
    public final io.qt.script.QScriptValue.@NonNull PropertyFlags propertyFlags(io.qt.script.@NonNull QScriptString name, io.qt.script.QScriptValue.@NonNull ResolveFlag @NonNull... mode) {
        return propertyFlags(name, new io.qt.script.QScriptValue.ResolveFlags(mode));
    }
    
    /**
     * <p>Overloaded function for {@link #propertyFlags(java.lang.String, io.qt.script.QScriptValue.ResolveFlags)}
     *  with <code>mode = new io.qt.script.QScriptValue.ResolveFlags(1)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.script.QScriptValue.@NonNull PropertyFlags propertyFlags(java.lang.@NonNull String name) {
        return propertyFlags(name, new io.qt.script.QScriptValue.ResolveFlags(1));
    }
    
    /**
     * <p>Overloaded function for {@link #propertyFlags(java.lang.String, io.qt.script.QScriptValue.ResolveFlags)}.</p>
     */
    @QtUninvokable
    public final io.qt.script.QScriptValue.@NonNull PropertyFlags propertyFlags(java.lang.@NonNull String name, io.qt.script.QScriptValue.@NonNull ResolveFlag @NonNull... mode) {
        return propertyFlags(name, new io.qt.script.QScriptValue.ResolveFlags(mode));
    }
    
    /**
     * <p>Overloaded function for {@link #setProperty(io.qt.script.QScriptString, io.qt.script.QScriptValue, io.qt.script.QScriptValue.PropertyFlags)}
     *  with <code>flags = new io.qt.script.QScriptValue.PropertyFlags(2048)</code>.</p>
     */
    @QtUninvokable
    public final void setProperty(io.qt.script.@NonNull QScriptString name, io.qt.script.@NonNull QScriptValue value) {
        setProperty(name, value, new io.qt.script.QScriptValue.PropertyFlags(2048));
    }
    
    /**
     * <p>Overloaded function for {@link #setProperty(io.qt.script.QScriptString, io.qt.script.QScriptValue, io.qt.script.QScriptValue.PropertyFlags)}.</p>
     */
    @QtUninvokable
    public final void setProperty(io.qt.script.@NonNull QScriptString name, io.qt.script.@NonNull QScriptValue value, io.qt.script.QScriptValue.@NonNull PropertyFlag @NonNull... flags) {
        setProperty(name, value, new io.qt.script.QScriptValue.PropertyFlags(flags));
    }
    
    /**
     * <p>Overloaded function for {@link #setProperty(java.lang.String, io.qt.script.QScriptValue, io.qt.script.QScriptValue.PropertyFlags)}
     *  with <code>flags = new io.qt.script.QScriptValue.PropertyFlags(2048)</code>.</p>
     */
    @QtUninvokable
    public final void setProperty(java.lang.@NonNull String name, io.qt.script.@NonNull QScriptValue value) {
        setProperty(name, value, new io.qt.script.QScriptValue.PropertyFlags(2048));
    }
    
    /**
     * <p>Overloaded function for {@link #setProperty(java.lang.String, io.qt.script.QScriptValue, io.qt.script.QScriptValue.PropertyFlags)}.</p>
     */
    @QtUninvokable
    public final void setProperty(java.lang.@NonNull String name, io.qt.script.@NonNull QScriptValue value, io.qt.script.QScriptValue.@NonNull PropertyFlag @NonNull... flags) {
        setProperty(name, value, new io.qt.script.QScriptValue.PropertyFlags(flags));
    }
    
    /**
     * <p>Overloaded function for {@link #setProperty(int, io.qt.script.QScriptValue, io.qt.script.QScriptValue.PropertyFlags)}
     *  with <code>flags = new io.qt.script.QScriptValue.PropertyFlags(2048)</code>.</p>
     */
    @QtUninvokable
    public final void setProperty(int arrayIndex, io.qt.script.@NonNull QScriptValue value) {
        setProperty(arrayIndex, value, new io.qt.script.QScriptValue.PropertyFlags(2048));
    }
    
    /**
     * <p>Overloaded function for {@link #setProperty(int, io.qt.script.QScriptValue, io.qt.script.QScriptValue.PropertyFlags)}.</p>
     */
    @QtUninvokable
    public final void setProperty(int arrayIndex, io.qt.script.@NonNull QScriptValue value, io.qt.script.QScriptValue.@NonNull PropertyFlag @NonNull... flags) {
        setProperty(arrayIndex, value, new io.qt.script.QScriptValue.PropertyFlags(flags));
    }
}
