package io.qt.script;

import io.qt.*;


/**
 * <p>Access to the Qt Script environment from Qt C++ member functions</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qscriptable.html">QScriptable</a></code></p>
 */
public interface QScriptable extends QtObjectInterface
{
    /**
     * @hidden
     * <p>Implementor class for interface {@link io.qt.script.QScriptable}</p>
     */
    public static class Impl extends QtObject
        implements io.qt.script.QScriptable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <code>QScriptable::<wbr/>QScriptable()</code></p>
         */
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QScriptable instance);
        
        /**
         * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptable.html#argument">QScriptable::<wbr/>argument(int)const</a></code></p>
         */
        @QtUninvokable
        public final io.qt.script.@NonNull QScriptValue argument(int index){
            return argument_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
        }
        
        private native static io.qt.script.QScriptValue argument_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptable.html#argumentCount">QScriptable::<wbr/>argumentCount()const</a></code></p>
         */
        @QtUninvokable
        public final int argumentCount(){
            return argumentCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static int argumentCount_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptable.html#context">QScriptable::<wbr/>context()const</a></code></p>
         */
        @QtUninvokable
        public final io.qt.script.@Nullable QScriptContext context(){
            return context_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.script.QScriptContext context_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptable.html#engine">QScriptable::<wbr/>engine()const</a></code></p>
         */
        @QtUninvokable
        public final io.qt.script.@Nullable QScriptEngine engine(){
            return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.script.QScriptEngine engine_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptable.html#thisObject">QScriptable::<wbr/>thisObject()const</a></code></p>
         */
        @QtUninvokable
        public final io.qt.script.@NonNull QScriptValue thisObject(){
            return thisObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.script.QScriptValue thisObject_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptable.html#argument">QScriptable::<wbr/>argument(int)const</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default io.qt.script.@NonNull QScriptValue argument(int index){
        return Impl.argument_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptable.html#argumentCount">QScriptable::<wbr/>argumentCount()const</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default int argumentCount(){
        return Impl.argumentCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptable.html#context">QScriptable::<wbr/>context()const</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default io.qt.script.@Nullable QScriptContext context(){
        return Impl.context_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptable.html#engine">QScriptable::<wbr/>engine()const</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default io.qt.script.@Nullable QScriptEngine engine(){
        return Impl.engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptable.html#thisObject">QScriptable::<wbr/>thisObject()const</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default io.qt.script.@NonNull QScriptValue thisObject(){
        return Impl.thisObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
}
