package io.qt.script;

import io.qt.*;


/**
 * <p>Acts as a handle to "interned" strings in a QScriptEngine</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qscriptstring.html">QScriptString</a></code></p>
 */
public class QScriptString extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptstring.html#QScriptString">QScriptString::<wbr>QScriptString()</a></code></p>
     */
    public QScriptString(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QScriptString instance);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptstring.html#QScriptString-1">QScriptString::<wbr>QScriptString(QScriptString)</a></code></p>
     */
    public QScriptString(io.qt.script.@NonNull QScriptString other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QScriptString instance, io.qt.script.QScriptString other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptstring.html#isValid">QScriptString::<wbr>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptstring.html#operator-eq">QScriptString::<wbr>operator=(QScriptString)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.script.@NonNull QScriptString other){
        assign_native_cref_QScriptString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QScriptString(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptstring.html#operator-eq-eq">QScriptString::<wbr>operator==(QScriptString)const</a></code></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.script.@NonNull QScriptString other){
        return operator_equal_native_cref_QScriptString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QScriptString_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptstring.html#toArrayIndex">QScriptString::<wbr>toArrayIndex(bool*)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Integer toArrayIndex(){
        return toArrayIndex_native_bool_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Integer toArrayIndex_native_bool_ptr_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptstring.html#toString">QScriptString::<wbr>toString()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String toString(){
        return toString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String toString_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScriptString(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptstring.html#operator-eq-eq">QScriptString::<wbr>operator==(QScriptString)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.script.QScriptString) {
            return operator_equal((io.qt.script.QScriptString) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QScriptString)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QScriptString clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QScriptString clone_native(long __this_nativeId);
}
