package io.qt.script;

import io.qt.*;


/**
 * <p>Encapsulates a Qt Script program</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qscriptprogram.html">QScriptProgram</a></code></p>
 */
public class QScriptProgram extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptprogram.html#QScriptProgram">QScriptProgram::<wbr>QScriptProgram()</a></code></p>
     */
    public QScriptProgram(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QScriptProgram instance);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptprogram.html#QScriptProgram-2">QScriptProgram::<wbr>QScriptProgram(QScriptProgram)</a></code></p>
     */
    public QScriptProgram(io.qt.script.@NonNull QScriptProgram other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QScriptProgram instance, io.qt.script.QScriptProgram other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptprogram.html#QScriptProgram-1">QScriptProgram::<wbr>QScriptProgram(QString,<wbr>QString,<wbr>int)</a></code></p>
     */
    public QScriptProgram(java.lang.@NonNull String sourceCode, java.lang.@NonNull String fileName, int firstLineNumber){
        super((QPrivateConstructor)null);
        initialize_native(this, sourceCode, fileName, firstLineNumber);
    }
    
    private native static void initialize_native(QScriptProgram instance, java.lang.String sourceCode, java.lang.String fileName, int firstLineNumber);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptprogram.html#fileName">QScriptProgram::<wbr>fileName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String fileName(){
        return fileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String fileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptprogram.html#firstLineNumber">QScriptProgram::<wbr>firstLineNumber()const</a></code></p>
     */
    @QtUninvokable
    public final int firstLineNumber(){
        return firstLineNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int firstLineNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptprogram.html#isNull">QScriptProgram::<wbr>isNull()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptprogram.html#operator-eq">QScriptProgram::<wbr>operator=(QScriptProgram)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.script.@NonNull QScriptProgram other){
        assign_native_cref_QScriptProgram(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QScriptProgram(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptprogram.html#operator-eq-eq">QScriptProgram::<wbr>operator==(QScriptProgram)const</a></code></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.script.@NonNull QScriptProgram other){
        return operator_equal_native_cref_QScriptProgram_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QScriptProgram_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptprogram.html#sourceCode">QScriptProgram::<wbr>sourceCode()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String sourceCode(){
        return sourceCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String sourceCode_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScriptProgram(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptprogram.html#operator-eq-eq">QScriptProgram::<wbr>operator==(QScriptProgram)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.script.QScriptProgram) {
            return operator_equal((io.qt.script.QScriptProgram) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QScriptProgram)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QScriptProgram clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QScriptProgram clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded constructor for {@link #QScriptProgram(java.lang.String, java.lang.String, int)}
     *  with <code>firstLineNumber = 1</code>.</p>
     */
    public QScriptProgram(java.lang.@NonNull String sourceCode, java.lang.@NonNull String fileName) {
        this(sourceCode, fileName, (int)1);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QScriptProgram(java.lang.String, java.lang.String, int)}</p>
     * <p>with: </p><ul>
     * <li><code>fileName = (String)null</code></li>
     * <li><code>firstLineNumber = 1</code></li>
     * </ul>
     */
    public QScriptProgram(java.lang.@NonNull String sourceCode) {
        this(sourceCode, (String)null, (int)1);
    }
}
