package io.qt.script;

import io.qt.*;


/**
 * <p>Interface for defining custom behavior of (a class of) Qt Script objects</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qscriptclass.html">QScriptClass</a></code></p>
 */
public class QScriptClass extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#Extension-enum">QScriptClass::Extension</a></code></p>
     */
    public enum Extension implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#Extension-enum">QScriptClass::<wbr>Callable</a></code></p>
         */
        Callable(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#Extension-enum">QScriptClass::<wbr>HasInstance</a></code></p>
         */
        HasInstance(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Extension(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Extension resolve(int value) {
            switch (value) {
            case 0: return Callable;
            case 1: return HasInstance;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#QueryFlag-enum">QScriptClass::QueryFlag</a></code></p>
     * 
     * @see QueryFlags
     */
    public enum QueryFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#QueryFlag-enum">QScriptClass::<wbr>HandlesReadAccess</a></code></p>
         */
        HandlesReadAccess(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#QueryFlag-enum">QScriptClass::<wbr>HandlesWriteAccess</a></code></p>
         */
        HandlesWriteAccess(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private QueryFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull QueryFlags asFlags() {
            return new QueryFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull QueryFlags combined(@NonNull QueryFlag e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull QueryFlags cleared(@NonNull QueryFlag e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link QueryFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull QueryFlags flags(@Nullable QueryFlag @NonNull... values) {
            return new QueryFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull QueryFlag resolve(int value) {
            switch (value) {
            case 1: return HandlesReadAccess;
            case 2: return HandlesWriteAccess;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link QueryFlag}
     */
    public static final class QueryFlags extends QFlags<QueryFlag> implements Comparable<QueryFlags> {
        private static final long serialVersionUID = 0x11b03667a4066df4L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new QueryFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public QueryFlags(@Nullable QueryFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new QueryFlags with given <code>value</code>.
         * @param value
         */
        public QueryFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new QueryFlags
         */
        @Override
        public final @NonNull QueryFlags combined(@StrictNonNull QueryFlag e){
            return new QueryFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull QueryFlags setFlag(@Nullable QueryFlag e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull QueryFlags setFlag(@Nullable QueryFlag e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this QueryFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull QueryFlag @NonNull[] flags(){
            return super.flags(QueryFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull QueryFlags clone(){
            return new QueryFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull QueryFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#QScriptClass">QScriptClass::<wbr>QScriptClass(QScriptEngine*)</a></code></p>
     */
    public QScriptClass(io.qt.script.@Nullable QScriptEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, engine);
    }
    
    private native static void initialize_native(QScriptClass instance, io.qt.script.QScriptEngine engine);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#engine">QScriptClass::<wbr>engine()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@Nullable QScriptEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#extension">QScriptClass::<wbr>extension(QScriptClass::Extension,<wbr>QVariant)</a></code></p>
     */
    @QtUninvokable
    public java.lang.Object extension(io.qt.script.QScriptClass.@NonNull Extension extension, java.lang.Object argument){
        return extension_native_QScriptClass_Extension_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), extension.value(), argument);
    }
    
    @QtUninvokable
    private native java.lang.Object extension_native_QScriptClass_Extension_cref_QVariant(long __this__nativeId, int extension, java.lang.Object argument);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#name">QScriptClass::<wbr>name()const</a></code></p>
     */
    @QtUninvokable
    public java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#newIterator">QScriptClass::<wbr>newIterator(QScriptValue)</a></code></p>
     */
    @QtUninvokable
    public io.qt.script.@NonNull QScriptClassPropertyIterator newIterator(io.qt.script.@NonNull QScriptValue object){
        return newIterator_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object));
    }
    
    @QtUninvokable
    private native io.qt.script.@NonNull QScriptClassPropertyIterator newIterator_native_cref_QScriptValue(long __this__nativeId, long object);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#property">QScriptClass::<wbr>property(QScriptValue,<wbr>QScriptString,<wbr>uint)</a></code></p>
     */
    @QtUninvokable
    public io.qt.script.@NonNull QScriptValue property(io.qt.script.@NonNull QScriptValue object, io.qt.script.@NonNull QScriptString name, int id){
        return property_native_cref_QScriptValue_cref_QScriptString_uint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), QtJambi_LibraryUtilities.internal.checkedNativeId(name), id);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue property_native_cref_QScriptValue_cref_QScriptString_uint(long __this__nativeId, long object, long name, int id);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#propertyFlags">QScriptClass::<wbr>propertyFlags(QScriptValue,<wbr>QScriptString,<wbr>uint)</a></code></p>
     */
    @QtUninvokable
    public io.qt.script.QScriptValue.@NonNull PropertyFlags propertyFlags(io.qt.script.@NonNull QScriptValue object, io.qt.script.@NonNull QScriptString name, int id){
        return new io.qt.script.QScriptValue.PropertyFlags(propertyFlags_native_cref_QScriptValue_cref_QScriptString_uint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), QtJambi_LibraryUtilities.internal.checkedNativeId(name), id));
    }
    
    @QtUninvokable
    private native int propertyFlags_native_cref_QScriptValue_cref_QScriptString_uint(long __this__nativeId, long object, long name, int id);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#prototype">QScriptClass::<wbr>prototype()const</a></code></p>
     */
    @QtUninvokable
    public io.qt.script.@NonNull QScriptValue prototype(){
        return prototype_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue prototype_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#queryProperty">QScriptClass::<wbr>queryProperty(QScriptValue,<wbr>QScriptString,<wbr>QScriptClass::QueryFlags,<wbr>uint*)</a></code></p>
     */
    @QtUninvokable
    public io.qt.script.QScriptClass.@NonNull QueryFlags queryProperty(io.qt.script.@NonNull QScriptValue object, io.qt.script.@NonNull QScriptString name, io.qt.script.QScriptClass.@NonNull QueryFlags flags, java.lang.@Nullable Integer id){
        return new io.qt.script.QScriptClass.QueryFlags(queryProperty_native_cref_QScriptValue_cref_QScriptString_QScriptClass_QueryFlags_uint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), QtJambi_LibraryUtilities.internal.checkedNativeId(name), flags.value(), id));
    }
    
    @QtUninvokable
    private native int queryProperty_native_cref_QScriptValue_cref_QScriptString_QScriptClass_QueryFlags_uint_ptr(long __this__nativeId, long object, long name, int flags, java.lang.Integer id);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#setProperty">QScriptClass::<wbr>setProperty(QScriptValue&amp;,<wbr>QScriptString,<wbr>uint,<wbr>QScriptValue)</a></code></p>
     */
    @QtUninvokable
    public void setProperty(io.qt.script.@StrictNonNull QScriptValue object, io.qt.script.@NonNull QScriptString name, int id, io.qt.script.@NonNull QScriptValue value){
        java.util.Objects.requireNonNull(object, "Argument 'object': null not expected.");
        setProperty_native_ref_QScriptValue_cref_QScriptString_uint_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), QtJambi_LibraryUtilities.internal.checkedNativeId(name), id, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setProperty_native_ref_QScriptValue_cref_QScriptString_uint_cref_QScriptValue(long __this__nativeId, long object, long name, int id, long value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptclass.html#supportsExtension">QScriptClass::<wbr>supportsExtension(QScriptClass::Extension)const</a></code></p>
     */
    @QtUninvokable
    public boolean supportsExtension(io.qt.script.QScriptClass.@NonNull Extension extension){
        return supportsExtension_native_QScriptClass_Extension_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), extension.value());
    }
    
    @QtUninvokable
    private native boolean supportsExtension_native_QScriptClass_Extension_constfct(long __this__nativeId, int extension);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScriptClass(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded function for {@link #extension(io.qt.script.QScriptClass.Extension, java.lang.Object)}
     *  with <code>argument = null</code>.</p>
     */
    @QtUninvokable
    public final java.lang.Object extension(io.qt.script.QScriptClass.@NonNull Extension extension) {
        return extension(extension, (java.lang.Object)null);
    }
}
