package io.qt.script;

import io.qt.*;


/**
 * <p>Interface to report events pertaining to QScriptEngine execution</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html">QScriptEngineAgent</a></code></p>
 */
public class QScriptEngineAgent extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#Extension-enum">QScriptEngineAgent::Extension</a></code></p>
     */
    public enum Extension implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#Extension-enum">QScriptEngineAgent::<wbr>DebuggerInvocationRequest</a></code></p>
         */
        DebuggerInvocationRequest(0);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Extension(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Extension resolve(int value) {
            switch (value) {
            case 0: return DebuggerInvocationRequest;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#QScriptEngineAgent">QScriptEngineAgent::<wbr>QScriptEngineAgent(QScriptEngine*)</a></code></p>
     */
    public QScriptEngineAgent(io.qt.script.@Nullable QScriptEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, engine);
    }
    
    private native static void initialize_native(QScriptEngineAgent instance, io.qt.script.QScriptEngine engine);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#engine">QScriptEngineAgent::<wbr>engine()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@Nullable QScriptEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#contextPop">QScriptEngineAgent::<wbr>contextPop()</a></code></p>
     */
    @QtUninvokable
    public void contextPop(){
        contextPop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void contextPop_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#contextPush">QScriptEngineAgent::<wbr>contextPush()</a></code></p>
     */
    @QtUninvokable
    public void contextPush(){
        contextPush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void contextPush_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#exceptionCatch">QScriptEngineAgent::<wbr>exceptionCatch(qint64,<wbr>QScriptValue)</a></code></p>
     */
    @QtUninvokable
    public void exceptionCatch(long scriptId, io.qt.script.@NonNull QScriptValue exception){
        exceptionCatch_native_qint64_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), scriptId, QtJambi_LibraryUtilities.internal.checkedNativeId(exception));
    }
    
    @QtUninvokable
    private native void exceptionCatch_native_qint64_cref_QScriptValue(long __this__nativeId, long scriptId, long exception);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#exceptionThrow">QScriptEngineAgent::<wbr>exceptionThrow(qint64,<wbr>QScriptValue,<wbr>bool)</a></code></p>
     */
    @QtUninvokable
    public void exceptionThrow(long scriptId, io.qt.script.@NonNull QScriptValue exception, boolean hasHandler){
        exceptionThrow_native_qint64_cref_QScriptValue_bool(QtJambi_LibraryUtilities.internal.nativeId(this), scriptId, QtJambi_LibraryUtilities.internal.checkedNativeId(exception), hasHandler);
    }
    
    @QtUninvokable
    private native void exceptionThrow_native_qint64_cref_QScriptValue_bool(long __this__nativeId, long scriptId, long exception, boolean hasHandler);
    
    /**
     * <p>Overloaded function for {@link #extension(io.qt.script.QScriptEngineAgent.Extension, java.lang.Object)}
     *  with <code>argument = null</code>.</p>
     */
    @QtUninvokable
    public final java.lang.Object extension(io.qt.script.QScriptEngineAgent.@NonNull Extension extension) {
        return extension(extension, (java.lang.Object)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#extension">QScriptEngineAgent::<wbr>extension(QScriptEngineAgent::Extension,<wbr>QVariant)</a></code></p>
     */
    @QtUninvokable
    public java.lang.Object extension(io.qt.script.QScriptEngineAgent.@NonNull Extension extension, java.lang.Object argument){
        return extension_native_QScriptEngineAgent_Extension_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), extension.value(), argument);
    }
    
    @QtUninvokable
    private native java.lang.Object extension_native_QScriptEngineAgent_Extension_cref_QVariant(long __this__nativeId, int extension, java.lang.Object argument);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#functionEntry">QScriptEngineAgent::<wbr>functionEntry(qint64)</a></code></p>
     */
    @QtUninvokable
    public void functionEntry(long scriptId){
        functionEntry_native_qint64(QtJambi_LibraryUtilities.internal.nativeId(this), scriptId);
    }
    
    @QtUninvokable
    private native void functionEntry_native_qint64(long __this__nativeId, long scriptId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#functionExit">QScriptEngineAgent::<wbr>functionExit(qint64,<wbr>QScriptValue)</a></code></p>
     */
    @QtUninvokable
    public void functionExit(long scriptId, io.qt.script.@NonNull QScriptValue returnValue){
        functionExit_native_qint64_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), scriptId, QtJambi_LibraryUtilities.internal.checkedNativeId(returnValue));
    }
    
    @QtUninvokable
    private native void functionExit_native_qint64_cref_QScriptValue(long __this__nativeId, long scriptId, long returnValue);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#positionChange">QScriptEngineAgent::<wbr>positionChange(qint64,<wbr>int,<wbr>int)</a></code></p>
     */
    @QtUninvokable
    public void positionChange(long scriptId, int lineNumber, int columnNumber){
        positionChange_native_qint64_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), scriptId, lineNumber, columnNumber);
    }
    
    @QtUninvokable
    private native void positionChange_native_qint64_int_int(long __this__nativeId, long scriptId, int lineNumber, int columnNumber);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#scriptLoad">QScriptEngineAgent::<wbr>scriptLoad(qint64,<wbr>QString,<wbr>QString,<wbr>int)</a></code></p>
     */
    @QtUninvokable
    public void scriptLoad(long id, java.lang.@NonNull String program, java.lang.@NonNull String fileName, int baseLineNumber){
        scriptLoad_native_qint64_cref_QString_cref_QString_int(QtJambi_LibraryUtilities.internal.nativeId(this), id, program, fileName, baseLineNumber);
    }
    
    @QtUninvokable
    private native void scriptLoad_native_qint64_cref_QString_cref_QString_int(long __this__nativeId, long id, java.lang.String program, java.lang.String fileName, int baseLineNumber);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#scriptUnload">QScriptEngineAgent::<wbr>scriptUnload(qint64)</a></code></p>
     */
    @QtUninvokable
    public void scriptUnload(long id){
        scriptUnload_native_qint64(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native void scriptUnload_native_qint64(long __this__nativeId, long id);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptengineagent.html#supportsExtension">QScriptEngineAgent::<wbr>supportsExtension(QScriptEngineAgent::Extension)const</a></code></p>
     */
    @QtUninvokable
    public boolean supportsExtension(io.qt.script.QScriptEngineAgent.@NonNull Extension extension){
        return supportsExtension_native_QScriptEngineAgent_Extension_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), extension.value());
    }
    
    @QtUninvokable
    private native boolean supportsExtension_native_QScriptEngineAgent_Extension_constfct(long __this__nativeId, int extension);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScriptEngineAgent(QPrivateConstructor p) { super(p); } 
    
}
