package io.qt.script;

import io.qt.*;


/**
 * <p>Represents a Qt Script function invocation</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html">QScriptContext</a></code></p>
 */
public final class QScriptContext extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::Error</a></code></p>
     */
    public enum Error implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::<wbr>UnknownError</a></code></p>
         */
        UnknownError(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::<wbr>ReferenceError</a></code></p>
         */
        ReferenceError(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::<wbr>SyntaxError</a></code></p>
         */
        SyntaxError(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::<wbr>TypeError</a></code></p>
         */
        TypeError(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::<wbr>RangeError</a></code></p>
         */
        RangeError(4),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::<wbr>URIError</a></code></p>
         */
        URIError(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Error resolve(int value) {
            switch (value) {
            case 0: return UnknownError;
            case 1: return ReferenceError;
            case 2: return SyntaxError;
            case 3: return TypeError;
            case 4: return RangeError;
            case 5: return URIError;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#ExecutionState-enum">QScriptContext::ExecutionState</a></code></p>
     */
    public enum ExecutionState implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#ExecutionState-enum">QScriptContext::<wbr>NormalState</a></code></p>
         */
        NormalState(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#ExecutionState-enum">QScriptContext::<wbr>ExceptionState</a></code></p>
         */
        ExceptionState(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ExecutionState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ExecutionState resolve(int value) {
            switch (value) {
            case 0: return NormalState;
            case 1: return ExceptionState;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#activationObject">QScriptContext::<wbr>activationObject()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue activationObject(){
        return activationObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue activationObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#argument">QScriptContext::<wbr>argument(int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue argument(int index){
        return argument_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue argument_native_int_constfct(long __this__nativeId, int index);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#argumentCount">QScriptContext::<wbr>argumentCount()const</a></code></p>
     */
    @QtUninvokable
    public final int argumentCount(){
        return argumentCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int argumentCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#argumentsObject">QScriptContext::<wbr>argumentsObject()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue argumentsObject(){
        return argumentsObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue argumentsObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#backtrace">QScriptContext::<wbr>backtrace()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList backtrace(){
        return backtrace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList backtrace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#callee">QScriptContext::<wbr>callee()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue callee(){
        return callee_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue callee_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#engine">QScriptContext::<wbr>engine()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@Nullable QScriptEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#isCalledAsConstructor">QScriptContext::<wbr>isCalledAsConstructor()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isCalledAsConstructor(){
        return isCalledAsConstructor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isCalledAsConstructor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#parentContext">QScriptContext::<wbr>parentContext()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@Nullable QScriptContext parentContext(){
        return parentContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptContext parentContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QScriptContext::<wbr>popScope()</code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue popScope(){
        return popScope_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue popScope_native(long __this__nativeId);
    
    /**
     * <p>See <code>QScriptContext::<wbr>pushScope(QScriptValue)</code></p>
     */
    @QtUninvokable
    public final void pushScope(io.qt.script.@NonNull QScriptValue object){
        pushScope_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object));
    }
    
    @QtUninvokable
    private native void pushScope_native_cref_QScriptValue(long __this__nativeId, long object);
    
    /**
     * <p>See <code>QScriptContext::<wbr>returnValue()const</code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue returnValue(){
        return returnValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue returnValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#setActivationObject">QScriptContext::<wbr>setActivationObject(QScriptValue)</a></code></p>
     */
    @QtUninvokable
    public final void setActivationObject(io.qt.script.@NonNull QScriptValue activation){
        setActivationObject_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(activation));
    }
    
    @QtUninvokable
    private native void setActivationObject_native_cref_QScriptValue(long __this__nativeId, long activation);
    
    /**
     * <p>See <code>QScriptContext::<wbr>setReturnValue(QScriptValue)</code></p>
     */
    @QtUninvokable
    public final void setReturnValue(io.qt.script.@NonNull QScriptValue result){
        setReturnValue_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(result));
    }
    
    @QtUninvokable
    private native void setReturnValue_native_cref_QScriptValue(long __this__nativeId, long result);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#setThisObject">QScriptContext::<wbr>setThisObject(QScriptValue)</a></code></p>
     */
    @QtUninvokable
    public final void setThisObject(io.qt.script.@NonNull QScriptValue thisObject){
        setThisObject_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(thisObject));
    }
    
    @QtUninvokable
    private native void setThisObject_native_cref_QScriptValue(long __this__nativeId, long thisObject);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#state">QScriptContext::<wbr>state()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.QScriptContext.@NonNull ExecutionState state(){
        return io.qt.script.QScriptContext.ExecutionState.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#thisObject">QScriptContext::<wbr>thisObject()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue thisObject(){
        return thisObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue thisObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#throwError">QScriptContext::<wbr>throwError(QScriptContext::Error,<wbr>QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue throwError(io.qt.script.QScriptContext.@NonNull Error error, java.lang.@NonNull String text){
        return throwError_native_QScriptContext_Error_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), error.value(), text);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue throwError_native_QScriptContext_Error_cref_QString(long __this__nativeId, int error, java.lang.String text);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#throwError-1">QScriptContext::<wbr>throwError(QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue throwError(java.lang.@NonNull String text){
        return throwError_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), text);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue throwError_native_cref_QString(long __this__nativeId, java.lang.String text);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#throwValue">QScriptContext::<wbr>throwValue(QScriptValue)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue throwValue(io.qt.script.@NonNull QScriptValue value){
        return throwValue_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue throwValue_native_cref_QScriptValue(long __this__nativeId, long value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscriptcontext.html#toString">QScriptContext::<wbr>toString()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String toString(){
        return toString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String toString_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScriptContext(QPrivateConstructor p) { super(p); } 
    
}
