package io.qt.script;

import io.qt.*;


/**
 * <p>The result of a script syntax check</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html">QScriptSyntaxCheckResult</a></p>
 */
public class QScriptSyntaxCheckResult extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#State-enum">QScriptSyntaxCheckResult::State</a></p>
     */
    public enum State implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#State-enum">QScriptSyntaxCheckResult::Error</a></p>
         */
        Error(0),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#State-enum">QScriptSyntaxCheckResult::Intermediate</a></p>
         */
        Intermediate(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#State-enum">QScriptSyntaxCheckResult::Valid</a></p>
         */
        Valid(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private State(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull State resolve(int value) {
            switch (value) {
            case 0: return Error;
            case 1: return Intermediate;
            case 2: return Valid;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#QScriptSyntaxCheckResult">QScriptSyntaxCheckResult::QScriptSyntaxCheckResult(QScriptSyntaxCheckResult)</a></p>
     */
    public QScriptSyntaxCheckResult(io.qt.script.@NonNull QScriptSyntaxCheckResult other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QScriptSyntaxCheckResult instance, io.qt.script.QScriptSyntaxCheckResult other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#errorColumnNumber">QScriptSyntaxCheckResult::errorColumnNumber()const</a></p>
     */
    @QtUninvokable
    public final int errorColumnNumber(){
        return errorColumnNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int errorColumnNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#errorLineNumber">QScriptSyntaxCheckResult::errorLineNumber()const</a></p>
     */
    @QtUninvokable
    public final int errorLineNumber(){
        return errorLineNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int errorLineNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#errorMessage">QScriptSyntaxCheckResult::errorMessage()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String errorMessage(){
        return errorMessage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorMessage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#operator-eq">QScriptSyntaxCheckResult::operator=(QScriptSyntaxCheckResult)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.script.@NonNull QScriptSyntaxCheckResult other){
        assign_native_cref_QScriptSyntaxCheckResult(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QScriptSyntaxCheckResult(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptsyntaxcheckresult.html#state">QScriptSyntaxCheckResult::state()const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.QScriptSyntaxCheckResult.@NonNull State state(){
        return io.qt.script.QScriptSyntaxCheckResult.State.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QScriptSyntaxCheckResult(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QScriptSyntaxCheckResult clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QScriptSyntaxCheckResult clone_native(long __this_nativeId);
}
