package io.qt.script;

import io.qt.*;


/**
 * <p>Represents a Qt Script function invocation</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qscriptcontext.html">QScriptContext</a></p>
 */
public final class QScriptContext extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::Error</a></p>
     */
    public enum Error implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::UnknownError</a></p>
         */
        UnknownError(0),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::ReferenceError</a></p>
         */
        ReferenceError(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::SyntaxError</a></p>
         */
        SyntaxError(2),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::TypeError</a></p>
         */
        TypeError(3),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::RangeError</a></p>
         */
        RangeError(4),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::URIError</a></p>
         */
        URIError(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Error resolve(int value) {
            switch (value) {
            case 0: return UnknownError;
            case 1: return ReferenceError;
            case 2: return SyntaxError;
            case 3: return TypeError;
            case 4: return RangeError;
            case 5: return URIError;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptcontext.html#ExecutionState-enum">QScriptContext::ExecutionState</a></p>
     */
    public enum ExecutionState implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qscriptcontext.html#ExecutionState-enum">QScriptContext::NormalState</a></p>
         */
        NormalState(0),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qscriptcontext.html#ExecutionState-enum">QScriptContext::ExceptionState</a></p>
         */
        ExceptionState(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ExecutionState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ExecutionState resolve(int value) {
            switch (value) {
            case 0: return NormalState;
            case 1: return ExceptionState;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#activationObject">QScriptContext::activationObject()const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue activationObject(){
        return activationObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue activationObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#argument">QScriptContext::argument(int)const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue argument(int index){
        return argument_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue argument_native_int_constfct(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#argumentCount">QScriptContext::argumentCount()const</a></p>
     */
    @QtUninvokable
    public final int argumentCount(){
        return argumentCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int argumentCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#argumentsObject">QScriptContext::argumentsObject()const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue argumentsObject(){
        return argumentsObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue argumentsObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#backtrace">QScriptContext::backtrace()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList backtrace(){
        return backtrace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList backtrace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#callee">QScriptContext::callee()const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue callee(){
        return callee_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue callee_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#engine">QScriptContext::engine()const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@Nullable QScriptEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#isCalledAsConstructor">QScriptContext::isCalledAsConstructor()const</a></p>
     */
    @QtUninvokable
    public final boolean isCalledAsConstructor(){
        return isCalledAsConstructor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isCalledAsConstructor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#parentContext">QScriptContext::parentContext()const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@Nullable QScriptContext parentContext(){
        return parentContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptContext parentContext_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue popScope(){
        return popScope_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue popScope_native(long __this__nativeId);
    
    @QtUninvokable
    public final void pushScope(io.qt.script.@NonNull QScriptValue object){
        pushScope_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object));
    }
    
    @QtUninvokable
    private native void pushScope_native_cref_QScriptValue(long __this__nativeId, long object);
    
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue returnValue(){
        return returnValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue returnValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#setActivationObject">QScriptContext::setActivationObject(QScriptValue)</a></p>
     */
    @QtUninvokable
    public final void setActivationObject(io.qt.script.@NonNull QScriptValue activation){
        setActivationObject_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(activation));
    }
    
    @QtUninvokable
    private native void setActivationObject_native_cref_QScriptValue(long __this__nativeId, long activation);
    
    @QtUninvokable
    public final void setReturnValue(io.qt.script.@NonNull QScriptValue result){
        setReturnValue_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(result));
    }
    
    @QtUninvokable
    private native void setReturnValue_native_cref_QScriptValue(long __this__nativeId, long result);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#setThisObject">QScriptContext::setThisObject(QScriptValue)</a></p>
     */
    @QtUninvokable
    public final void setThisObject(io.qt.script.@NonNull QScriptValue thisObject){
        setThisObject_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(thisObject));
    }
    
    @QtUninvokable
    private native void setThisObject_native_cref_QScriptValue(long __this__nativeId, long thisObject);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#state">QScriptContext::state()const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.QScriptContext.@NonNull ExecutionState state(){
        return io.qt.script.QScriptContext.ExecutionState.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#thisObject">QScriptContext::thisObject()const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue thisObject(){
        return thisObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue thisObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#throwError">QScriptContext::throwError(QScriptContext::Error,QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue throwError(io.qt.script.QScriptContext.@NonNull Error error, java.lang.@NonNull String text){
        return throwError_native_QScriptContext_Error_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), error.value(), text);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue throwError_native_QScriptContext_Error_cref_QString(long __this__nativeId, int error, java.lang.String text);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#throwError-1">QScriptContext::throwError(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue throwError(java.lang.@NonNull String text){
        return throwError_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), text);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue throwError_native_cref_QString(long __this__nativeId, java.lang.String text);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#throwValue">QScriptContext::throwValue(QScriptValue)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue throwValue(io.qt.script.@NonNull QScriptValue value){
        return throwValue_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue throwValue_native_cref_QScriptValue(long __this__nativeId, long value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#toString">QScriptContext::toString()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String toString(){
        return toString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String toString_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QScriptContext(QPrivateConstructor p) { super(p); } 
    
}
