package io.qt.script;

import io.qt.*;


/**
 * <p>Iterator interface for custom Qt Script objects</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html">QScriptClassPropertyIterator</a></p>
 */
public abstract class QScriptClassPropertyIterator extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @NativeAccess
    private static final class ConcreteWrapper extends QScriptClassPropertyIterator {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public boolean hasNext(){
            return hasNext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native boolean hasNext_native_constfct(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public boolean hasPrevious(){
            return hasPrevious_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native boolean hasPrevious_native_constfct(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public io.qt.script.@NonNull QScriptString name(){
            return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native io.qt.script.QScriptString name_native_constfct(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void next(){
            next_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void next_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void previous(){
            previous_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void previous_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void toBack(){
            toBack_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void toBack_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void toFront(){
            toFront_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void toFront_native(long __this__nativeId);
        
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#QScriptClassPropertyIterator">QScriptClassPropertyIterator::QScriptClassPropertyIterator(QScriptValue)</a></p>
     */
    protected QScriptClassPropertyIterator(io.qt.script.@NonNull QScriptValue object){
        super((QPrivateConstructor)null);
        initialize_native(this, object);
    }
    
    private native static void initialize_native(QScriptClassPropertyIterator instance, io.qt.script.QScriptValue object);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#object">QScriptClassPropertyIterator::object()const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue object(){
        return object_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue object_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#flags">QScriptClassPropertyIterator::flags()const</a></p>
     */
    @QtUninvokable
    public io.qt.script.QScriptValue.@NonNull PropertyFlags flags(){
        return new io.qt.script.QScriptValue.PropertyFlags(flags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int flags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#hasNext">QScriptClassPropertyIterator::hasNext()const</a></p>
     */
    @QtUninvokable
    public abstract boolean hasNext();
    
    @QtUninvokable
    private native boolean hasNext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#hasPrevious">QScriptClassPropertyIterator::hasPrevious()const</a></p>
     */
    @QtUninvokable
    public abstract boolean hasPrevious();
    
    @QtUninvokable
    private native boolean hasPrevious_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#id">QScriptClassPropertyIterator::id()const</a></p>
     */
    @QtUninvokable
    public int id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#name">QScriptClassPropertyIterator::name()const</a></p>
     */
    @QtUninvokable
    public abstract io.qt.script.@NonNull QScriptString name();
    
    @QtUninvokable
    private native io.qt.script.QScriptString name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#next">QScriptClassPropertyIterator::next()</a></p>
     */
    @QtUninvokable
    public abstract void next();
    
    @QtUninvokable
    private native void next_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#previous">QScriptClassPropertyIterator::previous()</a></p>
     */
    @QtUninvokable
    public abstract void previous();
    
    @QtUninvokable
    private native void previous_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#toBack">QScriptClassPropertyIterator::toBack()</a></p>
     */
    @QtUninvokable
    public abstract void toBack();
    
    @QtUninvokable
    private native void toBack_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#toFront">QScriptClassPropertyIterator::toFront()</a></p>
     */
    @QtUninvokable
    public abstract void toFront();
    
    @QtUninvokable
    private native void toFront_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QScriptClassPropertyIterator(QPrivateConstructor p) { super(p); } 
    
}
