package io.qt.script;

import io.qt.*;


/**
 * <p>Encapsulates a Qt Script program</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qscriptprogram.html">QScriptProgram</a></p>
 */
public class QScriptProgram extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptprogram.html#QScriptProgram">QScriptProgram::QScriptProgram()</a></p>
     */
    public QScriptProgram(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QScriptProgram instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptprogram.html#QScriptProgram-2">QScriptProgram::QScriptProgram(QScriptProgram)</a></p>
     */
    public QScriptProgram(io.qt.script.@NonNull QScriptProgram other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QScriptProgram instance, io.qt.script.QScriptProgram other);
    
    /**
     * <p>Overloaded constructor for {@link #(java.lang.String, java.lang.String, int)}
     *  with <code>firstLineNumber = 1</code>.</p>
     */
    public QScriptProgram(java.lang.@NonNull String sourceCode, java.lang.@NonNull String fileName) {
        this(sourceCode, fileName, (int)1);
    }
    
    /**
     * <p>Overloaded constructor for {@link #(java.lang.String, java.lang.String, int)}</p>
     * <p>with: </p><ul>
     * <li><code>fileName = (String)null</code></li>
     * <li><code>firstLineNumber = 1</code></li>
     * </ul>
     */
    public QScriptProgram(java.lang.@NonNull String sourceCode) {
        this(sourceCode, (String)null, (int)1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptprogram.html#QScriptProgram-1">QScriptProgram::QScriptProgram(QString,QString,int)</a></p>
     */
    public QScriptProgram(java.lang.@NonNull String sourceCode, java.lang.@NonNull String fileName, int firstLineNumber){
        super((QPrivateConstructor)null);
        initialize_native(this, sourceCode, fileName, firstLineNumber);
    }
    
    private native static void initialize_native(QScriptProgram instance, java.lang.String sourceCode, java.lang.String fileName, int firstLineNumber);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptprogram.html#fileName">QScriptProgram::fileName()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String fileName(){
        return fileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String fileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptprogram.html#firstLineNumber">QScriptProgram::firstLineNumber()const</a></p>
     */
    @QtUninvokable
    public final int firstLineNumber(){
        return firstLineNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int firstLineNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptprogram.html#isNull">QScriptProgram::isNull()const</a></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptprogram.html#operator-eq">QScriptProgram::operator=(QScriptProgram)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.script.@NonNull QScriptProgram other){
        assign_native_cref_QScriptProgram(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QScriptProgram(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptprogram.html#operator-eq-eq">QScriptProgram::operator==(QScriptProgram)const</a></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.script.@NonNull QScriptProgram other){
        return operator_equal_native_cref_QScriptProgram_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QScriptProgram_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptprogram.html#sourceCode">QScriptProgram::sourceCode()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String sourceCode(){
        return sourceCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String sourceCode_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QScriptProgram(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.script.QScriptProgram) {
            return operator_equal((io.qt.script.QScriptProgram) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @QtUninvokable
    @Override
    public QScriptProgram clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QScriptProgram clone_native(long __this_nativeId);
}
