package io.qt.script;

import io.qt.*;


/**
 * <p>Environment for evaluating Qt Script code</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qscriptengine.html">QScriptEngine</a></p>
 */
public class QScriptEngine extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScriptEngine.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptengine.html#QObjectWrapOption-enum">QScriptEngine::QObjectWrapOption</a></p>
     * 
     * @see QObjectWrapOptions
     */
    public enum QObjectWrapOption implements QtFlagEnumerator {
        ExcludeChildObjects(1),
        ExcludeSuperClassMethods(2),
        ExcludeSuperClassProperties(4),
        ExcludeSuperClassContents(6),
        SkipMethodsInEnumeration(8),
        ExcludeDeleteLater(16),
        ExcludeSlots(32),
        AutoCreateDynamicProperties(256),
        PreferExistingWrapperObject(512);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private QObjectWrapOption(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public QObjectWrapOptions asFlags() {
            return new QObjectWrapOptions(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public QObjectWrapOptions combined(QObjectWrapOption e) {
            return new QObjectWrapOptions(this, e);
        }

        /**
         * Creates a new {@link QObjectWrapOptions} from the entries.
         * @param values entries
         * @return new flag
         */
        public static QObjectWrapOptions flags(QObjectWrapOption ... values) {
            return new QObjectWrapOptions(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static QObjectWrapOption resolve(int value) {
            switch (value) {
            case 1: return ExcludeChildObjects;
            case 2: return ExcludeSuperClassMethods;
            case 4: return ExcludeSuperClassProperties;
            case 6: return ExcludeSuperClassContents;
            case 8: return SkipMethodsInEnumeration;
            case 16: return ExcludeDeleteLater;
            case 32: return ExcludeSlots;
            case 256: return AutoCreateDynamicProperties;
            case 512: return PreferExistingWrapperObject;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link QObjectWrapOption}
     */
    public static final class QObjectWrapOptions extends QFlags<QObjectWrapOption> implements Comparable<QObjectWrapOptions> {
        private static final long serialVersionUID = 0xb5e6169d58306d5L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new QObjectWrapOptions where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public QObjectWrapOptions(QObjectWrapOption ... args){
            super(args);
        }

        /**
         * Creates a new QObjectWrapOptions with given <code>value</code>.
         * @param value
         */
        public QObjectWrapOptions(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new QObjectWrapOptions
         */
        @Override
        public final QObjectWrapOptions combined(QObjectWrapOption e){
            return new QObjectWrapOptions(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final QObjectWrapOptions setFlag(QObjectWrapOption e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final QObjectWrapOptions setFlag(QObjectWrapOption e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this QObjectWrapOptions.
         * @return array of enum entries
         */
        @Override
        public final QObjectWrapOption[] flags(){
            return super.flags(QObjectWrapOption.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final QObjectWrapOptions clone(){
            return new QObjectWrapOptions(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(QObjectWrapOptions other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptengine.html#ValueOwnership-enum">QScriptEngine::ValueOwnership</a></p>
     */
    @QtUnlistedEnum
    public enum ValueOwnership implements QtEnumerator {
        QtOwnership(0),
        ScriptOwnership(1),
        AutoOwnership(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ValueOwnership(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ValueOwnership resolve(int value) {
            switch (value) {
            case 0: return QtOwnership;
            case 1: return ScriptOwnership;
            case 2: return AutoOwnership;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt function pointer <a href="http://doc.qt.io/qt-5/qscriptengine.html#FunctionSignature-typedef">QScriptEngine::FunctionSignature</a></p>
     */
    @FunctionalInterface
    public interface FunctionSignature extends QtObjectInterface, java.util.function.BiFunction<io.qt.script.@Nullable QScriptContext, io.qt.script.@Nullable QScriptEngine, io.qt.script.@NonNull QScriptValue> {

        @Override
        public io.qt.script.@NonNull QScriptValue apply(io.qt.script.@Nullable QScriptContext arg__1, io.qt.script.@Nullable QScriptEngine arg__2);

        /**
         * <p>Implementor class for interface {@link FunctionSignature}</p>
         */
        public static abstract class Impl extends QtObject implements FunctionSignature{
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }

            protected Impl(QPrivateConstructor p){
                super(p);
            }

            private static native void initialize_native(FunctionSignature instance);

            @NativeAccess
            private final static class ConcreteWrapper extends Impl {
                private ConcreteWrapper(QPrivateConstructor c){
                    super(c);
                }

                @Override
                public io.qt.script.@NonNull QScriptValue apply(io.qt.script.@Nullable QScriptContext arg__1, io.qt.script.@Nullable QScriptEngine arg__2){
                    return apply_native(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
                }

                private native io.qt.script.QScriptValue apply_native(long arg__1, long arg__2);
            }

        }
    }


    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#signalHandlerException">QScriptEngine::signalHandlerException(QScriptValue)</a></p>
     */
    public final @NonNull Signal1<io.qt.script.@NonNull QScriptValue> signalHandlerException = new Signal1<>();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#QScriptEngine">QScriptEngine::QScriptEngine()</a></p>
     */
    public QScriptEngine(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QScriptEngine instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#QScriptEngine-1">QScriptEngine::QScriptEngine(QObject*)</a></p>
     */
    public QScriptEngine(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
        if (parent != null) QtJambi_LibraryUtilities.internal.setCppOwnership(this);
    }
    
    private native static void initialize_native(QScriptEngine instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded function for {@link #abortEvaluation(io.qt.script.QScriptValue)}
     *  with <code>result = new io.qt.script.QScriptValue()</code>.</p>
     */
    @QtUninvokable
    public final void abortEvaluation() {
        abortEvaluation(new io.qt.script.QScriptValue());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#abortEvaluation">QScriptEngine::abortEvaluation(QScriptValue)</a></p>
     */
    @QtUninvokable
    public final void abortEvaluation(io.qt.script.@NonNull QScriptValue result){
        abortEvaluation_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(result));
    }
    
    @QtUninvokable
    private native void abortEvaluation_native_cref_QScriptValue(long __this__nativeId, long result);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#agent">QScriptEngine::agent()const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@Nullable QScriptEngineAgent agent(){
        return agent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptEngineAgent agent_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#availableExtensions">QScriptEngine::availableExtensions()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList availableExtensions(){
        return availableExtensions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList availableExtensions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine-obsolete.html#canEvaluate">QScriptEngine::canEvaluate(QString)const</a></p>
     */
    @QtUninvokable
    public final boolean canEvaluate(java.lang.@NonNull String program){
        return canEvaluate_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native boolean canEvaluate_native_cref_QString_constfct(long __this__nativeId, java.lang.String program);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#clearExceptions">QScriptEngine::clearExceptions()</a></p>
     */
    @QtUninvokable
    public final void clearExceptions(){
        clearExceptions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clearExceptions_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#collectGarbage">QScriptEngine::collectGarbage()</a></p>
     */
    @QtUninvokable
    public final void collectGarbage(){
        collectGarbage_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void collectGarbage_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#currentContext">QScriptEngine::currentContext()const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@Nullable QScriptContext currentContext(){
        return currentContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptContext currentContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#defaultPrototype">QScriptEngine::defaultPrototype(int)const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue defaultPrototype(int metaTypeId){
        return defaultPrototype_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), metaTypeId);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue defaultPrototype_native_int_constfct(long __this__nativeId, int metaTypeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#evaluate-1">QScriptEngine::evaluate(QScriptProgram)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue evaluate(io.qt.script.@NonNull QScriptProgram program){
        return evaluate_native_cref_QScriptProgram(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(program));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue evaluate_native_cref_QScriptProgram(long __this__nativeId, long program);
    
    /**
     * <p>Overloaded function for {@link #evaluate(java.lang.String, java.lang.String, int)}
     *  with <code>lineNumber = 1</code>.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue evaluate(java.lang.@NonNull String program, java.lang.@NonNull String fileName) {
        return evaluate(program, fileName, (int)1);
    }
    
    /**
     * <p>Overloaded function for {@link #evaluate(java.lang.String, java.lang.String, int)}</p>
     * <p>with: </p><ul>
     * <li><code>fileName = (String)null</code></li>
     * <li><code>lineNumber = 1</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue evaluate(java.lang.@NonNull String program) {
        return evaluate(program, (String)null, (int)1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#evaluate">QScriptEngine::evaluate(QString,QString,int)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue evaluate(java.lang.@NonNull String program, java.lang.@NonNull String fileName, int lineNumber){
        return evaluate_native_cref_QString_cref_QString_int(QtJambi_LibraryUtilities.internal.nativeId(this), program, fileName, lineNumber);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue evaluate_native_cref_QString_cref_QString_int(long __this__nativeId, java.lang.String program, java.lang.String fileName, int lineNumber);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#globalObject">QScriptEngine::globalObject()const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue globalObject(){
        return globalObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue globalObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#hasUncaughtException">QScriptEngine::hasUncaughtException()const</a></p>
     */
    @QtUninvokable
    public final boolean hasUncaughtException(){
        return hasUncaughtException_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasUncaughtException_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#importExtension">QScriptEngine::importExtension(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue importExtension(java.lang.@NonNull String extension){
        return importExtension_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), extension);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue importExtension_native_cref_QString(long __this__nativeId, java.lang.String extension);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#importedExtensions">QScriptEngine::importedExtensions()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList importedExtensions(){
        return importedExtensions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList importedExtensions_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #installTranslatorFunctions(io.qt.script.QScriptValue)}
     *  with <code>object = new io.qt.script.QScriptValue()</code>.</p>
     */
    @QtUninvokable
    public final void installTranslatorFunctions() {
        installTranslatorFunctions(new io.qt.script.QScriptValue());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#installTranslatorFunctions">QScriptEngine::installTranslatorFunctions(QScriptValue)</a></p>
     */
    @QtUninvokable
    public final void installTranslatorFunctions(io.qt.script.@NonNull QScriptValue object){
        installTranslatorFunctions_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object));
    }
    
    @QtUninvokable
    private native void installTranslatorFunctions_native_cref_QScriptValue(long __this__nativeId, long object);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#isEvaluating">QScriptEngine::isEvaluating()const</a></p>
     */
    @QtUninvokable
    public final boolean isEvaluating(){
        return isEvaluating_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isEvaluating_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newActivationObject(){
        return newActivationObject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue newActivationObject_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #newArray(int)}
     *  with <code>length = 0</code>.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newArray() {
        return newArray((int)0);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#newArray">QScriptEngine::newArray(uint)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newArray(int length){
        return newArray_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), length);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue newArray_native_uint(long __this__nativeId, int length);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#newDate-1">QScriptEngine::newDate(QDateTime)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newDate(io.qt.core.@NonNull QDateTime value){
        return newDate_native_cref_QDateTime(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue newDate_native_cref_QDateTime(long __this__nativeId, long value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#newDate">QScriptEngine::newDate(qsreal)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newDate(double value){
        return newDate_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue newDate_native_double(long __this__nativeId, double value);
    
    /**
     * <p>Overloaded function for {@link #newFunction(io.qt.script.QScriptEngine.FunctionSignature, io.qt.script.QScriptValue, int)}
     *  with <code>length = 0</code>.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newFunction(io.qt.script.QScriptEngine.@Nullable FunctionSignature signature, io.qt.script.@NonNull QScriptValue prototype) {
        return newFunction(signature, prototype, (int)0);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#newFunction-1">QScriptEngine::newFunction(QScriptEngine::FunctionSignature,QScriptValue,int)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newFunction(io.qt.script.QScriptEngine.@Nullable FunctionSignature signature, io.qt.script.@NonNull QScriptValue prototype, int length){
        return newFunction_native_QScriptEngine_FunctionSignature_cref_QScriptValue_int(QtJambi_LibraryUtilities.internal.nativeId(this), signature, QtJambi_LibraryUtilities.internal.checkedNativeId(prototype), length);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue newFunction_native_QScriptEngine_FunctionSignature_cref_QScriptValue_int(long __this__nativeId, io.qt.script.QScriptEngine.FunctionSignature signature, long prototype, int length);
    
    /**
     * <p>Overloaded function for {@link #newFunction(io.qt.script.QScriptEngine.FunctionSignature, int)}
     *  with <code>length = 0</code>.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newFunction(io.qt.script.QScriptEngine.@Nullable FunctionSignature signature) {
        return newFunction(signature, (int)0);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#newFunction">QScriptEngine::newFunction(QScriptEngine::FunctionSignature,int)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newFunction(io.qt.script.QScriptEngine.@Nullable FunctionSignature signature, int length){
        return newFunction_native_QScriptEngine_FunctionSignature_int(QtJambi_LibraryUtilities.internal.nativeId(this), signature, length);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue newFunction_native_QScriptEngine_FunctionSignature_int(long __this__nativeId, io.qt.script.QScriptEngine.FunctionSignature signature, int length);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#newObject">QScriptEngine::newObject()</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newObject(){
        return newObject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue newObject_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #newObject(io.qt.script.QScriptClass, io.qt.script.QScriptValue)}
     *  with <code>data = new io.qt.script.QScriptValue()</code>.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newObject(io.qt.script.@Nullable QScriptClass scriptClass) {
        return newObject(scriptClass, new io.qt.script.QScriptValue());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#newObject-1">QScriptEngine::newObject(QScriptClass*,QScriptValue)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newObject(io.qt.script.@Nullable QScriptClass scriptClass, io.qt.script.@NonNull QScriptValue data){
        return newObject_native_QScriptClass_ptr_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scriptClass), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue newObject_native_QScriptClass_ptr_cref_QScriptValue(long __this__nativeId, long scriptClass, long data);
    
    /**
     * <p>Overloaded function for {@link #newQObject(io.qt.core.QObject, io.qt.script.QScriptEngine.ValueOwnership, io.qt.script.QScriptEngine.QObjectWrapOptions)}.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newQObject(io.qt.core.@Nullable QObject object, io.qt.script.QScriptEngine.@NonNull ValueOwnership ownership, io.qt.script.QScriptEngine.@NonNull QObjectWrapOption @NonNull... options){
        return newQObject(object, ownership, new io.qt.script.QScriptEngine.QObjectWrapOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #newQObject(io.qt.core.QObject, io.qt.script.QScriptEngine.ValueOwnership, io.qt.script.QScriptEngine.QObjectWrapOptions)}
     *  with <code>options = new io.qt.script.QScriptEngine.QObjectWrapOptions(0)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newQObject(io.qt.core.@Nullable QObject object, io.qt.script.QScriptEngine.@NonNull ValueOwnership ownership) {
        return newQObject(object, ownership, new io.qt.script.QScriptEngine.QObjectWrapOptions(0));
    }
    
    /**
     * <p>Overloaded function for {@link #newQObject(io.qt.core.QObject, io.qt.script.QScriptEngine.ValueOwnership, io.qt.script.QScriptEngine.QObjectWrapOptions)}</p>
     * <p>with: </p><ul>
     * <li><code>ownership = io.qt.script.QScriptEngine.ValueOwnership.QtOwnership</code></li>
     * <li><code>options = new io.qt.script.QScriptEngine.QObjectWrapOptions(0)</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newQObject(io.qt.core.@Nullable QObject object) {
        return newQObject(object, io.qt.script.QScriptEngine.ValueOwnership.QtOwnership, new io.qt.script.QScriptEngine.QObjectWrapOptions(0));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#newQObject">QScriptEngine::newQObject(QObject*,QScriptEngine::ValueOwnership,QScriptEngine::QObjectWrapOptions)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newQObject(io.qt.core.@Nullable QObject object, io.qt.script.QScriptEngine.@NonNull ValueOwnership ownership, io.qt.script.QScriptEngine.@NonNull QObjectWrapOptions options){
        return newQObject_native_QObject_ptr_QScriptEngine_ValueOwnership_cref_QScriptEngine_QObjectWrapOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), ownership.value(), options.value());
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue newQObject_native_QObject_ptr_QScriptEngine_ValueOwnership_cref_QScriptEngine_QObjectWrapOptions(long __this__nativeId, long object, int ownership, int options);
    
    /**
     * <p>Overloaded function for {@link #newQObject(io.qt.script.QScriptValue, io.qt.core.QObject, io.qt.script.QScriptEngine.ValueOwnership, io.qt.script.QScriptEngine.QObjectWrapOptions)}.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newQObject(io.qt.script.@NonNull QScriptValue scriptObject, io.qt.core.@Nullable QObject qtObject, io.qt.script.QScriptEngine.@NonNull ValueOwnership ownership, io.qt.script.QScriptEngine.@NonNull QObjectWrapOption @NonNull... options){
        return newQObject(scriptObject, qtObject, ownership, new io.qt.script.QScriptEngine.QObjectWrapOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #newQObject(io.qt.script.QScriptValue, io.qt.core.QObject, io.qt.script.QScriptEngine.ValueOwnership, io.qt.script.QScriptEngine.QObjectWrapOptions)}
     *  with <code>options = new io.qt.script.QScriptEngine.QObjectWrapOptions(0)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newQObject(io.qt.script.@NonNull QScriptValue scriptObject, io.qt.core.@Nullable QObject qtObject, io.qt.script.QScriptEngine.@NonNull ValueOwnership ownership) {
        return newQObject(scriptObject, qtObject, ownership, new io.qt.script.QScriptEngine.QObjectWrapOptions(0));
    }
    
    /**
     * <p>Overloaded function for {@link #newQObject(io.qt.script.QScriptValue, io.qt.core.QObject, io.qt.script.QScriptEngine.ValueOwnership, io.qt.script.QScriptEngine.QObjectWrapOptions)}</p>
     * <p>with: </p><ul>
     * <li><code>ownership = io.qt.script.QScriptEngine.ValueOwnership.QtOwnership</code></li>
     * <li><code>options = new io.qt.script.QScriptEngine.QObjectWrapOptions(0)</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newQObject(io.qt.script.@NonNull QScriptValue scriptObject, io.qt.core.@Nullable QObject qtObject) {
        return newQObject(scriptObject, qtObject, io.qt.script.QScriptEngine.ValueOwnership.QtOwnership, new io.qt.script.QScriptEngine.QObjectWrapOptions(0));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#newQObject-1">QScriptEngine::newQObject(QScriptValue,QObject*,QScriptEngine::ValueOwnership,QScriptEngine::QObjectWrapOptions)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newQObject(io.qt.script.@NonNull QScriptValue scriptObject, io.qt.core.@Nullable QObject qtObject, io.qt.script.QScriptEngine.@NonNull ValueOwnership ownership, io.qt.script.QScriptEngine.@NonNull QObjectWrapOptions options){
        return newQObject_native_cref_QScriptValue_QObject_ptr_QScriptEngine_ValueOwnership_cref_QScriptEngine_QObjectWrapOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scriptObject), QtJambi_LibraryUtilities.internal.checkedNativeId(qtObject), ownership.value(), options.value());
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue newQObject_native_cref_QScriptValue_QObject_ptr_QScriptEngine_ValueOwnership_cref_QScriptEngine_QObjectWrapOptions(long __this__nativeId, long scriptObject, long qtObject, int ownership, int options);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#newRegExp">QScriptEngine::newRegExp(QRegExp)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newRegExp(io.qt.core.@NonNull QRegExp regexp){
        return newRegExp_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(regexp));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue newRegExp_native_cref_QRegExp(long __this__nativeId, long regexp);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#newRegExp-1">QScriptEngine::newRegExp(QString,QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newRegExp(java.lang.@NonNull String pattern, java.lang.@NonNull String flags){
        return newRegExp_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), pattern, flags);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue newRegExp_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String pattern, java.lang.String flags);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#newVariant-1">QScriptEngine::newVariant(QScriptValue,QVariant)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newVariant(io.qt.script.@NonNull QScriptValue object, java.lang.Object value){
        return newVariant_native_cref_QScriptValue_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), value);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue newVariant_native_cref_QScriptValue_cref_QVariant(long __this__nativeId, long object, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#newVariant">QScriptEngine::newVariant(QVariant)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue newVariant(java.lang.Object value){
        return newVariant_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue newVariant_native_cref_QVariant(long __this__nativeId, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#nullValue">QScriptEngine::nullValue()</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue nullValue(){
        return nullValue_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue nullValue_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#popContext">QScriptEngine::popContext()</a></p>
     */
    @QtUninvokable
    public final void popContext(){
        popContext_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void popContext_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#processEventsInterval">QScriptEngine::processEventsInterval()const</a></p>
     */
    @QtUninvokable
    public final int processEventsInterval(){
        return processEventsInterval_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int processEventsInterval_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#pushContext">QScriptEngine::pushContext()</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@Nullable QScriptContext pushContext(){
        return pushContext_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptContext pushContext_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#reportAdditionalMemoryCost">QScriptEngine::reportAdditionalMemoryCost(int)</a></p>
     */
    @QtUninvokable
    public final void reportAdditionalMemoryCost(int size){
        reportAdditionalMemoryCost_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @QtUninvokable
    private native void reportAdditionalMemoryCost_native_int(long __this__nativeId, int size);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#setAgent">QScriptEngine::setAgent(QScriptEngineAgent*)</a></p>
     */
    @QtUninvokable
    public final void setAgent(io.qt.script.@Nullable QScriptEngineAgent agent){
        setAgent_native_QScriptEngineAgent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(agent));
    }
    
    @QtUninvokable
    private native void setAgent_native_QScriptEngineAgent_ptr(long __this__nativeId, long agent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#setDefaultPrototype">QScriptEngine::setDefaultPrototype(int,QScriptValue)</a></p>
     */
    @QtUninvokable
    public final void setDefaultPrototype(int metaTypeId, io.qt.script.@NonNull QScriptValue prototype){
        setDefaultPrototype_native_int_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), metaTypeId, QtJambi_LibraryUtilities.internal.checkedNativeId(prototype));
    }
    
    @QtUninvokable
    private native void setDefaultPrototype_native_int_cref_QScriptValue(long __this__nativeId, int metaTypeId, long prototype);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#setGlobalObject">QScriptEngine::setGlobalObject(QScriptValue)</a></p>
     */
    @QtUninvokable
    public final void setGlobalObject(io.qt.script.@NonNull QScriptValue object){
        setGlobalObject_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object));
    }
    
    @QtUninvokable
    private native void setGlobalObject_native_cref_QScriptValue(long __this__nativeId, long object);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#setProcessEventsInterval">QScriptEngine::setProcessEventsInterval(int)</a></p>
     */
    @QtUninvokable
    public final void setProcessEventsInterval(int interval){
        setProcessEventsInterval_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), interval);
    }
    
    @QtUninvokable
    private native void setProcessEventsInterval_native_int(long __this__nativeId, int interval);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#toObject">QScriptEngine::toObject(QScriptValue)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue toObject(io.qt.script.@NonNull QScriptValue value){
        return toObject_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue toObject_native_cref_QScriptValue(long __this__nativeId, long value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#toStringHandle">QScriptEngine::toStringHandle(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptString toStringHandle(java.lang.@NonNull String str){
        return toStringHandle_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), str);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptString toStringHandle_native_cref_QString(long __this__nativeId, java.lang.String str);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#uncaughtException">QScriptEngine::uncaughtException()const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue uncaughtException(){
        return uncaughtException_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue uncaughtException_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#uncaughtExceptionBacktrace">QScriptEngine::uncaughtExceptionBacktrace()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList uncaughtExceptionBacktrace(){
        return uncaughtExceptionBacktrace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList uncaughtExceptionBacktrace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#uncaughtExceptionLineNumber">QScriptEngine::uncaughtExceptionLineNumber()const</a></p>
     */
    @QtUninvokable
    public final int uncaughtExceptionLineNumber(){
        return uncaughtExceptionLineNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int uncaughtExceptionLineNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#undefinedValue">QScriptEngine::undefinedValue()</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@NonNull QScriptValue undefinedValue(){
        return undefinedValue_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue undefinedValue_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptengine.html#checkSyntax">QScriptEngine::checkSyntax(QString)</a></p>
     */
    public native static io.qt.script.@NonNull QScriptSyntaxCheckResult checkSyntax(java.lang.@NonNull String program);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QScriptEngine(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QScriptEngine(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QScriptEngine instance, QDeclarativeConstructor constructor);
    
}
