package io.qt.script;

import io.qt.*;


/**
 * <p>Interface for defining custom behavior of (a class of) Qt Script objects</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qscriptclass.html">QScriptClass</a></p>
 */
public class QScriptClass extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptclass.html#Extension-enum">QScriptClass::Extension</a></p>
     */
    public enum Extension implements QtEnumerator {
        Callable(0),
        HasInstance(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Extension(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Extension resolve(int value) {
            switch (value) {
            case 0: return Callable;
            case 1: return HasInstance;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptclass.html#QueryFlag-enum">QScriptClass::QueryFlag</a></p>
     * 
     * @see QueryFlags
     */
    public enum QueryFlag implements QtFlagEnumerator {
        HandlesReadAccess(1),
        HandlesWriteAccess(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private QueryFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public QueryFlags asFlags() {
            return new QueryFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public QueryFlags combined(QueryFlag e) {
            return new QueryFlags(this, e);
        }

        /**
         * Creates a new {@link QueryFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static QueryFlags flags(QueryFlag ... values) {
            return new QueryFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static QueryFlag resolve(int value) {
            switch (value) {
            case 1: return HandlesReadAccess;
            case 2: return HandlesWriteAccess;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link QueryFlag}
     */
    public static final class QueryFlags extends QFlags<QueryFlag> implements Comparable<QueryFlags> {
        private static final long serialVersionUID = 0x11b03667a4066df4L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new QueryFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public QueryFlags(QueryFlag ... args){
            super(args);
        }

        /**
         * Creates a new QueryFlags with given <code>value</code>.
         * @param value
         */
        public QueryFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new QueryFlags
         */
        @Override
        public final QueryFlags combined(QueryFlag e){
            return new QueryFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final QueryFlags setFlag(QueryFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final QueryFlags setFlag(QueryFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this QueryFlags.
         * @return array of enum entries
         */
        @Override
        public final QueryFlag[] flags(){
            return super.flags(QueryFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final QueryFlags clone(){
            return new QueryFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(QueryFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclass.html#QScriptClass">QScriptClass::QScriptClass(QScriptEngine*)</a></p>
     */
    public QScriptClass(io.qt.script.@Nullable QScriptEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, engine);
    }
    
    private native static void initialize_native(QScriptClass instance, io.qt.script.QScriptEngine engine);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclass.html#engine">QScriptClass::engine()const</a></p>
     */
    @QtUninvokable
    public final io.qt.script.@Nullable QScriptEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #extension(io.qt.script.QScriptClass.Extension, java.lang.Object)}
     *  with <code>argument = null</code>.</p>
     */
    @QtUninvokable
    public final java.lang.Object extension(io.qt.script.QScriptClass.@NonNull Extension extension) {
        return extension(extension, (java.lang.Object)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclass.html#extension">QScriptClass::extension(QScriptClass::Extension,QVariant)</a></p>
     */
    @QtUninvokable
    public java.lang.Object extension(io.qt.script.QScriptClass.@NonNull Extension extension, java.lang.Object argument){
        return extension_native_QScriptClass_Extension_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), extension.value(), argument);
    }
    
    @QtUninvokable
    private native java.lang.Object extension_native_QScriptClass_Extension_cref_QVariant(long __this__nativeId, int extension, java.lang.Object argument);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclass.html#name">QScriptClass::name()const</a></p>
     */
    @QtUninvokable
    public java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclass.html#newIterator">QScriptClass::newIterator(QScriptValue)</a></p>
     */
    @QtUninvokable
    public io.qt.script.@NonNull QScriptClassPropertyIterator newIterator(io.qt.script.@NonNull QScriptValue object){
        return newIterator_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object));
    }
    
    @QtUninvokable
    private native io.qt.script.@NonNull QScriptClassPropertyIterator newIterator_native_cref_QScriptValue(long __this__nativeId, long object);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclass.html#property">QScriptClass::property(QScriptValue,QScriptString,uint)</a></p>
     */
    @QtUninvokable
    public io.qt.script.@NonNull QScriptValue property(io.qt.script.@NonNull QScriptValue object, io.qt.script.@NonNull QScriptString name, int id){
        return property_native_cref_QScriptValue_cref_QScriptString_uint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), QtJambi_LibraryUtilities.internal.checkedNativeId(name), id);
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue property_native_cref_QScriptValue_cref_QScriptString_uint(long __this__nativeId, long object, long name, int id);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclass.html#propertyFlags">QScriptClass::propertyFlags(QScriptValue,QScriptString,uint)</a></p>
     */
    @QtUninvokable
    public io.qt.script.QScriptValue.@NonNull PropertyFlags propertyFlags(io.qt.script.@NonNull QScriptValue object, io.qt.script.@NonNull QScriptString name, int id){
        return new io.qt.script.QScriptValue.PropertyFlags(propertyFlags_native_cref_QScriptValue_cref_QScriptString_uint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), QtJambi_LibraryUtilities.internal.checkedNativeId(name), id));
    }
    
    @QtUninvokable
    private native int propertyFlags_native_cref_QScriptValue_cref_QScriptString_uint(long __this__nativeId, long object, long name, int id);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclass.html#prototype">QScriptClass::prototype()const</a></p>
     */
    @QtUninvokable
    public io.qt.script.@NonNull QScriptValue prototype(){
        return prototype_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.script.QScriptValue prototype_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclass.html#queryProperty">QScriptClass::queryProperty(QScriptValue,QScriptString,QScriptClass::QueryFlags,uint*)</a></p>
     */
    @QtUninvokable
    public io.qt.script.QScriptClass.@NonNull QueryFlags queryProperty(io.qt.script.@NonNull QScriptValue object, io.qt.script.@NonNull QScriptString name, io.qt.script.QScriptClass.@NonNull QueryFlags flags, java.lang.@Nullable Integer id){
        return new io.qt.script.QScriptClass.QueryFlags(queryProperty_native_cref_QScriptValue_cref_QScriptString_QScriptClass_QueryFlags_uint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), QtJambi_LibraryUtilities.internal.checkedNativeId(name), flags.value(), id));
    }
    
    @QtUninvokable
    private native int queryProperty_native_cref_QScriptValue_cref_QScriptString_QScriptClass_QueryFlags_uint_ptr(long __this__nativeId, long object, long name, int flags, java.lang.@Nullable Integer id);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclass.html#setProperty">QScriptClass::setProperty(QScriptValue&amp;,QScriptString,uint,QScriptValue)</a></p>
     */
    @QtUninvokable
    public void setProperty(io.qt.script.@StrictNonNull QScriptValue object, io.qt.script.@NonNull QScriptString name, int id, io.qt.script.@NonNull QScriptValue value){
        java.util.Objects.requireNonNull(object, "Argument 'object': null not expected.");
        setProperty_native_ref_QScriptValue_cref_QScriptString_uint_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), QtJambi_LibraryUtilities.internal.checkedNativeId(name), id, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setProperty_native_ref_QScriptValue_cref_QScriptString_uint_cref_QScriptValue(long __this__nativeId, long object, long name, int id, long value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclass.html#supportsExtension">QScriptClass::supportsExtension(QScriptClass::Extension)const</a></p>
     */
    @QtUninvokable
    public boolean supportsExtension(io.qt.script.QScriptClass.@NonNull Extension extension){
        return supportsExtension_native_QScriptClass_Extension_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), extension.value());
    }
    
    @QtUninvokable
    private native boolean supportsExtension_native_QScriptClass_Extension_constfct(long __this__nativeId, int extension);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QScriptClass(QPrivateConstructor p) { super(p); } 
    
}
