package io.qt.script;


/**
 * <p>Additional information about a QScriptContext</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html">QScriptContextInfo</a></p>
 */
public class QScriptContextInfo extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#FunctionType-enum">QScriptContextInfo::FunctionType</a></p>
     */
    public enum FunctionType implements io.qt.QtEnumerator {
        ScriptFunction(0),
        QtFunction(1),
        QtPropertyFunction(2),
        NativeFunction(3);

        private FunctionType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static FunctionType resolve(int value) {
            switch (value) {
            case 0: return ScriptFunction;
            case 1: return QtFunction;
            case 2: return QtPropertyFunction;
            case 3: return NativeFunction;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#QScriptContextInfo-2">QScriptContextInfo::QScriptContextInfo()</a></p>
     */
    public QScriptContextInfo(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QScriptContextInfo instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#QScriptContextInfo">QScriptContextInfo::QScriptContextInfo(const QScriptContext*)</a></p>
     */
    public QScriptContextInfo(io.qt.script.QScriptContext context){
        super((QPrivateConstructor)null);
        initialize_native(this, context);
    }
    
    private native static void initialize_native(QScriptContextInfo instance, io.qt.script.QScriptContext context);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#QScriptContextInfo-1">QScriptContextInfo::QScriptContextInfo(QScriptContextInfo)</a></p>
     */
    public QScriptContextInfo(io.qt.script.QScriptContextInfo other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QScriptContextInfo instance, io.qt.script.QScriptContextInfo other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo-obsolete.html#columnNumber">QScriptContextInfo::columnNumber()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int columnNumber(){
        return columnNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int columnNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#fileName">QScriptContextInfo::fileName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String fileName(){
        return fileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String fileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#functionEndLineNumber">QScriptContextInfo::functionEndLineNumber()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int functionEndLineNumber(){
        return functionEndLineNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int functionEndLineNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#functionMetaIndex">QScriptContextInfo::functionMetaIndex()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int functionMetaIndex(){
        return functionMetaIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int functionMetaIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#functionName">QScriptContextInfo::functionName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String functionName(){
        return functionName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String functionName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#functionParameterNames">QScriptContextInfo::functionParameterNames()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList functionParameterNames(){
        return functionParameterNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList functionParameterNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#functionStartLineNumber">QScriptContextInfo::functionStartLineNumber()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int functionStartLineNumber(){
        return functionStartLineNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int functionStartLineNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#functionType">QScriptContextInfo::functionType()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptContextInfo.FunctionType functionType(){
        return io.qt.script.QScriptContextInfo.FunctionType.resolve(functionType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int functionType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#isNull">QScriptContextInfo::isNull()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#lineNumber">QScriptContextInfo::lineNumber()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int lineNumber(){
        return lineNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int lineNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#operator-lt-lt">operator&lt;&lt;(QDataStream&amp;,QScriptContextInfo)</a></p>
     */
    @io.qt.QtUninvokable
    public void writeTo(io.qt.core.QDataStream arg__1){
        java.util.Objects.requireNonNull(arg__1, "Argument 'arg__1': null not expected.");
        writeTo_native_ref_QDataStream(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void writeTo_native_ref_QDataStream(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#operator-eq-eq">QScriptContextInfo::operator==(QScriptContextInfo)const</a></p>
     */
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.script.QScriptContextInfo other){
        return operator_equal_native_cref_QScriptContextInfo_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QScriptContextInfo_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#operator-gt-gt">operator&gt;&gt;(QDataStream&amp;,QScriptContextInfo&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public void readFrom(io.qt.core.QDataStream arg__1){
        java.util.Objects.requireNonNull(arg__1, "Argument 'arg__1': null not expected.");
        readFrom_native_ref_QDataStream(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void readFrom_native_ref_QDataStream(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontextinfo.html#scriptId">QScriptContextInfo::scriptId()const</a></p>
     */
    @io.qt.QtUninvokable
    public final long scriptId(){
        return scriptId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native long scriptId_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QScriptContextInfo(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.script.QScriptContextInfo) {
            return operator_equal((io.qt.script.QScriptContextInfo) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @Override
    public QScriptContextInfo clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QScriptContextInfo clone_native(long __this_nativeId);
}
