package io.qt.script;


/**
 * <p>Represents a Qt Script function invocation</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qscriptcontext.html">QScriptContext</a></p>
 */
public final class QScriptContext extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptcontext.html#Error-enum">QScriptContext::Error</a></p>
     */
    public enum Error implements io.qt.QtEnumerator {
        UnknownError(0),
        ReferenceError(1),
        SyntaxError(2),
        TypeError(3),
        RangeError(4),
        URIError(5);

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Error resolve(int value) {
            switch (value) {
            case 0: return UnknownError;
            case 1: return ReferenceError;
            case 2: return SyntaxError;
            case 3: return TypeError;
            case 4: return RangeError;
            case 5: return URIError;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptcontext.html#ExecutionState-enum">QScriptContext::ExecutionState</a></p>
     */
    public enum ExecutionState implements io.qt.QtEnumerator {
        NormalState(0),
        ExceptionState(1);

        private ExecutionState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ExecutionState resolve(int value) {
            switch (value) {
            case 0: return NormalState;
            case 1: return ExceptionState;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#activationObject">QScriptContext::activationObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue activationObject(){
        return activationObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue activationObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#argument">QScriptContext::argument(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue argument(int index){
        return argument_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue argument_native_int_constfct(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#argumentCount">QScriptContext::argumentCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int argumentCount(){
        return argumentCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int argumentCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#argumentsObject">QScriptContext::argumentsObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue argumentsObject(){
        return argumentsObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue argumentsObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#backtrace">QScriptContext::backtrace()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList backtrace(){
        return backtrace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList backtrace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#callee">QScriptContext::callee()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue callee(){
        return callee_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue callee_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#engine">QScriptContext::engine()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#isCalledAsConstructor">QScriptContext::isCalledAsConstructor()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isCalledAsConstructor(){
        return isCalledAsConstructor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isCalledAsConstructor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#parentContext">QScriptContext::parentContext()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptContext parentContext(){
        return parentContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptContext parentContext_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue popScope(){
        return popScope_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue popScope_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void pushScope(io.qt.script.QScriptValue object){
        pushScope_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object));
    }
    
    @io.qt.QtUninvokable
    private native void pushScope_native_cref_QScriptValue(long __this__nativeId, long object);
    
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue returnValue(){
        return returnValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue returnValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#setActivationObject">QScriptContext::setActivationObject(QScriptValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setActivationObject(io.qt.script.QScriptValue activation){
        setActivationObject_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(activation));
    }
    
    @io.qt.QtUninvokable
    private native void setActivationObject_native_cref_QScriptValue(long __this__nativeId, long activation);
    
    @io.qt.QtUninvokable
    public final void setReturnValue(io.qt.script.QScriptValue result){
        setReturnValue_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(result));
    }
    
    @io.qt.QtUninvokable
    private native void setReturnValue_native_cref_QScriptValue(long __this__nativeId, long result);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#setThisObject">QScriptContext::setThisObject(QScriptValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setThisObject(io.qt.script.QScriptValue thisObject){
        setThisObject_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(thisObject));
    }
    
    @io.qt.QtUninvokable
    private native void setThisObject_native_cref_QScriptValue(long __this__nativeId, long thisObject);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#state">QScriptContext::state()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptContext.ExecutionState state(){
        return io.qt.script.QScriptContext.ExecutionState.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#thisObject">QScriptContext::thisObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue thisObject(){
        return thisObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue thisObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#throwError">QScriptContext::throwError(QScriptContext::Error,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue throwError(io.qt.script.QScriptContext.Error error, java.lang.String text){
        return throwError_native_QScriptContext_Error_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), error.value(), text);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue throwError_native_QScriptContext_Error_cref_QString(long __this__nativeId, int error, java.lang.String text);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#throwError-1">QScriptContext::throwError(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue throwError(java.lang.String text){
        return throwError_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), text);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue throwError_native_cref_QString(long __this__nativeId, java.lang.String text);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#throwValue">QScriptContext::throwValue(QScriptValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue throwValue(io.qt.script.QScriptValue value){
        return throwValue_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue throwValue_native_cref_QScriptValue(long __this__nativeId, long value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptcontext.html#toString">QScriptContext::toString()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String toString(){
        return toString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String toString_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QScriptContext(QPrivateConstructor p) { super(p); } 
    
}
